/****** Object:  Database Nowinki    Script Date: 10-Jul-02 12:41:09 PM ******/
IF EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'Nowinki')
	DROP DATABASE [Nowinki]
GO

CREATE DATABASE [Nowinki]  ON (NAME = N'Nowinki_Data', FILENAME = N'c:\program files\microsoft sql server\mssql\data\Nowinki_Data.mdf' , SIZE = 3, FILEGROWTH = 10%) LOG ON (NAME = N'Nowinki_Log', FILENAME = N'c:\program files\microsoft sql server\mssql\data\Nowinki_Log.LDF' , SIZE = 3, FILEGROWTH = 10%)
 COLLATE Polish_CI_AI
GO

exec sp_dboption N'Nowinki', N'autoclose', N'false'
GO

exec sp_dboption N'Nowinki', N'bulkcopy', N'false'
GO

exec sp_dboption N'Nowinki', N'trunc. log', N'false'
GO

exec sp_dboption N'Nowinki', N'torn page detection', N'true'
GO

exec sp_dboption N'Nowinki', N'read only', N'false'
GO

exec sp_dboption N'Nowinki', N'dbo use', N'false'
GO

exec sp_dboption N'Nowinki', N'single', N'false'
GO

exec sp_dboption N'Nowinki', N'autoshrink', N'false'
GO

exec sp_dboption N'Nowinki', N'ANSI null default', N'false'
GO

exec sp_dboption N'Nowinki', N'recursive triggers', N'false'
GO

exec sp_dboption N'Nowinki', N'ANSI nulls', N'false'
GO

exec sp_dboption N'Nowinki', N'concat null yields null', N'false'
GO

exec sp_dboption N'Nowinki', N'cursor close on commit', N'false'
GO

exec sp_dboption N'Nowinki', N'default to local cursor', N'false'
GO

exec sp_dboption N'Nowinki', N'quoted identifier', N'false'
GO

exec sp_dboption N'Nowinki', N'ANSI warnings', N'false'
GO

exec sp_dboption N'Nowinki', N'auto create statistics', N'true'
GO

exec sp_dboption N'Nowinki', N'auto update statistics', N'true'
GO

use [Nowinki]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_tblZamowienia_tblKlienci]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[tblZamowienia] DROP CONSTRAINT FK_tblZamowienia_tblKlienci
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_tblPracownicy_tblDzialy]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[tblPracownicy] DROP CONSTRAINT FK_tblPracownicy_tblDzialy
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_tblPozycjeZamowienia_tblProdukty]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[tblPozycjeZamowienia] DROP CONSTRAINT FK_tblPozycjeZamowienia_tblProdukty
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_tblPozycjeZamowienia_tblZamowienia]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[tblPozycjeZamowienia] DROP CONSTRAINT FK_tblPozycjeZamowienia_tblZamowienia
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_tblKlienci_tblRegiony]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[tblKlienci] DROP CONSTRAINT FK_tblKlienci_tblRegiony
GO

/****** Object:  Trigger dbo.trKlientI    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trKlientI]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trKlientI]
GO

/****** Object:  Stored Procedure dbo.UsuwaniePracownika    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UsuwaniePracownika]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UsuwaniePracownika]
GO

/****** Object:  Stored Procedure dbo.KlientWedlugID    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[KlientWedlugID]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[KlientWedlugID]
GO

/****** Object:  Stored Procedure dbo.WstawianiePracownika    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[WstawianiePracownika]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[WstawianiePracownika]
GO

/****** Object:  Stored Procedure dbo.WstawianiePracownikaOrg    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[WstawianiePracownikaOrg]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[WstawianiePracownikaOrg]
GO

/****** Object:  Stored Procedure dbo.WyszukiwanieNazwiska    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[WyszukiwanieNazwiska]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[WyszukiwanieNazwiska]
GO

/****** Object:  Stored Procedure dbo.WybieraniePracownikow    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[WybieraniePracownikow]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[WybieraniePracownikow]
GO

/****** Object:  Stored Procedure dbo.AktualizacjaPracownika    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AktualizacjaPracownika]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AktualizacjaPracownika]
GO

/****** Object:  Stored Procedure dbo.procPracownicyPosortowani    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[procPracownicyPosortowani]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[procPracownicyPosortowani]
GO

/****** Object:  View dbo.PracownikDzial_widok    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[PracownikDzial_widok]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[PracownikDzial_widok]
GO

/****** Object:  View dbo.Pracownicy_widok    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[qryPracownik_widok]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[Pracownicy_widok]
GO

/****** Object:  Table [dbo].[tblKlienci]    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblKlienci]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[tblKlienci]
GO

/****** Object:  Table [dbo].[tblDzialy]    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblDzialy]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[tblDzialy]
GO

/****** Object:  Table [dbo].[tblPracownicy]    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblPracownicy]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[tblPracownicy]
GO

/****** Object:  Table [dbo].[tblProdukty]    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblProdukty]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[tblProdukty]
GO

/****** Object:  Table [dbo].[tblZamowienia]    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblZamowienia]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[tblZamowienia]
GO

/****** Object:  Table [dbo].[tblPozycjeZamowienia]    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblPozycjeZamowienia]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[tblPozycjeZamowienia]
GO

/****** Object:  Table [dbo].[tblRegiony]    Script Date: 10-Jul-02 12:41:09 PM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblRegiony]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[tblRegiony]
GO

/****** Object:  Table [dbo].[tblKlienci]    Script Date: 10-Jul-02 12:41:10 PM ******/
CREATE TABLE [dbo].[tblKlienci] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[Imie] [varchar] (20) COLLATE Polish_CI_AI NULL ,
	[Nazwisko] [varchar] (30) COLLATE Polish_CI_AI NULL ,
	[Firma] [varchar] (50) COLLATE Polish_CI_AI NULL ,
	[Adres] [varchar] (50) COLLATE Polish_CI_AI NULL ,
	[Miasto] [varchar] (30) COLLATE Polish_CI_AI NULL ,
	[Wojewodztwo] [char] (3) COLLATE Polish_CI_AI NULL ,
	[KodPocztowy] [varchar] (6) COLLATE Polish_CI_AI NULL ,
	[Telefon] [varchar] (15) COLLATE Polish_CI_AI NULL ,
	[Faks] [varchar] (15) COLLATE Polish_CI_AI NULL ,
	[Email] [varchar] (100) COLLATE Polish_CI_AI NULL ,
	[NazwiskoSoundex] [varchar] (4) COLLATE Polish_CI_AI NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[tblDzialy]    Script Date: 10-Jul-02 12:41:11 PM ******/
CREATE TABLE [dbo].[tblDzialy] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[NazwaDzialu] [varchar] (75) COLLATE Polish_CI_AI NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[tblPracownicy]    Script Date: 10-Jul-02 12:41:11 PM ******/
CREATE TABLE [dbo].[tblPracownicy] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[Imie] [varchar] (50) COLLATE Polish_CI_AI NOT NULL ,
	[Nazwisko] [varchar] (70) COLLATE Polish_CI_AI NOT NULL ,
	[IDDzialu] [int] NULL ,
	[Pensja] [money] NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[tblProdukty]    Script Date: 10-Jul-02 12:41:11 PM ******/
CREATE TABLE [dbo].[tblProdukty] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[NazwaProduktu] [varchar] (75) COLLATE Polish_CI_AI NOT NULL ,
	[CenaHurtowa] [money] NULL ,
	[CenaDetaliczna] [money] NULL ,
	[Opis] [ntext] COLLATE Polish_CI_AI NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

/****** Object:  Table [dbo].[tblZamowienia]    Script Date: 10-Jul-02 12:41:12 PM ******/
CREATE TABLE [dbo].[tblZamowienia] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[IDKlienta] [int] NULL ,
	[DataZamowienia] [datetime] NULL ,
	[Kwota] [money] NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[tblPozycjeZamowienia]    Script Date: 10-Jul-02 12:41:12 PM ******/
CREATE TABLE [dbo].[tblPozycjeZamowienia] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[IDZamowienia] [int] NOT NULL ,
	[IDPozycji] [int] NOT NULL ,
	[Ilosc] [int] NULL ,
	[Koszt] [money] NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[tblRegiony]    Script Date: 10-Jul-02 12:41:12 PM ******/
CREATE TABLE [dbo].[tblRegiony] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[Wojewodztwo] [char] (3) COLLATE Polish_CI_AI NOT NULL ,
	[NazwaRegionu] [varchar] (25) COLLATE Polish_CI_AI NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[tblKlienci] WITH NOCHECK ADD 
	CONSTRAINT [PK_tblKlienci] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[tblDzialy] WITH NOCHECK ADD 
	CONSTRAINT [tblDzialy_IDPK] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[tblPracownicy] WITH NOCHECK ADD 
	CONSTRAINT [PK_tblPracownicy] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[tblProdukty] WITH NOCHECK ADD 
	CONSTRAINT [PK_tblProdukty] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[tblZamowienia] WITH NOCHECK ADD 
	CONSTRAINT [PK_tblZamowienia] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[tblPozycjeZamowienia] WITH NOCHECK ADD 
	CONSTRAINT [PK_tblPozycjeZamowienia] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[tblRegiony] WITH NOCHECK ADD 
	CONSTRAINT [PK_tblRegiony] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

 CREATE  UNIQUE  INDEX [IX_tblRegiony] ON [dbo].[tblRegiony]([Wojewodztwo]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[tblKlienci] ADD 
	CONSTRAINT [FK_tblKlienci_tblRegiony] FOREIGN KEY 
	(
		[Wojewodztwo]
	) REFERENCES [dbo].[tblRegiony] (
		[Wojewodztwo]
	) ON DELETE CASCADE  ON UPDATE CASCADE 
GO

ALTER TABLE [dbo].[tblPracownicy] ADD 
	CONSTRAINT [FK_tblPracownicy_tblDzialy] FOREIGN KEY 
	(
		[IDDzialu]
	) REFERENCES [dbo].[tblDzialy] (
		[ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE 
GO

ALTER TABLE [dbo].[tblZamowienia] ADD 
	CONSTRAINT [FK_tblZamowienia_tblKlienci] FOREIGN KEY 
	(
		[IDKlienta]
	) REFERENCES [dbo].[tblKlienci] (
		[ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE 
GO

ALTER TABLE [dbo].[tblPozycjeZamowienia] ADD 
	CONSTRAINT [FK_tblPozycjeZamowienia_tblProdukty] FOREIGN KEY 
	(
		[IDPozycji]
	) REFERENCES [dbo].[tblProdukty] (
		[ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT [FK_tblPozycjeZamowienia_tblZamowienia] FOREIGN KEY 
	(
		[IDZamowienia]
	) REFERENCES [dbo].[tblZamowienia] (
		[ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  View dbo.PracownikDzial_widok    Script Date: 10-Jul-02 12:41:13 PM ******/

CREATE view PracownikDzial_widok
as
  select e.ID, Imie, Nazwisko, NazwaDzialu
  from tblPracownicy e, tblDzialy t
  where e.IDDzialu  = t.ID



GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  View dbo.qryPracownik_widok    Script Date: 10-Jul-02 12:41:13 PM ******/

CREATE VIEW Pracownicy_widok AS
    SELECT ID, Imie, Nazwisko, IDDzialu
    FROM tblPracownicy

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.UsuwaniePracownika    Script Date: 10-Jul-02 12:41:13 PM ******/
CREATE PROCEDURE dbo.UsuwaniePracownika
(
	@Pierwotny_ID int
)
AS
	SET NOCOUNT OFF;
DELETE FROM tblPracownicy WHERE (ID = @Pierwotny_ID)
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.KlientWedlugID    Script Date: 10-Jul-02 12:41:13 PM ******/
create procedure KlientWedlugID
   @IDklt int
   as
   select * from tblKlienci
   where ID = @IDklt


GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

/****** Object:  Stored Procedure dbo.WstawianiePracownika    Script Date: 10-Jul-02 12:41:13 PM ******/
CREATE PROCEDURE dbo.WstawianiePracownika
(
	@Imie varchar(50),
	@Nazwisko varchar(70),
	@IDDzialu int,
	@Pensja money
)
AS
	SET NOCOUNT OFF;


if (@Pensja = 0 or @Pensja is null)
begin
	-- Skomplikowane obliczenia pensji 
	set @Pensja = @IDDzialu * 10000
end

INSERT INTO tblPracownicy(Imie, Nazwisko, IDDzialu, Pensja) VALUES
		 (@Imie, @Nazwisko, @IDDzialu, @Pensja)
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.WstawianiePracownikaOrg    Script Date: 10-Jul-02 12:41:13 PM ******/
CREATE PROCEDURE dbo.WstawianiePracownikaOrg
(
	@Imie varchar(50),
	@Nazwisko varchar(70),
	@IDDzialu int,
	@Pensja money
)
AS
	SET NOCOUNT OFF;
INSERT INTO tblPracownicy(Imie, Nazwisko, IDDzialu, Pensja) VALUES (@Imie, @Nazwisko, @IDDzialu, @Pensja)
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.WyszukiwanieNazwiska    Script Date: 10-Jul-02 12:41:13 PM ******/
create proc WyszukiwanieNazwiska
  @nazwisko varchar(40)
as
select * from tblKlienci
where soundex(@nazwisko) = NazwiskoSoundex



GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.WybieraniePracownikow    Script Date: 10-Jul-02 12:41:13 PM ******/
CREATE PROCEDURE dbo.WybieraniePracownikow
AS
	SET NOCOUNT ON;
SELECT  Imie, Nazwisko, IDDzialu, Pensja, ID FROM tblPracownicy
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.AktualizacjaPracownika    Script Date: 10-Jul-02 12:41:13 PM ******/
CREATE PROCEDURE dbo.AktualizacjaPracownika
(
	@Imie varchar(50),
	@Nazwisko varchar(70),
	@IDDzialu int,
	@Pensja money,
	@Pierwotny_ID int
)
AS
	SET NOCOUNT OFF;
UPDATE tblPracownicy SET Imie = @Imie, Nazwisko = @Nazwisko, IDDzialu = @IDDzialu, Pensja = @Pensja WHERE (ID = @Pierwotny_ID)
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

/****** Object:  Stored Procedure dbo.procPracownicyPosortowani    Script Date: 10-Jul-02 12:41:13 PM ******/
CREATE PROCEDURE procPracownicyPosortowani AS 
	select  * from tblPracownicy
	order by Nazwisko, Imie
return
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Trigger dbo.trKlientI    Script Date: 10-Jul-02 12:41:14 PM ******/
create trigger trKlientI
on dbo.tblKlienci
for insert, update
as
   update tblKlienci
   set tblKlienci.NazwiskoSoundex = soundex(tblKlienci.Nazwisko)
   from inserted
   where tblKlienci.ID = inserted.ID

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('ZCH','')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('LBS','Zachd')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('DLN','Zachd')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('PMS','')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('WRM','Pnoc')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('PDL','Pnoc')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('KJP','Centrum')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('WLP','Centrum')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('LDZ','Centrum')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('MZW','Centrum')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('PDK','Wschd')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('LBL','')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('OPL','Poudnie')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('SLK','Poudnie')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('SWT','')
INSERT INTO tblRegiony (Wojewodztwo, NazwaRegionu) Values ('MLP','')

SET IDENTITY_INSERT tblDzialy ON
INSERT INTO tblDzialy (ID,NazwaDzialu) Values (1,'Administracja')
INSERT INTO tblDzialy (ID,NazwaDzialu) Values (2,'Produkcja')
INSERT INTO tblDzialy (ID,NazwaDzialu) Values (3,'Sprzeda')
INSERT INTO tblDzialy (ID,NazwaDzialu) Values (4,'Marketing')
SET IDENTITY_INSERT tblDzialy OFF
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Karolina','Wierzynek',2,222)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Katarzyna','Jankowska',2,13000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Eryk','Halik',4,12000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Julia','Rosiska',1,4000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Ryszard','Halpin',2,10000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Kamila','Jankowska',3,18000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Szymon','Polak',4,28000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Szymon','Terkowski',1,8000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Robert','Hartman',2,18000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Mateusz','Halik',3,30000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Katarzyna','Wierzynek',4,0)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Bartosz','Tomaski',2,12000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Janina','Egmont',2,26000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Stefan','Maraczyk',3,42000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Laura','Dawidowska',4,60000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Aniela','Stefanik',2,16000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Magorzata','Baset',2,34000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Jacek','Chwast',3,54000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Katarzyna','Chwast',4,76000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Teresa','Alesz',1,20000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Micha','Dobersztajn',2,42000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Teresa','Wieczorek',3,66000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Krystyna','Rolek',4,0)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Magorzata','Egmont',1,24000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Miosz','Lasocki',2,50000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Robert','Niedziela',3,78000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Kamila','Hornik',4,108000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Kamila','Eberman',1,28000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Ryszard','Rolek',2,58000)
INSERT INTO tblPracownicy (Imie, Nazwisko, IDDzialu,Pensja) Values ('Micha','Wieczorek',3,90000)
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Wojnowicz','Wolnoci 4','Pruszkw','PDL','98-609','(60) 4485994')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Jdraszek','Ligudy 12','Grochw','PDL','18-602','(91) 3669205')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Byczyska 12','Nowa Kunia','PDL','83-481','(40) 9310689')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Rzeszoto','Zakadowa 4','Dugoka','WLP','26-973','(50) 5245220')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hamak','Myska 12','Dbkowice','WLP','62-875','(61) 4066311')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Jdraszek','Ludowa 77','Kurw','WLP','59-609','(31) 8032214')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Polak','Dworcowa 3','Przychd','LBL','54-401','(40) 7260212')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Turo','Krakowska 78','Zimnica','LBL','08-965','(60) 6246867')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Hobica','Moniuszki 89','Stanisaww','LBL','09-793','(20) 9421728')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Hager','Wysockiego 7','awsk','SLK','79-013','(50) 4589191')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Wojnowicz','Wiejska 8','Pokrzywice','SLK','75-491','(80) 6713553')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Talko','Pocztowa 2','Pruszkw','SLK','99-677','(21) 7778219')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Egmont','Matejki 11','Czersk','MLP','50-907','(40) 5426563')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Marszaek','Piastowska 9','Muszyna','MLP','22-326','(30) 6243741')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Dawidek','Szarych Szeregw 99','Wielkie','MLP','80-778','(60) 3303170')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Stefanik','ymierskiego 12','Pokrzywki','LBS','04-812','(50) 3399275')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Baron','Zota 55','Makowice','LBS','08-856','(80) 7970849')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Chwist','Kochanowskiego 12','wirowo','LBS','13-874','(80) 6032432')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Chwist','Parkowa 4','Borowa Gra','ZCH','49-707','(78) 7607408')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Adamiak','Podborna 1','Szymanw','ZCH','80-426','(31) 9782132')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Dbiec','Krtka 2','Piskory','ZCH','16-777','(50) 2141202')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Drewniak','ukasiewicza 12','Makowice','LBL','37-282','(20) 9174070')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Romanowicz','Skargi 12','Niebytw','ZCH','58-594','(50) 8886247')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Egmont','Puaka 1','Kalenica','DLN','84-088','(60) 7941570')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Lewie','Ratuszowa 12','Knieja','DLN','31-229','(51) 7687617')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Niechcia','Nieduga 1','Palenisko','DLN','90-257','(21) 6795263')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hajduk','Litewska 9','Plesko','ZCH','27-036','(50) 6217793')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Eliasz','Reja 4','Pylnik','LBL','44-122','(60) 8771191')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Romanowicz','Akacjowa 6','Kamionka','WRM','20-505','(20) 2805185')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Drewniak','Chabrw 9','Strzelce','ZCH','82-193','(78) 9131431')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Turo','Nowowiejska 9','Cezarw','WRM','14-500','(70) 7838263')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Polak','Kamieniecka 1','Leajsk','MLP','20-359','(60) 6516709')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Talko','Filarskiego 22','Kodzko','LBL','96-267','(40) 3660611')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Stefanik','Straacka 13','Biernaty','SLK','33-909','(21) 2146722')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Turo','Wyspowa 43','Zoczew','MLP','37-582','(60) 4484534')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hajduk','Kopernika 9','Koswki','WRM','58-276','(60) 3795128')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Hepner','Kozielska 9','Oporw','DLN','98-404','(60) 4365030')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Rzeszoto','Dambonia 12','Pniew','LBL','07-338','(40) 5329441')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Janson','Lutosawskiego 1','Dugoka','WRM','18-443','(20) 2723247')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Maysz','Berliska 4','Nowogrdek','ZCH','31-184','(50) 2482283')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Egmont','Grudzicka 19','Sulisawice','LDZ','05-962','(21) 3312744')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Romanowicz','Rynek 32','Rembertw','WLP','60-210','(61) 3660717')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Kaczmarek','Mleczna 12','Kropida','LDZ','58-248','(20) 4354171')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Polak','Smoowa 9','Siemianw','LDZ','07-411','(61) 4586637')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Rzeszoto','Brzeska 23','Suchy Br','PDL','73-083','(40) 7550201')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Romanowicz','Zaporoska 19','Bylica','SWT','25-751','(20) 9404424')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Lewie','ytomierska 99','Grdek','SWT','35-607','(30) 3788808')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Talko','Polna 12','Ligota','SWT','42-493','(51) 7131334')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Drewniak','Szkolna 88','Bdziew','SLK','89-949','(50) 7186236')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Turo','Traugutta 12','Zawada','PDL','17-355','(40) 6059357')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Nawotka','Myliwiecka 1','Rzdowice','OPL','30-003','(80) 3404257')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Drewniak','Batorego 44','Kalenica','OPL','96-360','(40) 7022488')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Baron','Sowackiego 9','Osiecko','OPL','68-711','(40) 7722552')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Wojnowicz','1-go Maja 12','Kojno','OPL','58-283','(30) 6154652')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Polak','Konstytucji 3 Maja 12','Plesko','SLK','70-240','(50) 6927320')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Hobica','Plebiscytowa 9','Mysw','LDZ','75-526','(61) 7914736')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Eliasz','Andersa 3','Rdziny','MZW','54-431','(40) 8458452')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Marszaek','Apteczna 12','Wachw','ZCH','36-347','(31) 7185458')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Seweryn','Basztowa 9','Piaski','WRM','07-876','(70) 6826863')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Niechcia','Batorego 22','Ujcie','MZW','00-272','(31) 5107031')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Jdraszek','Berlinga 1','Winowo','MLP','61-020','(40) 6859829')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hajduk','Bohaterw Warszawy 1','Kopary','SWT','83-596','(51) 5468856')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Idzi','Brzechwy 2','Stalowa Wola','PDL','15-655','(91) 5659424')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Edelman','Chopina 15','Mynwka','LDZ','96-835','(61) 4391690')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Maciejewicz','Chrobrego 99','Zaborowo','LBS','32-172','(80) 4925395')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Adamiak','Damrota 1','Bodzanw','MZW','81-006','(30) 4008036')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hobica','Elsnera 19','Kluczbork','WRM','10-957','(70) 7456074')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Idzi','Fredry 51','Kodzko','PMS','14-603','(20) 2955693')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Stefanik','Jasnogrska 1','Gocina','PMS','27-305','(30) 9561169')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Drewniak','Karowicza 12','Wichw','PMS','88-165','(31) 6375715')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Rzeszoto','Kolejowa 99','Zychw','KJP','04-223','(40) 3117525')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hajduk','Konopnickiej 123','Wichw','ZCH','68-287','(31) 4235225')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Dawidek','Korfantego 9','Dugoka','LDZ','32-497','(21) 2996209')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Romanowicz','Koszyka 11','Plesko','PMS','97-962','(31) 4605811')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Egmont','Kocielna 2','Szydw','MZW','72-401','(30) 5740491')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Adamiak','Katedralna 12','Walendowo','KJP','05-126','(90) 2811478')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Chwist','Kraszewskiego 4','Pierzchnica','LDZ','96-423','(20) 3074598')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Rusin','Kwiatowa 21','Kamienniki','LDZ','16-277','(20) 9027364')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Edelman','Ligonia 3','Antoninek','ZCH','57-379','(50) 8051295')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Polak','Lompy 15','Hajnwka','PMS','97-058','(30) 3259696')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Janas','Maczka 1','Zembrzychowice','KJP','91-294','(40) 5709677')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Drewniak','Magistracka 15','Szczawno','KJP','66-660','(90) 8194707')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Rusin','Makuszyskiego 88','Sawkw','KJP','89-425','(70) 5748731')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Dawidek','Miarki 8','Natolin','PDK','57-924','(20) 9039471')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Reiss','Nakowskiej 3','Bagacz','SLK','98-794','(50) 9225533')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Egmont','Norwida 14','Osiecko','PDK','20-031','(80) 2715891')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Kokot','Ogiskiego 94','Suchy Br','MLP','35-623','(60) 6866171')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Maciejewicz','Okulickiego 12','Kalenica','PMS','85-640','(30) 5393291')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Dbiec','Opawska 3','Stanisaww','KJP','21-018','(40) 8739727')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Drewniak','Orzeszkowej 12','Kojno','SLK','49-355','(50) 9122351')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Kaczmarek','Papiernicza 1','Leajsk','WLP','73-309','(50) 3185926')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Eliasz','Poprzeczna 4','Pasieka','MLP','29-395','(40) 8154334')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Marszaek','Prusa 9','Szczedrzyk','PMS','16-403','(31) 8521284')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Polak','Skodowskiej-Curie 12','Pogorzeliska','PDL','09-340','(91) 9812835')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Polak','Spdzielcza 14','Szczodrw','OPL','88-514','(30) 7562855')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Niechcia','Strzelcw Bytomskich 4','Nieport','MZW','81-834','(61) 2705520')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Eliasz','widnicka 2','ambinowice','LBL','60-678','(20) 4389923')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Hager','Targowa 12','Strumienna','LDZ','41-116','(61) 8851571')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Talko','Tuwima 4','Chocianw','ZCH','99-394','(31) 5366224')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Drewniak','Tylna 1','Pokorniki','WRM','96-246','(20) 4770805')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hager','Wieniawskiego 12','Gniazdw','SWT','32-792','(30) 8057548')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Rusin','Wyszyskiego 5','Bulin','SWT','01-928','(51) 9873691')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Chwist','Zdrojowa 12','Kurw','PDL','04-676','(91) 3786816')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Drewniak','Plac Zgody 12','Biadacz','LDZ','28-756','(61) 3368727')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hajduk','Kaletnicza 12','Wierzchowiska','LBL','25-853','(20) 9554973')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Hager','Kalinowa 1','Paczkw','LDZ','19-822','(20) 3976901')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Jdraszek','Kamienna 13','Szymanw','ZCH','57-085','(50) 3251289')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Hamak','Kanaowa 2','Filipowo','MZW','05-502','(40) 9620203')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Janas','Karminowa 43','Brzezina','SLK','83-068','(80) 5567914')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Janas','Karpacka 5','Kluczbork','PDK','73-331','(70) 7544405')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Stefanik','Kasperka 12','Grdek','ZCH','61-793','(50) 2789787')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Maciejewicz','Kasprowicza 94','Wiciejowo','MZW','14-833','(30) 3696580')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Reiss','Kasprzaka 5','Niebytw','MZW','58-680','(31) 5803222')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Seweryn','Kasztanowa 9','Jankw','MLP','96-167','(30) 6197076')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Katowicka 1','Kropida','KJP','99-848','(40) 7400799')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Talko','Kielecka 99','Chyw','PMS','24-493','(20) 3599924')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Maysz','Kiliskiego 12','Kalenica','WLP','03-904','(31) 9396364')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Janas','Klonowa 12','Chodzie','MZW','06-902','(30) 4599878')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hamak','Kluczborska 4','Niwki','MLP','06-821','(60) 7286313')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Nawotka','Kodzka 1','Pokoty','SWT','28-032','(51) 4527380')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Talko','Konduktorska 12','Szerokie','ZCH','14-984','(78) 9549583')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Lewie','Konwiktorska 12','Pylnik','LBS','79-219','(80) 2918171')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Kaczmarek','Konego 5','Wierzchowiska','LDZ','72-801','(41) 4782228')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Adamiak','Konopackiej 33','Antoninek','WLP','27-711','(31) 7458340')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Seweryn','Konsularna 8','Pasieka','LDZ','62-254','(61) 5593290')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Stefanik','Konwalii 2','Pustkw','PMS','59-961','(30) 9916240')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hamak','Koraszewskiego 4','Dbkowice','PDK','98-432','(80) 5901238')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Chwist','Korczaka 55','Planica','LBL','65-484','(60) 3476730')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Wierzynek','Kosmonautw 1','Skibice','SLK','99-214','(50) 9702948')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Maysz','Kossaka 12','Stanisaww','MLP','85-238','(30) 6751086')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Chwist','Kosynierw 9','Gbie','MLP','27-213','(60) 7321255')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Rzeszoto','Koszaliska 12','Gniazdw','LBL','21-350','(20) 8926743')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Polak','Kotaja 4','Rudno','LDZ','38-357','(20) 4735657')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wojnowicz','Kotarbiskiego 12','Szczawno','WLP','80-022','(31) 4574835')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Nawotka','Kowalska 4','Czempinw','KJP','96-490','(40) 5884030')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Rusin','Szewska 4','Zapiecek','LDZ','44-545','(41) 9015760')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Niechcia','Wkiennicza 8','Rogowo','SWT','38-367','(51) 9600439')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Dawidek','Piekarska 12','Kamionka','PDL','00-238','(91) 3063228')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Rzeszoto','elazna 12','Przesieka','PMS','98-398','(30) 4961387')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Talko','Miedziana 4','Widowa','LBS','58-232','(80) 5623518')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Jdraszek','Koecka 12','Nowe Miasto','LBL','27-559','(60) 6733101')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Seweryn','Kubusia Puchatka 1','Gocina','PMS','49-956','(20) 3272913')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Janson','Krawiecka 4','Antoninek','MLP','65-791','(30) 6840702')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Drewniak','Kredytowa 9','Gniazdw','MZW','89-189','(30) 3196529')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Dawidek','Kremsera 44','Strumienna','LDZ','52-313','(21) 7381338')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Maciejewicz','Krlowej Jadwigi 44','Pogorzelica','MLP','23-581','(30) 6518001')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Idzi','Krokusw 7','Ostrda','ZCH','83-183','(31) 7107644')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Wojnowicz','Krta 4','Skrzypnik','SLK','22-492','(80) 4628759')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Hager','Krupnicza 8','Ludwinowo','LBL','50-514','(20) 7041099')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Turo','Krzanowicka 12','Jankw','WLP','73-035','(31) 7254854')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Seweryn','Kujawska 6','Chodzie','KJP','22-690','(90) 7004154')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Kokot','Kurpierza 14','Falmirowice','DLN','81-205','(21) 9139545')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dbiec','Kusociskiego 123','Kalinwka','LDZ','49-988','(20) 6802191')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Edelman','Wakowicza 19','Czersk','WLP','99-947','(31) 3942137')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Hepner','Walecki 48','Zimnica','PDK','04-958','(20) 3816685')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dawidek','Wandy 1','Halinw','LBL','31-070','(60) 4159766')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Chwist','Wapienna 8','Pogodna','KJP','91-940','(40) 4735142')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Eliasz','Warsztatowa 8','Biaobrzegi','KJP','72-843','(40) 3909115')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Niechcia','Waryskiego 8','Witowice','PDL','85-108','(91) 7228679')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Seweryn','Wasylewskiego 9','Zagwidzie','WLP','10-191','(50) 7149270')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Romanowicz','Wawrzynka 3','Przybyw','PMS','79-391','(30) 5253310')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Rzeszoto','Wiankowa 28','Skaryn','PDL','69-327','(60) 6254196')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Hager','Wielkopolska 90','Wichw','SWT','63-672','(30) 9736310')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Romanowicz','Maopolska 13','Muszyna','LBS','83-723','(80) 5554540')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Nawotka','Wiktora 9','Wrzeszcz','OPL','50-617','(40) 6505239')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Egmont','Wilsona 12','Paczkw','SWT','43-276','(20) 2718733')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Marszaek','Winiowa 12','Pogorzelica','WRM','22-528','(70) 6995461')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Talko','Gruszyska 12','Zbrosawice','WLP','23-560','(31) 2620620')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Wojnowicz','liwiecka 45','Krzyanwka','SWT','77-583','(20) 5742272')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Dbiec','Winogronowa 4','Wianki','PMS','17-023','(20) 4525067')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Maysz','Porzeczkowa 78','Igw','MLP','85-840','(30) 4187961')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Idzi','Cmentarna 9','Suchodolec','PDL','13-020','(91) 9277285')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Maciejewicz','Podkarpacka 12','Gocina','OPL','89-385','(40) 6683411')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Janson','Tatrzaska 9','Dbkowice','PDL','98-543','(40) 7299824')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Maysz','Sudecka 9','Jakubowice','PDL','05-995','(91) 8407072')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Chwist','Sdecka 12','Zychw','WRM','76-535','(20) 6066464')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Talko','Sdowa 6','Sulisawice','SLK','20-686','(50) 4910421')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hobica','Winowska 6','Chocice','PMS','23-649','(20) 5928465')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Romanowicz','Witkiewicza 9','Stoczek','SLK','74-537','(80) 7062220')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Edelman','Wodna 7','Aleksandrw','PMS','34-341','(20) 2934909')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Janas','Staropolska 9','Kopary','PMS','85-149','(31) 7216197')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Maciejewicz','Wodocigowa 64','Dbrwka','LBL','23-167','(20) 3418080')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Kaczmarek','Wojska Polskiego 5','Rdziny','DLN','58-114','(60) 4203978')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Turo','Koralowa 8','Gniedzina','MZW','82-156','(31) 5156123')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Szwacz','Jubilerska 7','Kopiczew','PMS','73-885','(20) 5016366')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Stefanik','Diamentowa 1','Cezarw','ZCH','15-134','(78) 5779436')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Chwist','Rubinowa 44','Stawice','LBL','59-404','(20) 2923307')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Janas','Szmaragdowa 9','Pokrzywki','PMS','95-879','(31) 5216523')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Rzeszoto','Ametystowa 1','Mokre','SLK','78-877','(50) 5681151')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Janas','Zielona 1','Piskory','WRM','21-980','(20) 2928272')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Reiss','Czerwona 7','Ozimek','PDL','03-059','(91) 5726033')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Polak','Niebieska 88','Bdziew','KJP','61-270','(70) 8654872')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Idzi','Biaa 12','Biernaty','PDK','41-429','(80) 9941481')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Maysz','Czarna 7','Wrzeszcz','PDL','12-718','(91) 7506851')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Drewniak','Kolorowa 99','Bagacz','PDK','46-640','(80) 8915587')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Edelman','Tczowa 8','Leajsk','ZCH','28-641','(31) 5975941')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Janas','ta 4','Bogucice','DLN','25-597','(21) 7270344')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Kaczmarek','Fioletowa 12','Krzywka','SLK','70-129','(50) 7823750')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Dawidek','Purpurowa 8','Szydw','SLK','16-559','(50) 6961983')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Egmont','Turkusowa 9','Nowe Miasto','LDZ','92-540','(20) 2484440')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Stefanik','Zimna 12','Hajnwka','SWT','16-629','(30) 5217406')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Wierzynek','Chodna 46','Chocice','SLK','82-953','(50) 2680911')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Seweryn','Wrbliska 4','Podbrzezie Grne','SWT','69-009','(51) 6857062')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Adamiak','Wska 9','Krzyanwka','PDL','96-444','(60) 2182181')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Adamiak','Szeroka 12','Pierzchnica','SLK','44-401','(50) 4817861')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Kaczmarek','Garncarska 12','Jawiec','KJP','63-074','(70) 6241939')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Hamak','Wsplna 5','Kopary','LDZ','75-910','(61) 4521965')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Rzeszoto','Wyczkowskiego 12','Lipinka','DLN','62-442','(51) 9640507')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Lewie','wirki i Wigury 5','Suchodolec','MLP','31-856','(30) 9954547')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Egmont','Wyzwolenia 12','Grochw','ZCH','87-706','(50) 6963646')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Janas','Wyszomirskiego 4','Skibice','SLK','35-838','(21) 3156876')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Romanowicz','Wyglendy 7','Paczyna','PDK','45-921','(20) 9902961')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Hamak','Baantowa 12','Skubianka','WRM','68-442','(20) 6761302')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Janas','Orla 8','Pniew','MZW','66-585','(30) 8414847')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hobica','Jarzbinowa 98','Chocice','PDL','09-970','(60) 9621004')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Idzi','Barlickiego 89','Jackowo','PDL','15-261','(60) 6308208')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Chwist','Batycka 8','Wiciejowo','KJP','08-548','(40) 8935576')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hajduk','Beowa 55','Rogowo','PDK','34-153','(20) 8180411')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Seweryn','Bielska 9','Chyw','PMS','83-015','(20) 8842815')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Hepner','Boczna 8','Sulisawice','MZW','56-513','(40) 4387206')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Talko','Borka 8','Kamionka','SWT','94-939','(30) 9180285')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Janas','Borwkowa 4','Gbie','PMS','66-747','(31) 2729556')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Baron','Jagodowa 43','Pruszkw','PDK','49-158','(20) 4139518')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Romanowicz','urawinowa 23','Pisk','MZW','03-097','(61) 5746630')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Talko','Browarna 1','Pustkw','OPL','07-202','(80) 4543929')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Hamak','Piwna 94','Krzywka','ZCH','24-785','(78) 2270393')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Talko','Brzegowa 9','Nieport','LDZ','22-992','(61) 3610803')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Talko','Nadbrzena 4','Koswki','PDK','90-477','(80) 3949542')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Janas','Budowlanych 5','Mynwka','WRM','35-172','(70) 7779942')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Chwist','Bukowa 3','Mynwka','MZW','19-956','(30) 7656728')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Lewie','Dbicka 4','Czempinw','SWT','75-457','(51) 8529817')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Polak','Kasztanowa 9','Oporw','SWT','35-863','(30) 6360313')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Wierzynek','Brzeziny 34','Pogodna','ZCH','77-378','(31) 4780309')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Seweryn','Bzw 4','Chocianw','SWT','07-405','(30) 5270104')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hepner','Bulwarowa 9','wirowo','MLP','94-781','(30) 3731406')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Janas','Einsteina 4','Paowice','DLN','42-882','(51) 2063798')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Chwist','Erenburga 12','Brochw','PDK','64-479','(80) 9874421')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Egmont','Etnografw 98','Konin','PDK','02-922','(70) 3844103')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Hajduk','Sadowa','Piawa','OPL','72-412','(80) 5920597')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Janas','Samborska 12','Rzdowice','MLP','31-283','(30) 3682752')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Polak','Sandomierska 8','Dugoka','MLP','07-700','(40) 3290185')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Chwist','Sasanki 5','Dobropole','WLP','25-127','(50) 9373886')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Kokot','Seledynowa 9','any','WLP','13-960','(31) 2132332')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Kaczmarek','Semaforowa 8','Iawa','PMS','91-608','(31) 3313508')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Janas','Sempoowskiej 3','Zawada','OPL','72-268','(30) 6425385')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Rusin','Sieradzka 66','Szczawno','WRM','62-664','(70) 2022998')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Jdraszek','Siewna 1','Wichw','MLP','75-130','(30) 2034450')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Polak','Skadowa 8','Pniew','DLN','64-893','(60) 2359893')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Maciejewicz','Sobieskiego 9','Gniedzina','SLK','75-853','(50) 7325290')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Turo','Sobtki 3','Daniec','MZW','66-380','(61) 2906408')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Dawidek','Niedzielna 9','Kamionka','MLP','22-667','(40) 4348926')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Romanowicz','Soneczna 4','Sawkw','SWT','47-348','(20) 3419407')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Seweryn','Deszczowa 8','Czarny Las','DLN','12-004','(21) 7992514')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Marszaek','Pochmurna 12','Przybyw','DLN','66-518','(51) 7057810')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Idzi','Pogodna 4','Zawada','LBS','20-282','(50) 5215353')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Adamiak','Skona 12','Stalowa Wola','LDZ','20-046','(20) 4166637')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Hamak','Skowronka 4','Gniazdw','SLK','98-584','(21) 9782124')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Talko','Sowika 5','Kozielice','MLP','14-904','(30) 6273167')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Idzi','Wrbliska 12','Winowo','PMS','39-602','(31) 8551677')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Wojnowicz','Skromna 4','Chodzie','WRM','03-609','(60) 9211934')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Jdraszek','Skrajna 1','Jeziorna','WRM','51-216','(70) 8783001')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Janas','Sosnowa 55','Stoczek','PDL','52-131','(60) 5962512')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Chwist','wierkowa 17','Limanw','SWT','96-099','(20) 6456180')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Sotysik','Sowicza 8','Widowa','PMS','37-900','(20) 4012335')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Baron','Spacerowa 1','Stawice','MZW','81-706','(30) 9174451')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Eliasz','Sportowa 12','ka','PMS','99-751','(31) 4053990')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Niechcia','Bokserska 45','Brzezina','LBS','10-031','(80) 9540714')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hepner','Lekkoatletw 12','Paczyna','WLP','86-707','(31) 2680731')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Stefanik','Ciarowcw 12','Piskory','PDK','21-497','(20) 6624059')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Chwist','Kolarzy 5','ambinowice','SLK','77-461','(21) 3851158')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Maysz','Wiolarzy 12','Pokrzywice','PDK','92-376','(80) 7360189')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Eliasz','Srebrna 4','Koswki','KJP','67-432','(70) 9913294')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Dbiec','Ssiedzka 1','Dbrwka','DLN','70-091','(21) 5638804')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Maciejewicz','Staffa 4','Mokre','ZCH','45-288','(50) 4920530')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Reiss','Stawowa 4','Nidowo','MZW','55-778','(30) 2740305')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Seweryn','Nowomiejska','Kosowice','LBL','05-777','(40) 8881144')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Egmont','Biedronki 12','Krzyw','ZCH','68-500','(50) 6957413')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Dawidek','Stryjska 12','Strumienna','OPL','70-779','(30) 3965376')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Kokot','Stolarska 87','Winiowiec','SWT','50-472','(30) 8157534')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Romanowicz','Styki 56','Borowina','OPL','15-430','(40) 7042274')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Chwist','Suchoborska 8','Zoty Jar','ZCH','97-674','(50) 4928977')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Rusin','Swornicka 66','Zychw','KJP','21-191','(70) 5685769')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Chwist','Subicka 8','Botnica','MZW','25-233','(40) 4171360')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Wojnowicz','Szawiowa 56','Skaryn','SLK','02-758','(80) 4060720')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Marszaek','Chmielna 44','Zaborowo','KJP','01-944','(70) 2866804')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hamak','Mitowa 6','Korzonkowo','WLP','80-670','(50) 3679877')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Lewie','Solna 8','Krzyw','SLK','13-306','(50) 3710757')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Jdraszek','Nowosolna 5','Zakroczym','PDK','96-490','(20) 9656986')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Maysz','Starosdecka 8','Oarw','LDZ','37-454','(20) 6432533')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Adamiak','Szczeszyskiego 88','Nogat','WLP','92-449','(50) 3287517')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Drewniak','Patrolowa 9','Skaryn','KJP','43-347','(70) 6511929')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Kokot','Wojskowa 87','Chyw','SLK','02-409','(80) 7532712')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Drewniak','Okopna 8','Gniedzina','DLN','45-605','(21) 3039491')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Idzi','Modzierzowa 8','Strumienna','LBS','26-030','(80) 6485946')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Hepner','Armatnia 56','Kocielisko','WLP','75-359','(50) 3487291')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Kaczmarek','Chemikw 89','Piskory','LDZ','83-028','(21) 9171597')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Edelman','Inynierska 8','Trzebicz','MZW','51-490','(40) 7165301')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Kokot','Czeska 12','Zbiersk','PDL','69-369','(40) 6771912')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Hager','Rosyjska 8','Niebytw','LDZ','61-633','(21) 7058703')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Edelman','Sowacka 88','Jankw','MLP','62-296','(40) 5780574')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Seweryn','Niemiecka 8','Czersk','SLK','87-327','(21) 3804745')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Janson','Szwedzka 5','Lipinka','SWT','46-068','(20) 2018948')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Niechcia','Paryska 8','Drwale','LBS','32-678','(80) 3597959')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Maciejewicz','Praska 9','Kozietuy','ZCH','55-267','(78) 2118226')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Kaczmarek','Bratysawska 45','Skrzypnik','SLK','40-906','(80) 5765872')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Maciejewicz','Warszawska 55','Zimnica','OPL','57-562','(80) 9331921')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Kaczmarek','Moskiewska 5','Obory','OPL','08-168','(80) 3732515')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Eliasz','Biaoruska 94','Jackowo','SWT','22-801','(20) 4386463')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Idzi','Ukraiska 9','Kamienica','MLP','29-015','(60) 9106355')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Wojnowicz','Litewska 44','Koswki','MZW','50-306','(30) 9997827')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Idzi','otewska 8','Zatory','SLK','32-870','(50) 6769477')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Marszaek','Fiska 55','Kalinwka','SLK','51-244','(50) 2130442')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Hobica','Norweska 8','Mierzcin','WRM','95-887','(70) 6490106')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Wierzynek','Angielska 9','Ludwinowo','SLK','07-959','(80) 8279838')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Kaczmarek','Szkocka 7','Zgorzelec','PDK','37-589','(80) 7061835')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Niechcia','Aliancka 1','Skubianka','MZW','57-118','(61) 8058740')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Seweryn','Arabska 2','Grochw','SWT','36-634','(51) 2541127')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Hepner','Abramowskiego 1','Kychw','DLN','68-576','(51) 4329602')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hajduk','Alpejska 1','Zbiersk','SLK','25-104','(50) 2371948')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Archeologw 3','Wieliszew','LBL','16-809','(60) 3992773')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Adamiak','Adamczewskich 3','Biaobrzegi','KJP','45-682','(70) 7227627')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Rusin','Altanowa 1','Nieport','WRM','66-797','(70) 9041786')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Kokot','Arctowskiego 5','Rdziny','DLN','81-099','(60) 4232277')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Wojnowicz','Armii Krajowej 8','Borowa Gra','LBL','21-252','(40) 8648470')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Niechcia','Admiralska 81','Widowa','PDK','90-214','(70) 7276378')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hobica','Amarantowa 21','Borowa Gra','ZCH','01-028','(78) 4982874')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Egmont','Afgaska 45','Lipinka','LBL','10-113','(40) 2369369')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Idzi','Asfaltowa 41','Aleksandrw','SWT','55-623','(30) 3613196')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Marszaek','Agrestowa 4','Zegrzynek','PDL','08-602','(40) 3496326')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Nawotka','Ananasowa 56','Paszczew','DLN','25-632','(51) 5185214')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Reiss','Asnyka 9','Polichna','WLP','96-462','(50) 3026094')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Idzi','Augustowska 7','Mierzcin','MZW','04-022','(40) 5121919')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Niechcia','Australijska 6','Zawada','PDL','33-847','(91) 2165446')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Niechcia','Aleja Piastw 1','Obory','PDK','68-117','(20) 2092318')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Edelman','Avicenny 2','aziska','KJP','90-191','(90) 5369126')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Niechcia','Aleja Pracy 13','Pogodna','WRM','79-161','(20) 2017641')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Lewie','Azaliowa 16','Ozimek','OPL','42-018','(40) 8414858')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Hajduk','Aleja R 43','Bagacz','LBS','71-326','(80) 6380403')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Lewie','Biaowieska 12','Czerwiesk','OPL','18-003','(40) 3860680')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Lewie','Baczyskiego 11','Stobrawa','LDZ','77-057','(41) 7555058')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Rusin','Biaych Godzikw 8','Gbie','MLP','25-687','(30) 5632181')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Wierzynek','Braniborska 5','Pogodna','ZCH','60-618','(31) 7887192')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Wojnowicz','Badury 32','Knieja','OPL','19-198','(80) 8605495')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Talko','Biegasa 35','Mokre','PDK','56-712','(80) 9344493')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Maciejewicz','Braniewska 1','Stobrawa','LBL','92-366','(20) 8763145')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hager','Biega 3','Zagaje','SLK','36-060','(80) 2449959')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Turo','Brata Alberta 44','Paszczew','LBL','06-611','(20) 3783070')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Edelman','Bielarska 42','Kopiczew','DLN','44-803','(21) 9172060')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Egmont','Braterska 7','Oarw','MZW','87-950','(40) 7764449')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Edelman','Bielawska 8','Botnica','LDZ','89-612','(20) 4762828')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Hepner','Bratkowa 3','Orzechowice','ZCH','52-551','(31) 3945145')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Talko','Bierdzaska 9','Wachw','MZW','65-373','(61) 8894090')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Kokot','Balzaka 8','Biadacz','MZW','45-147','(30) 8921873')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Turo','Bakaska 67','Dobropole','LBL','47-322','(20) 7308317')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Drewniak','Biskupia 32','Zoczew','LBL','99-736','(20) 8453439')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Rusin','Bauckiego 63','Leajsk','SLK','94-514','(50) 6317802')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Jdraszek','Biwakowa 4','Nowa Kunia','PDK','56-918','(70) 6264634')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Rzeszoto','Henryka Brodatego 7','Pokrzywice','SWT','36-499','(30) 5198138')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Baron','Bliska 98','Wielkie','MZW','97-233','(30) 5848633')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Reiss','Brodziskiego 12','Szymanw','PDK','40-058','(70) 9057222')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Adamiak','Bardzka 3','Stanowo','MLP','74-917','(60) 2910996')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Polak','Brodzka 4','Osiecko','WRM','77-914','(70) 7033241')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Dawidek','Bliniacza 7','Wrzeszcz','MZW','61-394','(31) 4183603')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Turo','Bawatna 8','Szczedrzyk','SLK','46-260','(50) 2452362')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Drewniak','Botna 53','Zapiecek','OPL','32-930','(30) 2455132')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Wierzynek','Brylantowa 34','ambinowice','PMS','02-985','(20) 7816112')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Lewie','Barycka 5','Oporw','OPL','61-791','(80) 7430908')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hobica','Bobrza 7','Kopiczew','LDZ','23-491','(41) 7364633')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Rusin','Bobrzaska 3','Pokorniki','OPL','95-302','(40) 2351231')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Wojnowicz','Bocheska 9','Pruszkw','SLK','95-954','(50) 3805320')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Chwist','Brzeziska 12','Wolica','WRM','32-160','(70) 9865519')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Turo','Bociania 14','Botnica','WLP','02-921','(61) 4156524')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Rusin','Bazaltowa 64','Filipowo','MLP','30-391','(40) 5272858')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Lewie','Becka 45','Tyniec','OPL','61-091','(30) 9367317')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Dawidek','Buczacka 5','Tomaszw','WLP','06-332','(50) 8422809')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Maciejewicz','Bednarska 87','Chocianw','WLP','16-208','(50) 2470520')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Wojnowicz','Bogusawskiego 12','Bartniki','DLN','08-988','(21) 8502563')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Polak','Belgijska 43','Pylnik','PDK','14-869','(70) 3924476')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Talko','Budziszyska 32','nin','SLK','79-172','(80) 9064784')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Dbiec','Belgradzka 8','Winowo','LBS','00-189','(80) 9148274')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Seweryn','Boguszowska 3','Igw','WLP','27-768','(31) 3307741')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Adamiak','Buforowa 1','Zakroczym','WLP','03-155','(50) 8724399')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Dbiec','Bujna 1','Palenisko','PMS','92-522','(20) 3187567')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Polak','Boiskowa 4','Rogowo','OPL','26-560','(40) 6136032')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Seweryn','Bujwida 56','Strumienna','PMS','57-721','(30) 8269741')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Turo','Benedyktyska 5','Ligota','LBL','43-398','(40) 5826456')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Hobica','Bojanowska 7','Zagwidzie','MLP','46-132','(40) 9938135')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Dawidek','Bolesawa Chrobrego 9','any','KJP','56-571','(90) 2288300')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Janson','Bukowskiego 10','Leajsk','DLN','17-591','(21) 8742225')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Lewie','Beniowskiego 12','Cezarw','KJP','91-818','(40) 2887583')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Wierzynek','Berberysowa 56','Winowo','OPL','33-599','(40) 8682301')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Romanowicz','Bolesawa Krzywoustego 76','Godzienice','LBL','20-709','(20) 7278772')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Stefanik','Berenta 6','Bielsk','OPL','72-313','(30) 2163779')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Hamak','Bolesawiecka 7','Rudno','ZCH','35-594','(78) 4077334')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Stefanik','Bugarska 4','Jdrzejowice','MZW','03-304','(30) 9282951')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Dbiec','Berlinga 5','Konin','SLK','23-386','(21) 7508495')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Drewniak','Bolkowska 7','Wielkie','WRM','56-451','(70) 5422771')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hamak','Buraczana 9','Makowice','LBL','10-044','(20) 6957172')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Reiss','Bernardyska 102','Bulin','LDZ','44-354','(20) 4540524')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Jdraszek','Bursztynowa 4','Zagwidzie','LDZ','72-629','(41) 7923297')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hajduk','Beskidzka 56','Bogucice','PMS','22-636','(31) 8296460')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Rusin','Bombardierska 6','Kamienica','SLK','40-822','(21) 9346016')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Egmont','Burzowa 11','Falmirowice','LBL','97-513','(60) 4520751')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Marszaek','Betonowa 18','Malinowice','KJP','34-764','(40) 3927454')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Wierzynek','Buska 16','Halinw','SWT','15-003','(51) 8777356')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Wojnowicz','Bora-Komorowskiego 6','Koswki','ZCH','11-102','(78) 2205044')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Kokot','Byczyska 45','Jagnicin','LDZ','91-145','(41) 8967637')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Adamiak','Bydgoska 19','Nowe Pole','DLN','14-108','(21) 3228616')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Rusin','Bezpieczna 14','Pierzchnica','PMS','67-626','(20) 2462829')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Polak','Borna 17','Dbrwka','PDL','53-761','(60) 4464733')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Drewniak','Bystrzycka 8','Krzywka','SLK','02-149','(21) 5680695')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Adamiak','Bdziska 9','Krlikowo','MZW','57-649','(40) 9734975')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Rusin','Bytomska 66','Stoczek','WLP','27-962','(31) 5897970')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Reiss','Biaodrzewia 5','Rybnik','KJP','68-575','(90) 3981159')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Drewniak','Borwczana 6','Grdek','DLN','41-894','(21) 2845432')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Polak','Bosaka-Haukego 12','Siemiatycze','SLK','84-744','(80) 9449691')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Hepner','Biaoskrnicza 5','Bulin','SWT','05-282','(20) 2025698')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Idzi','Boya-eleskiego 76','Bdziew','OPL','64-400','(30) 4346545')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Nawotka','Biaostocka 3','Natolin','PDK','67-162','(80) 7438083')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Jdraszek','Poznaskiej 17','Wielkie','LBS','41-797','(80) 6296560')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Reiss','Boego Ciaa 16','Skubianka','WLP','44-109','(61) 7469121')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Hamak','Cholewkarska 6','Tyniec','PDL','26-362','(91) 9785054')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Rusin','Cybulskiego 6','Nowa Kunia','KJP','16-082','(40) 5627593')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Dawidek','Ceglana 7','Kluczbork','WRM','81-950','(60) 4019938')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Drewniak','Chorwacka 12','Godzienices','PDL','22-662','(40) 5998145')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Reiss','Cynowa  5','Wianki','SWT','08-043','(20) 4056840')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Hobica','Celtycka 6','Bdziew','DLN','69-066','(51) 9086856')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Seweryn','Chorzowska 65','Ludwinowo','PDL','69-775','(91) 6059913')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Wojnowicz','Cytrynowa 23','Borycz','WLP','76-285','(31) 3828333')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Hajduk','Cementowa 35','Hajnwka','PMS','48-670','(20) 3260342')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Wojnowicz','Czackiego 6','Zimnica','KJP','34-753','(90) 7433194')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Turo','Centralna 7','Filipowo','LDZ','10-952','(21) 9435726')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hobica','Czajcza 21','Mynwka','DLN','45-892','(60) 7027014')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Egmont','Cerkwicka 12','Zwierzyn','LDZ','15-304','(20) 6774834')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Wojnowicz','Chrzanowskiego 65','Kluczbork','WRM','60-937','(20) 2556095')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Drewniak','Czajkowskiego 83','Witowice','SWT','06-965','(30) 8615442')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Janas','Chudoby 23','Bylica','LDZ','51-396','(41) 8905643')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Chwist','Czarnieckiego 5','Kropielniki','WLP','70-022','(31) 6123218')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Hajduk','Chabrowa 65','Rdziny','LBS','70-515','(80) 4997198')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Rusin','Chwakowska 3','Kurw','OPL','34-785','(40) 9371876')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Kaczmarek','Czarnoleska 3','Przychd','LBL','90-155','(60) 3376412')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Hamak','Czechowa 6','Nidowo','OPL','62-111','(30) 3821073')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Hobica','Chaubiskiego 7','Gocina','DLN','22-415','(51) 8360523')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Rusin','Cicha 8','Wielkie','SWT','51-560','(20) 4690758')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Janas','Czechowicka 1','Zoty Jar','SWT','60-406','(20) 8295106')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Romanowicz','Chaupnicza 6','Wolica','MLP','45-251','(30) 2266951')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Edelman','Ciechociska 78','Korzonkowo','PMS','97-539','(20) 5664960')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Turo','Mysowicka 5','Biadacz','MZW','24-300','(40) 8599163')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Dawidek','Czekoladowa 13','Paczyna','MZW','09-702','(61) 2922215')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Maysz','Cieplicka 12','Rawa','SWT','19-705','(51) 2618928')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Seweryn','Czeremchowa 4','Jarzbinowo','OPL','09-700','(80) 7694002')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Dawidek','Chemoskiego 5','ochw','PDK','84-566','(20) 4112175')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Rzeszoto','Ciepa 6','Polichna','MLP','08-347','(30) 3194291')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Lewie','Czereniowa 66','Korzonkowo','LBS','99-503','(80) 5668392')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Idzi','Chemska 33','Stawice','DLN','41-557','(21) 7419727')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dawidek','Czerwonego Krzya 14','Kaliszewo','PDL','08-158','(40) 5022815')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Seweryn','Cieszkowskiego 18','Czarny Las','WLP','47-840','(31) 3179562')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Baron','Chiska 5','Wonice','PMS','04-638','(31) 6722100')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Drewniak','Cielikowskiego 1','Kunica','PMS','05-556','(20) 2347036')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Edelman','Czogistw 5','Gbie','MLP','19-802','(40) 7843209')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Reiss','Chopska 7','Paczkw','PDL','64-309','(60) 6409785')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Janas','Cisowa 8','Zagaje','ZCH','78-239','(78) 8459467')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Talko','Czorsztyska 9','Oarw','ZCH','29-864','(31) 2877135')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Maysz','Czysta 77','Wrzosw','KJP','22-835','(40) 9655013')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Turo','Chociebuska 5','Jdrzejowice','KJP','86-945','(90) 3286360')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hager','Cukiernicza 9','awsk','WRM','28-775','(60) 3831118')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Stefanik','Chocimska 23','Zatory','KJP','69-308','(40) 2723269')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Wierzynek','Cukrowa 5','Konin','DLN','53-897','(60) 3990082')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Kokot','Chojnowska 16','Falmirowice','LDZ','11-447','(20) 6406688')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Hamak','Drzewna 25','Bukowina','OPL','97-229','(30) 8888682')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Dbiec','Dugopolska 21','Skrzypnik','ZCH','41-316','(31) 7246709')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Niechcia','Drzymay 3','Jackowo','PDK','62-616','(80) 2675392')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Jdraszek','Dalimira 35','Siemianw','OPL','98-451','(80) 7997780')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Romanowicz','Dugosza 35','Zawiercie','KJP','49-294','(90) 9732839')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Dbiec','Dubois 12','Suchodolec','MZW','86-846','(31) 7866985')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Wierzynek','Daliowa 56','Zakroczym','LDZ','16-296','(61) 3752216')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Eliasz','Dutowa 6','Oporw','PDL','96-976','(40) 3259117')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Edelman','Dubrownicka 8','Bielsk','ZCH','92-557','(50) 7326620')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Rzeszoto','Dmowskiego 5','Hajnwka','OPL','56-334','(40) 6403369')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Stefanik','Dunikowskiego 6','Stoczek','MZW','29-603','(30) 9326539')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Lewie','Daniowskiego 87','Nowe Pole','PDL','92-857','(91) 7713759')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hajduk','Dobra 2','Siemiatycze','WLP','18-686','(31) 8382949')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Polak','Darowska 23','Pogorzelica','PDK','20-622','(20) 9457611')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Wojnowicz','Dobreckiego 6','Dugoka','KJP','19-255','(90) 5471738')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Turo','Dusznicka 67','Dbkowice','OPL','82-179','(80) 4655704')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Egmont','Darwina 7','Podbrzezie Grne','SWT','70-619','(30) 2271443')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Stefanik','Dobroszycka 8','any','LBS','06-902','(50) 8815922')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Kokot','Dworska 23','Szumin','MZW','83-706','(30) 8040495')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Niechcia','Dojazd 6','Nowogrdek','LDZ','69-723','(21) 6440499')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Drewniak','Dokerska 78','Podbrzezie Grne','LDZ','34-753','(61) 3834459')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Turo','Dygasiskiego 7','Pytkie','SWT','59-648','(30) 3793211')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Maysz','Dyrekcyjna 8','Gajkw','DLN','07-841','(60) 6616977')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hamak','Dolnobrzeska 46','Nogat','MZW','92-395','(30) 5927097')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Dawidek','Dziadoszaska 49','Piskory','LBL','58-126','(60) 2332390')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Egmont','Dogi-Mostowicza 6','Pniewy','ZCH','26-562','(78) 9596566')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Baron','Dziadowska 7','Sulisawice','PDK','92-651','(70) 6334253')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Egmont','Domasawska 58','Stoczek','KJP','67-671','(70) 9806969')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Eliasz','Dziakowa 35','Winowo','ZCH','90-610','(50) 8254212')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Rzeszoto','Dekarska 23','Chyw','WRM','69-500','(20) 3773992')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Polak','Domeyki 67','Zuchw','LBL','09-936','(20) 7776967')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Eliasz','Dembowskiego 8','O','LBS','67-029','(80) 2029460')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Janson','Dominikaska 9','Wierzchowiska','LBS','52-097','(50) 6257280')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Kaczmarek','Dziarska 9','any','PMS','00-423','(30) 2484392')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Dbiec','Dereniowa 2','Pierzchnica','OPL','81-975','(30) 4859260')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Jdraszek','Desantowa 1','Chyw','PMS','14-389','(31) 5092402')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Hepner','Doynkowa 78','Zimnica','WRM','24-686','(60) 5972377')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hajduk','Dzielnicowa 75','Zawada','DLN','42-318','(60) 2951802')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Marszaek','Deszczowa 7','Aleksandrw','MZW','86-232','(31) 8666942')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hager','Drabika 17','Siemianw','SWT','09-549','(30) 7516972')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Romanowicz','Dzieronia 12','Bartniki','MLP','69-868','(40) 6927008')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Idzi','Drobnera 5','Zuchw','MLP','15-154','(60) 7806878')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Talko','Dzieroniowska 56','Stawice','PMS','85-028','(20) 9384915')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Nawotka','Drogosawicka 5','Chocice','SWT','76-623','(20) 5165799')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Adamiak','Dziwnowska 50','Bartniki','SWT','70-719','(20) 5410951')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Stefanik','Drnicza 32','Daniec','PMS','46-803','(30) 3491628')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Stefanik','Druckiego-Lubeckiego 20','Palenisko','PDK','80-236','(20) 4133843')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Baron','Drzewieckiego 10','Ostrda','MLP','37-482','(30) 4613328')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Jdraszek','Ekonomiczna 3','Drwale','LDZ','99-083','(61) 3339049')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Dbiec','Elsnera 6','Suchy Br','LBS','08-989','(80) 4573396')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Seweryn','Energetyczna 12','Godzienices','KJP','92-970','(40) 2837073')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Kokot','Ekspresowa 2','Plesko','LBL','10-185','(60) 4546424')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Edelman','Estoska 7','Iawa','PDK','07-764','(80) 3133261')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Nawotka','Elblska 6','Nowogrdek','WRM','78-217','(60) 4188098')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Janson','Elementarzowa 1','Gardo','WRM','68-267','(70) 4128811')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Reiss','Ecka 3','Suchy Br','WLP','32-421','(31) 3129237')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Hamak','Fabryczna 20','Filipowo','MLP','47-705','(40) 4601955')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Janas','Filipowicza 32','ka','SLK','21-721','(21) 6370707')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Hepner','Francuska 3','Bagacz','SLK','04-779','(50) 5215539')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Adamiak','Falskiego 12','Kaliszewo','SLK','09-946','(80) 7365308')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Nawotka','Filomatw 67','Kalenica','SLK','10-185','(50) 3816459')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Wierzynek','Fromborska 2','Widowa','ZCH','08-389','(50) 4459983')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Jdraszek','Faata 2','Szczodrw','LDZ','09-456','(41) 5745691')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Seweryn','Fiokowa 1','Kaliszewo','MLP','90-019','(40) 4511928')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Janson','Frycza-Modrzewskiego 1','Nadlesie','OPL','94-001','(80) 9962856')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Hamak','Fizylierska 6','Czerwiesk','WLP','44-709','(31) 9434463')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hajduk','Fryzjerska 78','Strumienna','KJP','77-238','(40) 5687572')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Drewniak','Fasolowa 3','Gorzw','PMS','59-843','(20) 7392748')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Wojnowicz','Flisacka 10','Jdrzejowice','DLN','97-659','(51) 8268029')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Janas','Folwarczna 11','Machnice','PMS','35-705','(30) 8344691')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Hager','Filipiska 35','Wichw','ZCH','69-996','(78) 5839640')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Idzi','Gagarina 9','Pokrzywice','MLP','36-559','(40) 4812961')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Kokot','Gowackiego 24','Jawiec','LDZ','70-872','(61) 4632705')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Chwist','Grabiszyska 103','Kaliszewo','OPL','74-950','(80) 6527384')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Polak','Gajowa 1','Nowa Wie Krlewska','OPL','82-874','(30) 8010805')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Niechcia','Grabowa 23','Piskory','PMS','85-179','(20) 9431279')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Janas','Gajowiska 7','Zapiecek','WRM','35-118','(70) 4525772')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Rusin','Grabskiego 2','Kamierzw','WLP','01-888','(31) 9835084')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Kaczmarek','Granatowa 1','Brochw','DLN','46-129','(51) 3816131')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Turo','Gaczyskiego 12','Kozietuy','ZCH','44-272','(50) 4627055')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Reiss','Grawerska 14','Kluczbork','ZCH','20-326','(78) 3143642')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Kaczmarek','Gaowska 41','Szymanw','WRM','91-100','(20) 2240807')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Wierzynek','Grecka 22','Kaliszewo','LBL','33-045','(60) 4368849')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Hamak','Garncarska 11','Orzechowice','OPL','08-140','(30) 2283418')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Wierzynek','Guszyca 10','Witowice','SWT','35-457','(30) 2126304')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Dawidek','Grochowa 2','Ujcie','KJP','56-259','(90) 6754175')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Adamiak','Garwoliska 6','Zbiersk','ZCH','06-351','(50) 3035005')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Hager','Gminna 43','Wianki','PMS','12-218','(31) 3934776')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Dawidek','Grochowiaka 21','Sawkw','PDL','43-590','(60) 4051964')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Hajduk','Gazowa 12','Chodzie','PMS','35-643','(20) 8693847')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Maysz','Gnienieska 56','Szczawno','SWT','96-873','(30) 6246204')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Janson','Grodzieska 12','ka','DLN','32-849','(51) 3532960')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Drewniak','Gdowska 12','Koswki','PMS','86-831','(20) 7632847')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Stefanik','Godebskiego 5','Pisk','DLN','52-292','(60) 6614059')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Lewie','Grodzka 6','Kropielniki','ZCH','82-317','(78) 7772253')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Seweryn','Gsiorowskiego 12','Polichna','PDL','71-051','(91) 6876141')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Maciejewicz','Godlewskiego 54','Biaa Woda','ZCH','32-780','(78) 2913422')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Idzi','Gromadzka 5','Zaborowo','LBL','56-689','(40) 3664285')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Eliasz','Grota-Roweckiego 12','awsk','LDZ','77-592','(41) 8381139')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hobica','Gdaska 65','Walendowo','WRM','13-882','(70) 6819371')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Nawotka','Grottgera 1','Pogorzelica','LBL','79-205','(40) 3101577')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Reiss','Grjecka 10','Knieja','MZW','50-194','(40) 6965089')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Maysz','Gerberowa 20','Stawice','MLP','52-004','(30) 4729320')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Janas','Gobia 2','Szczedrzyk','LBS','20-366','(80) 7616070')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Kokot','Grudzidzka 1','Zakroczym','LBS','83-744','(50) 6496040')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Eliasz','Gersona 4','Rydzewo','ZCH','33-486','(50) 5014244')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Baron','Gsia 56','Stobrawa','PMS','71-440','(30) 4216277')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Nawotka','Gruszowa 6','Trzebicz','MZW','32-441','(40) 3322762')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Stefanik','Gimnazjalna 6','Igw','SWT','18-584','(30) 8345055')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Talko','Gorlicka 9','any','KJP','79-995','(40) 3013083')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Hajduk','Giycka 1','Zaborowo','PDL','65-558','(60) 9880305')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Janas','Gospodarska 9','Chodzie','DLN','10-893','(51) 6135058')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hobica','Gryczana 3','Limanw','MZW','50-146','(31) 6713297')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Turo','Giyckiego 2','Niwki','LBL','34-345','(20) 4267115')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Wojnowicz','Gostyska 6','Szczedrzyk','LDZ','19-972','(20) 7291567')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Drewniak','Glebowa 12','Widowa','DLN','96-289','(60) 4819888')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Rusin','Goszczyskiego 11','Jagnicin','LBL','43-784','(40) 2357050')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Eliasz','Grzybowa 19','Kamionka','LBS','35-786','(80) 9561878')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Janson','Gliniana 16','Pogorzelica','DLN','93-439','(51) 9365385')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Edelman','Gralska 22','Stalowa Wola','MZW','94-926','(30) 5034991')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Jdraszek','Gubiska 43','Winiowiec','LBS','93-460','(80) 8585624')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Chwist','Grecka 12','Morg','DLN','66-638','(51) 2558054')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Dbiec','Gwarecka 42','Daniec','LBL','60-052','(20) 7304790')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Dbiec','Glogera 1','Krlikowo','KJP','89-754','(90) 7733643')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Wojnowicz','Grnickiego 4','Pruszkw','LDZ','76-439','(20) 7197031')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Adamiak','Grnicza 6','Wonice','KJP','25-722','(90) 9084824')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Adamiak','Gwiadzista 9','Nadlesie','SWT','76-418','(30) 3430316')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Dawidek','Gogowska 12','Wachw','MLP','76-325','(30) 5544646')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Nawotka','Grnolska 6','Osiecko','WRM','32-974','(70) 2278904')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Drewniak','Gwizdanowska 1','Skibice','SLK','26-802','(50) 6639482')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Wojnowicz','Gona 5','Nogat','SLK','73-857','(80) 6062051')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Idzi','Grabarska 9','Oarw','MLP','23-724','(30) 5116561')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Wojnowicz','Hajducka 98','Krzyw','SLK','70-992','(21) 4105672')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Talko','Hermanowska 11','Zawada','ZCH','22-019','(31) 3653289')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Maysz','Holenderska  4','Dolniki','WLP','75-579','(50) 2431931')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dbiec','Hallera 6','Mirw','LDZ','60-508','(61) 3525191')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Maciejewicz','Hetmaska 1','Plesko','LBL','95-785','(20) 7043977')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Jdraszek','Heweliusza 5','Borycz','MZW','50-333','(30) 8908586')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hepner','Hoa 9','Rembertw','WRM','38-879','(70) 5494287')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Chwist','Harcerska 30','Pylnik','LBS','85-648','(50) 6623317')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Maciejewicz','Himalajska 31','Lbark','OPL','64-697','(30) 9400349')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Chwist','Hubala 36','Kozietuy','SWT','10-957','(30) 2953153')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Reiss','Hauke-Bosaka 26','Wianki','SWT','22-319','(30) 6865642')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Maysz','Hippiczna 2','Kopiczew','PMS','04-459','(20) 9442683')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Polak','Heblarska 6','Biernaty','SLK','66-808','(21) 3310131')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Edelman','Hirszfelda 1','Szumin','PMS','61-793','(20) 7379818')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Janson','Hubska 77','Kamierzw','MZW','77-919','(31) 3662759')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Edelman','Helska 67','Wrzosw','KJP','89-542','(70) 2560228')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Idzi','Hiszpaska 12','Bartniki','SLK','27-625','(50) 6568643')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Hager','Hufcowa 45','Nieport','MLP','42-877','(60) 4312316')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Nawotka','Henryka Brodatego 12','Bukowina','LBL','68-345','(20) 3370938')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hager','Husycka 66','Kaliszewo','SLK','66-721','(21) 4428572')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hepner','Henryka Pobonego 5','Bartniki','SWT','38-766','(20) 8580611')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Niechcia','Haski 6','Stoczek','LBS','24-806','(50) 9679398')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Idzi','Hutnicza 7','Palenisko','LBS','09-094','(80) 6742560')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Seweryn','Hodowlana 1','Zoty Jar','LBL','25-982','(40) 7824750')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Maciejewicz','Henrykowska 19','Makowice','PMS','12-654','(30) 6185835')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Jdraszek','Hercena 16','Tyniec','LDZ','82-183','(41) 4684191')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Idzi','Hokeistw 1','Kodzko','PDK','35-681','(20) 8670888')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Rusin','Daszewskiego 12','Chodzie','DLN','57-404','(51) 8186197')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hajduk','Iawska 17','Turawa','SWT','62-196','(51) 9526113')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Talko','Idziego 78','Kopiczew','KJP','92-055','(40) 5083808')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Seweryn','Idzikowskiego 6','Wichw','LBS','95-830','(80) 9050109')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Wierzynek','Inflancka 7','Zoty Jar','SLK','12-106','(80) 9976980')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Chwist','Irysowa 21','Kychw','LDZ','05-479','(20) 9964411')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hamak','Igielna 33','Wachw','OPL','57-344','(30) 4642207')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Adamiak','Inowrocawska 23','Pniew','SWT','66-659','(30) 9654637')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Seweryn','Irysowa 56','Strumienna','SWT','88-175','(20) 3095287')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Adamiak','Inspektowa 35','Drwale','LDZ','95-448','(20) 5924287')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Drewniak','Iwonicka 7','Winowo','SLK','55-290','(50) 8459299')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Idzi','Jarzynowa 5','Pokoty','SWT','96-868','(20) 5026654')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Hepner','Jezierskiego 6','Ostrda','LBL','41-614','(60) 5190156')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Janas','Jasielska 14','Rybnik','KJP','74-605','(70) 6759561')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Romanowicz','Jeziorowa 17','Gniazdw','SWT','10-888','(20) 4385309')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Kokot','Jagielloczyka Kazimierza 9','Dbrwka','LBS','73-927','(50) 7316910')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Stefanik','Jasienicy 21','Pylnik','PDL','22-269','(91) 2118463')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Seweryn','Jedziecka 22','Osiecko','ZCH','54-686','(31) 6665237')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Maysz','Jagielloska 45','Wachw','SLK','95-321','(80) 8333385')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Eliasz','Jasiskiej 62','Brzeg','PDK','16-263','(70) 9210769')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Kokot','Jeowska 12','Wodziejkowice','WRM','34-772','(20) 2245156')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Rusin','Jaskcza 1','O','MLP','21-352','(30) 8519676')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Reiss','Jczmienna 3','Rogowo','LDZ','49-406','(21) 7732457')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Stefanik','Wadysawa Jagiey 6','Iawa','MZW','90-443','(61) 4774508')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Romanowicz','Jasna 76','Pruszkw','MZW','24-479','(61) 4861737')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Stefanik','Jdrzejowska 7','Wrzosowisko','LBL','63-881','(40) 9779018')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Polak','Jagnitkowska 9','Rembertw','MZW','32-022','(40) 2845348')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Drewniak','Jastrzbia 10','Podbrzezie Grne','LBL','53-375','(40) 4309860')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hajduk','Joannitw 20','Dbkowice','MZW','88-405','(40) 2558000')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Dbiec','Jagodowa 2','Brzeg','MZW','29-850','(61) 6346853')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Dbiec','Jakowiaka 6','Winiowiec','LBL','93-552','(40) 2150128')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Maciejewicz','Jodowa 48','Zimnica','SLK','19-480','(50) 3271812')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Kaczmarek','Jagodziska 9','Pniewy','LBS','11-164','(80) 9558011')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Marszaek','Jajczarska 17','Rawa','PDL','04-823','(60) 6430141')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Chwist','Jaworowa 9','Gardo','WRM','74-326','(60) 3740733')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Kokot','Jaworska 8','Gocina','LBL','52-887','(40) 9106657')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Maciejewicz','Jordanowska 8','Nowa Wie Krlewska','WLP','25-902','(31) 4174346')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Kokot','Jednoci Narodowej 4','Wichw','SWT','17-041','(20) 6447388')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Marszaek','Jordaska 5','Kamienniki','LBL','28-046','(20) 2691813')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Niechcia','Janiszewskiego 1','Jakubowice','PDL','84-619','(60) 6175282')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Maciejewicz','Janowska 9','Oarw','WLP','00-242','(61) 9072576')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Dbiec','Jeleniogrska 5','Chodzie','MZW','67-109','(61) 8879066')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Rusin','Jantarowa 12','Ujcie','KJP','70-233','(70) 8409852')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hepner','Januszowicka 54','Jarzbinowo','SLK','54-786','(21) 2563721')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Hepner','Jemioowa 4','Kamie','WLP','47-214','(31) 5763996')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Kokot','Junacka 1','Gorzw','WLP','82-682','(31) 2170284')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Kaczmarek','Japoska 9','Kamierzw','MLP','51-664','(30) 8058520')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Hager','Jaracza 90','Kozielice','MLP','79-760','(30) 6989952')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Talko','Jerzmanowska 32','Podbrzezie Grne','DLN','61-197','(51) 2886616')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Polak','Jarnotowska 35','Czerwiesk','WLP','98-153','(61) 6542710')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Kaczmarek','Jesienna 6','Leajsk','LBL','56-803','(60) 3882284')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Lewie','Jutrzenki 63','Kaliszewo','SLK','44-376','(80) 7707940')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Dbiec','Jarociska 21','Kojno','DLN','78-854','(21) 2626391')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Hager','Jesiennicka 33','Kamionka','DLN','59-342','(51) 9957745')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Romanowicz','Kaczecowa 1','Biaobrzegi','SLK','27-249','(21) 4593271')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Reiss','Kadubka Wincentego 7','Chodzie','SLK','19-110','(50) 9331938')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Hager','Kouchowska 45','Winowo','MZW','65-073','(31) 9080705')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Hepner','Kraiskiego 7','Falmirowice','ZCH','53-181','(31) 9933941')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Eliasz','Kaletnicza 8','Stoczek','MLP','10-160','(30) 2777372')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Niechcia','Kolberga 2','Paczkw','ZCH','02-272','(31) 7746031')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hamak','Krajewskiego 65','Jackowo','OPL','23-900','(30) 6663111')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Wojnowicz','Kalinowa 7','Zakroczym','SLK','62-401','(80) 9427678')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Egmont','Kolbuszowska 8','Kopiczew','PDL','31-704','(40) 2231605')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Egmont','Krakowska 2','Blachw','MZW','87-189','(61) 6955934')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Turo','Kaliska 6','Pytkie','MZW','34-479','(40) 4417308')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Jdraszek','Krakusa 7','Gniedzina','OPL','45-227','(30) 6722082')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Hajduk','Kamieniecka 8','Orzechowice','KJP','95-488','(70) 7353724')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Edelman','Krasickiego 23','Wachw','LDZ','54-401','(41) 5982038')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Kaczmarek','Krasiskiego 66','Pustkw','WRM','11-989','(20) 2438379')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Stefanik','Kamiennogrska 56','Kropida','MLP','40-053','(60) 3291196')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Drewniak','Kolista 8','Winiowiec','SLK','05-999','(80) 6540076')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Eliasz','Kraszewskiego 9','Cezarw','PMS','88-834','(31) 3727709')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Wojnowicz','Kamieskiego 23','Czempinw','WLP','93-582','(31) 8225278')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Talko','Kampinoska 6','Piskory','WRM','95-141','(20) 5672406')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Lewie','Koobrzeska 46','Kopiczew','SLK','17-037','(50) 5514714')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Drewniak','Kresowa 78','Leniczwka','DLN','22-005','(51) 5844833')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Romanowicz','Kanadyjska 8','Kropielniki','PMS','49-322','(31) 7096558')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Polak','Koodziejska 23','Morg','SLK','23-304','(50) 5369111')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Egmont','Krelarska 12','Stawice','MLP','05-160','(60) 6732754')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Romanowicz','Komandorska 2','Zakroczym','MLP','99-191','(60) 9629613')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hepner','Krcicka 6','Brzeg','DLN','18-118','(21) 6504362')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hajduk','Komeskiego 8','Przychd','DLN','81-588','(51) 8684643')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Kaczmarek','Kanonierska 9','Morg','MZW','68-114','(61) 6758984')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Eliasz','Kominiarska 90','Stanowo','WLP','71-634','(61) 6893617')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Romanowicz','Kapitulna 21','Pogorzeliska','PMS','68-664','(20) 2455651')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Dawidek','Kominka 5','Szymanw','MLP','75-970','(30) 4641441')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Seweryn','Kapliczna 8','Planica','DLN','48-279','(21) 3632725')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Chwist','Komorowska 9','Kalenica','MLP','13-718','(60) 4810073')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Hamak','Kronieska 8','Kamierzw','LDZ','85-379','(20) 3853695')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Edelman','Karczemna 12','Kunica','DLN','91-039','(21) 6798473')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Adamiak','Krotoszyska 66','Gniedzina','PMS','81-096','(31) 6229939')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Marszaek','Komuny Paryskiej 78','Bogucice','MZW','65-156','(30) 8812419')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Kokot','Krowia 7','Nowa Kunia','LDZ','79-341','(61) 2913802')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Wierzynek','Karowicza 8','Stawice','LBS','44-685','(50) 9186906')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Nawotka','Konarskiego 23','Rybnik','WLP','68-513','(61) 5677589')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Romanowicz','Krlewiecka 45','Brzezina','SLK','98-185','(50) 7490095')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Lewie','Karmelkowa 7','Bulin','PMS','24-225','(30) 3499306')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Eliasz','Konduktorska 8','Wachw','LDZ','67-784','(20) 8155030')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Edelman','Krlewska 9','Ligota','SLK','77-417','(50) 4688250')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Lewie','Karpacka 9','Czempinw','LDZ','09-749','(20) 7415595')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Rzeszoto','Koniska 24','Jdrzejowice','PDK','17-241','(20) 3520797')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Lewie','Karpiskiego 35','Brzeg','WLP','08-891','(50) 2243429')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Maysz','Karwiska 88','Nowe Pole','LDZ','63-076','(20) 8946964')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Wierzynek','Kasprzaka 8','Bartniki','DLN','38-680','(60) 6056762')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hepner','Kocowa 9','Szczodrw','PMS','65-073','(31) 3299610')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Dawidek','Krucza 2','Wierzchowiska','MZW','63-921','(31) 2046402')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Reiss','Kasztelaska 44','Palenisko','OPL','17-575','(80) 4517354')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Dbiec','Kaszubska 7','Czarny Las','MZW','07-900','(31) 6631332')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Hamak','Kruszcowa 30','Wierzchowiska','PMS','94-814','(31) 7939559')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Maysz','Kruszwicka 61','Biaa Woda','DLN','30-844','(21) 2125637')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Marszaek','Kordeckiego 60','Botnica','LDZ','43-250','(41) 9145981')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Dawidek','Krynicka 5','Jawiec','LBS','91-595','(80) 3002736')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Edelman','Kryniczna 30','Paczyna','OPL','89-907','(80) 7728918')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Egmont','Krzelowska 6','Biernaty','LBS','89-362','(80) 2855130')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Edelman','Kazimierska 43','Igw','LBS','51-130','(80) 5728954')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Maciejewicz','Krzeszowska 7','Kopary','MLP','07-414','(60) 6518142')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Wierzynek','Kazimierza Wielkiego 9','Szumin','LDZ','51-077','(21) 8473656')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Hager','Korzeska 11','Chmurw','WLP','05-612','(50) 2307359')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Baron','Krzycka 65','Ujcie','LBL','84-373','(40) 5599789')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Maysz','Kazimierza Jagielloczyka 6','Zatory','MZW','33-643','(61) 2942756')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Polak','Kcka 67','Szumin','WRM','82-272','(20) 7904926')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Niechcia','Kosiedowskiego 4','Filipowo','WRM','61-833','(20) 6114706')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Lewie','Krzywickiego 12','Stanowo','LBS','66-705','(80) 9957518')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Chwist','Kosmiczna 1','Kamionka','ZCH','51-406','(78) 7259366')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Wojnowicz','Bolesawa Krzywoustego 11','Wonice','ZCH','01-604','(50) 6039793')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Maysz','Kpiska 19','Paowice','SWT','11-076','(20) 7372129')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Romanowicz','Krzyanowicka 17','Sulisawice','PDK','75-853','(80) 5248051')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Rusin','Ktrzyska 6','Czersk','OPL','11-843','(40) 8619140')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Maysz','Kossak-Szczuckiej 40','Winiowiec','SLK','77-276','(50) 9550224')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hobica','Krzyowska 34','Jagnicin','MZW','56-870','(30) 8482079')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Wierzynek','Kiebanicza 6','Rybnik','WLP','41-988','(50) 8476781')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Romanowicz','Kostrzyska 7','ka','DLN','28-304','(60) 5168674')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dawidek','Ksigarska 8','Ligota','MLP','88-532','(40) 6173318')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wierzynek','Kieczowska 1','Niebytw','MZW','57-929','(31) 5051681')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Adamiak','Kosynierw 55','Gniazdw','SLK','71-156','(21) 2672446')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Maciejewicz','Ksigowa 7','Gocina','WLP','93-529','(50) 8918285')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Edelman','Wiolinowa 2','Kojno','WLP','11-588','(50) 5030793')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Marszaek','Koszarowa 67','Aleksandrw','PDL','57-823','(60) 3743147')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Edelman','Ksiycowa 78','Ujcie','LDZ','93-723','(41) 2172240')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Edelman','Kiliskiego 7','Czempinw','MLP','21-847','(40) 4673563')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Reiss','Koszykarska 5','Kamienniki','MLP','30-566','(30) 7044719')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Marszaek','Kudowska 6','Kosowice','SWT','39-677','(51) 2176455')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Talko','Klasztorna 78','nin','OPL','37-810','(40) 8058169')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Baron','Kociaska 8','Kropida','PMS','16-350','(31) 6832164')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Jdraszek','Kukucza 9','Rybaczwka','DLN','73-440','(60) 9306503')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Idzi','Kleeberga 90','Piaski','PMS','05-854','(31) 2785264')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Edelman','Kocierzyska 1','Wrblin','ZCH','27-724','(78) 5535663')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Polak','Kurkowa 33','Trzebicz','MLP','61-089','(30) 6331860')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Turo','Kociuszki 3','Wrblin','MZW','72-967','(40) 3454124')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hager','Kuropatwia 6','Stawice','PMS','82-639','(20) 4703093')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Baron','Kurpiw 78','Wierzchowiska','WLP','07-407','(50) 3254431')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Dawidek','Kurska 75','any','DLN','38-261','(60) 7474830')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Kaczmarek','Kodnicka 23','Biernaty','PMS','52-628','(20) 8002615')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Reiss','Kurzy Targ 44','Lipinka','DLN','49-937','(51) 5635736')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hamak','Kona 16','Limanw','PMS','88-862','(20) 2725578')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Polak','Kutnowska 8','Biaobrzegi','SLK','70-394','(50) 2837217')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Drewniak','Konego 5','Grdek','WRM','37-562','(60) 6803802')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Wierzynek','Kmieca 7','Gniazdw','SLK','95-946','(21) 5730940')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Rzeszoto','Kotlarska 8','Jeziorna','OPL','25-602','(40) 9680958')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Adamiak','Kminkowa 32','Blachw','PDK','87-536','(70) 6098913')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Hobica','Kwana 2','any','PMS','90-508','(30) 9338281')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Baron','Kotwiczna 6','Wieczyce','SLK','96-859','(21) 5456323')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Adamiak','Kwidzyska 8','Zapiecek','PDL','11-075','(60) 7484784')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Lewie','Kwitnca 89','Grdek','MLP','19-442','(30) 6980617')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Wojnowicz','Kowieska 9','Wrzeszcz','OPL','72-739','(40) 9147662')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Lewie','Kobierczyka 3','Bukowo','PDK','21-542','(80) 5474545')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Wojnowicz','Kozanowska 23','Przychd','LDZ','02-112','(21) 4443491')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Stefanik','Kocha 23','Grdek','ZCH','12-760','(31) 8068122')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Polak','Lakiernicza 45','Tomaszw','ZCH','30-002','(78) 8176044')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wierzynek','Lena 67','Paczyna','OPL','61-222','(30) 8515736')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Reiss','Liskego 78','Zuchw','MLP','67-358','(30) 3222841')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Edelman','Liciasta 89','Pogorzeliska','MLP','73-220','(60) 7710870')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Eliasz','Laskowa 34','Szymanw','WRM','03-451','(60) 3163756')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Janas','Latawcowi 56 ','Wielkie','KJP','84-180','(40) 7269159')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Reiss','Lutomska 67 ','Kaliszewo','PDK','60-714','(20) 4218287')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Reiss','Lazurowa 23 ','Zgorzelec','MZW','32-826','(30) 8884743')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Drewniak','Wiosenna 12 ','Stalowa Wola','WRM','65-590','(60) 5994337')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Adamiak','Zimowa 43','Laryszw','PDL','15-436','(40) 6228141')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Kokot','Letnia 67 ','Nowa Wie Krlewska','ZCH','19-773','(78) 2933578')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Hager','Polan 78','Winowo','LDZ','42-034','(41) 6085114')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Lniana 78','Ostrda','PMS','81-209','(31) 2126774')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Baron','Ldecka 45','Nowe Pole','MZW','41-431','(30) 5587236')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Dawidek','Lewa 1','Siemianw','PMS','89-253','(20) 5334621')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Egmont','Lompy 45','ubniany','MLP','86-946','(30) 6173141')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Hamak','Lechitw 89','Wrzosowisko','PDK','93-319','(70) 6892983')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hamak','Libelta 65','Zagaje','SWT','39-725','(30) 3114656')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Kokot','Lotnicza 12','wirowo','SWT','69-443','(20) 5255588')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Dbiec','Styczniowa 1','Trzebicz','ZCH','31-497','(31) 3285315')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Polak','Ledchowskiego  23','Kunica','MZW','34-092','(31) 3957547')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Lewie','Lidzbarska 12','Pokoty','LBL','33-675','(20) 6010935')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Maciejewicz','Lutowa 45','Ujcie','LBL','89-632','(20) 3747279')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hobica','Lotnicza 78','Pogorzelica','PDL','84-641','(91) 3674258')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Wojnowicz','Marcowa 87','Zoczew','PDL','60-796','(91) 5609696')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Seweryn','Legionw 45','Dbkowice','LDZ','72-127','(61) 4819855')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Wojnowicz','Ligocka 546','Strumienna','MZW','06-554','(40) 6455729')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Egmont','Lubeckiego-Druckiego 43','Borowa Gra','OPL','92-538','(30) 4612768')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Stefanik','Kwietniowa. 65','Lbark','PMS','16-737','(30) 3206547')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hepner','Legnicka 98','awsk','OPL','34-105','(30) 5259616')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Eliasz','Liliowa 09','Szydw','KJP','27-818','(90) 7020067')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Seweryn','Lubelska 76','Kaliszewo','PDL','55-744','(91) 7251117')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Turo','Majowa 23','Pokrzywki','PDL','17-191','(40) 7492583')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Reiss','Lekarska 54','aziska','LDZ','58-492','(21) 6128261')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Dbiec','Liliowa 12','Przychd','ZCH','60-352','(78) 4423626')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Rusin','Lubiska 32','Gniedzina','LBS','60-345','(50) 3037389')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Rzeszoto','Lekcyjna 54','Szczodrw','WLP','98-726','(31) 3173343')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Polak','Limanowska 98','Kamienniki','PDK','83-839','(80) 6364304')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Egmont','Lubska 65','Jarzbinowo','MZW','00-402','(31) 4916315')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Dbiec','Czerwcowa 54','Pniewy','MZW','63-234','(31) 8527638')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Lewie','Lelewela 09','Witowice','LBS','02-483','(50) 2947852')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Reiss','Lindego 6','Nowa Kunia','PMS','49-150','(20) 2666170')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Hobica','Lubuska 4','Wieczyce','PDL','59-625','(60) 5528248')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hamak','Lipcowa 65','Mysw','OPL','22-680','(40) 3243324')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Hager','Lenartowicza 4','Knieja','LBL','16-360','(40) 6707383')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Eliasz','Ludowa 67','Bdziew','PDL','01-789','(40) 4600326')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Chwist','Leonarda da Vinci 8','Szydw','MLP','39-074','(30) 2782530')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Hobica','Sierpniowa 9','Wrzeszcz','DLN','01-224','(21) 7322247')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Seweryn','Lipiskiego 66','Ostrda','ZCH','15-572','(50) 4293560')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Kaczmarek','Leska 54','Ujcie','LBL','30-321','(20) 6313016')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Drewniak','Lipowa 78','Siemiatycze','OPL','44-089','(40) 8354004')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Janson','Lutycka 22','Muszyna','MLP','38-068','(30) 4241747')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Lewie','Wrzeniowa 34','Zoty Jar','LBS','58-634','(80) 9959706')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Nawotka','Leszczynowa 6','Nowa Wie Krlewska','SLK','39-820','(50) 4173984')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Hajduk','Lipowa 16','Borowa Gra','MLP','62-531','(40) 5090018')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hajduk','Lutyska 13','Czarny Las','LDZ','85-014','(41) 9099688')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Egmont','Lwowska 9','Zbrosawice','OPL','50-298','(80) 2144085')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Eliasz','Padziernikowa 11','Nogat','SLK','56-967','(21) 5804471')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Hepner','Lemiana 12','Kosowice','LBS','67-398','(80) 3079693')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Hamak','Lipska 5','Natolin','WLP','29-993','(31) 6154487')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Niechcia','Lisia 6','Krzyw','LBS','20-150','(80) 3162144')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Eliasz','Listopadowa 12','Cezarw','LBS','81-858','(80) 2223112')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Eliasz','aciarska 12','Orzechowice','WLP','70-028','(31) 5726628')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Turo','kowa 55','Stawice','OPL','34-010','(30) 2322816')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Rzeszoto','Psary 6','Witowice','MLP','94-582','(30) 2529064')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Wojnowicz','uczan 76','Krzyw','LBS','25-749','(80) 3805084')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Stefanik','Grudniowa 8','Wrblin','PDL','48-122','(40) 5417336')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Talko','adna 3','Bielsk','PDK','17-693','(20) 7614600')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Eliasz','ucznikw 5','Zwierzyn','LBS','79-058','(50) 7256188')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Hamak','agiewnicka 6','Iawa','LBL','78-451','(60) 6660724')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Romanowicz','ugowa 77','Szczawno','KJP','63-246','(40) 3674624')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Kaczmarek','czycka 67','Kaliszewo','DLN','51-371','(21) 6675492')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Jdraszek','Pokrzywowa 4','Leniczwka','LBL','37-732','(20) 9476906')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Talko','ukaszewicza 13','Osiecko','KJP','23-237','(70) 4411606')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Dbiec','anowa 4','Szymanw','MLP','44-253','(30) 5555494')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Idzi','Wadysawa okietka 6','Bodzanw','MLP','41-801','(60) 9811126')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Polak','ukasiskiego 7','Pokorniki','KJP','16-887','(90) 9789516')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Turo','azienna 87','Rogowo','SWT','54-019','(51) 9036843')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Idzi','opianowa 7','Brzezina','WRM','73-214','(60) 4047627')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Marszaek','ukowa 4','Zegrzynek','SLK','61-854','(80) 6925541')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Eliasz','czna 23','Widowa','ZCH','93-371','(78) 2652330')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Romanowicz','osiska 56','Rogowo','OPL','17-546','(80) 9804628')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Seweryn','ukowska 7','Kozielice','KJP','96-365','(90) 6408121')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Nawotka','cznoci 65','Wieczyce','MLP','05-200','(40) 3346848')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Chwist','ososiowicka 6','Mynwka','LDZ','48-039','(61) 3721040')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Maysz','uycka 2','Pniewy','SWT','80-583','(20) 6102037')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Rzeszoto','owiecka 44','Orzechowice','SLK','60-039','(21) 6576474')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Maciejewicz','ysogrska 57','Plesko','KJP','65-997','(40) 9716159')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Janson','dzka 87','Gocina','PDK','64-185','(70) 7282319')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Janson','ywiarzy 2','Pogorzelica','SLK','22-105','(21) 2317070')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Hepner','ubinowa 13','Ujcie','LDZ','71-601','(41) 7518817')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Hobica','Macedoska 6','Zoty Jar','LBS','43-582','(80) 9906751')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Jdraszek','Metalowcw 6','Paowice','LDZ','50-983','(41) 9596689')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Maysz','Modnickiego 7','Rogowo','DLN','50-478','(60) 4717953')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Rzeszoto','Mewia 24','Bdziew','MZW','85-390','(40) 5624397')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Rzeszoto','Modych Technikw 13','Kamienica','OPL','72-150','(40) 2841496')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Dawidek','Majakowskiego 23','Nowe Pole','DLN','91-922','(60) 2282623')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Wierzynek','Mciskiego 67','Rzdowice','SWT','45-653','(20) 4351680')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Janas','Modzieowa 33','Morg','LDZ','13-659','(41) 9055317')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Maciejewicz','Mianowskiego 43','Sulisawice','PDK','75-452','(70) 6362525')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hager','Mynarska 4','Daniec','MZW','18-247','(61) 7642909')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Kokot','Makowa 7','Zagaje','SLK','26-349','(50) 9873814')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Hobica','Miarki 2','Pustkw','MZW','62-502','(30) 2170516')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Baron','Mochnackiego 20','Piaski','ZCH','46-475','(50) 7175155')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Adamiak','Makuszyskiego 10','Pniewy','LBL','07-393','(40) 4142256')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Turo','Michalczyka 6','Dolniki','PMS','42-243','(30) 2485532')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Maysz','Modliska 6','Zwierzyn','PMS','92-802','(20) 7815002')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Niechcia','Malarska 4','Stalowa Wola','DLN','52-131','(51) 8657061')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Polak','Michaowskiego 56','Krzywka','ZCH','06-424','(50) 5673159')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Kokot','Modra 16','Witowice','LDZ','91-156','(20) 4713922')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Baron','Malborska 13','ubniany','WLP','06-167','(61) 7804341')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Kaczmarek','Modrzejewskiej 18','Trzebicz','WRM','62-946','(60) 8763693')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Kaczmarek','Malczewskiego 88','Piawa','ZCH','80-469','(50) 7006001')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Lewie','Miciskiego 56','Rydzewo','LDZ','61-241','(21) 7387531')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Reiss','Modrzewiowa 34','Pniewy','MLP','55-860','(30) 9208389')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Nawotka','Malczyka 50','Suchodolec','WRM','07-747','(20) 3897954')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Dawidek','Modrzewskiego-Frycza 23','Kurw','MZW','86-166','(40) 3137416')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Talko','Mojcicka 23','Botnica','WRM','98-171','(60) 2466159')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Idzi','Malinowa 3','Niwki','LBS','82-744','(80) 8775275')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Maciejewicz','Mokra 5','Zaborowo','MZW','53-350','(31) 2766118')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Hamak','Malinowa 7','Oarw','ZCH','70-088','(50) 2646902')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Chwist','Miechowity 7','Bogucice','ZCH','97-324','(31) 9878909')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Wierzynek','Mokronoska 73','Kamie','WLP','76-218','(50) 7286638')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Nawotka','Malwowa 32','Ozimek','LBS','09-246','(80) 2286003')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Dawidek','Miechowska 3','Szymanw','PMS','92-192','(20) 3105672')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Wojnowicz','Mokrzaska 54','Drwale','PDL','20-977','(91) 2502482')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Marszaek','Maa 3','Ludwinowo','MZW','60-152','(40) 9932110')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Wierzynek','Mieczykowa 3','Pokrzywice','MZW','57-287','(40) 5437394')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Dbiec','Maachowskiego 3','Krzyw','WRM','74-248','(20) 8427772')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Marszaek','Makowskiego 67','Kropielniki','LDZ','40-484','(21) 8894726')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Talko','Miejska 23','Gbie','PDL','03-829','(40) 4714050')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Maciejewicz','Monopolowa 28','Kamionka','SWT','06-381','(51) 9153710')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Egmont','Maomicka 30','Ligota','MZW','73-281','(30) 8273434')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Rzeszoto','Mielczarskiego 12','Rybnik','ZCH','03-471','(78) 2322428')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Eliasz','Monte Cassino 2','Plesko','OPL','57-875','(80) 6761530')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Seweryn','Maopanewska 2','Kosowice','LDZ','72-169','(61) 2199935')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Baron','Mielecka 5','Lbark','OPL','80-007','(30) 7383689')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Marszaek','Monterska 5','Nowe Pole','WLP','26-021','(50) 7489369')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Kokot','Maopolska 44','Korzonkowo','SLK','15-206','(50) 8773566')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Maciejewicz','Miernicza 4','Widowa','LDZ','81-722','(21) 4992779')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Wojnowicz','Morawska 2','Siemianw','PMS','42-274','(20) 8978224')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Kokot','Maoszyska 18','Krzywka','DLN','09-862','(21) 9536613')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Eliasz','Mierosawskiego 23','Morg','MLP','96-956','(60) 5360608')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Kaczmarek','Mieroszowska 43','Zembrzychowice','PMS','03-222','(31) 7561110')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Maciejewicz','Morelowskiego 3','Biadacz','PDL','13-491','(60) 8139495')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hamak','Manganowa 2','Zawiercie','LBS','84-551','(80) 8842056')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dbiec','Mieszczaska 32','aziska','OPL','63-425','(30) 3405268')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Dbiec','Morska 54','Pasieka','LDZ','00-651','(20) 5371618')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hobica','Marcepanowa 4','Jagnicin','PMS','26-076','(20) 3172082')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Talko','Mieszka I 3','Szumin','KJP','74-670','(40) 5916227')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Lewie','Morwowa 3','Filipowo','MZW','50-004','(30) 2464308')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Jdraszek','Midzylesia 5','Chocianw','KJP','13-481','(90) 5195741')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Chwist','Mosbacha 22','Jakubowice','ZCH','89-883','(50) 8959301')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Chwist','Marcinkowskiego 44','Krzyanwka','SWT','92-003','(30) 4273331')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Baron','Midzyrzecka 54','Skrzypnik','SLK','28-125','(50) 9123876')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Egmont','Mosina 5','Jdrzejowice','PDK','61-359','(20) 9006837')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Wierzynek','Marczewskiego 67','Nowa Wie Krlewska','LDZ','15-653','(20) 8405062')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Hobica','Midzyzdrojska 8','Pisk','PMS','52-731','(20) 7310544')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Lewie','Mostowa 9','Wrzeszcz','SLK','91-188','(21) 5417986')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Idzi','Markowskiego 11','Niwki','WLP','73-796','(31) 7863603')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Romanowicz','Mostowa 22','Pokoty','MZW','63-434','(31) 9729980')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Egmont','Marsowa 2','Kamie','LBL','19-617','(20) 9195566')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Romanowicz','Marszowicka 4','Przesieka','MLP','65-507','(40) 7123255')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Rzeszoto','Mikoowska 14','Kozielice','MLP','44-854','(30) 9746750')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Kaczmarek','Mocickiego 15','Mirw','PMS','16-034','(30) 9896733')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Nawotka','Marynarska 1','Turawa','OPL','69-191','(40) 3729411')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hepner','Mikulicza-Radeckiego 65','Strzelce','LDZ','46-242','(41) 4215887')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Stefanik','Mrgowska 6','Krzyanwka','SWT','12-831','(30) 5480924')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Lewie','Masztalerza 66','Igw','MZW','77-451','(30) 7966672')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Dbiec','Mikulskiego 6','Wieczyce','LDZ','83-943','(61) 3195461')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Nawotka','Mrona 34','Skubianka','LBL','58-336','(60) 7182907')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Baron','Masztowa 2','Mierzcin','MLP','64-952','(40) 8554876')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Reiss','Milicka 46','Kychw','MLP','96-312','(30) 4475681')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Marszaek','Muchoborska 4','Biernaty','PMS','69-508','(30) 3282757')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Maysz','Malicka 4','Dbkowice','SLK','42-458','(21) 7451647')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Seweryn','Mia 44','Kamienica','WLP','67-057','(61) 9059885')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Polak','Mulicka 6','Strzelce','MZW','14-311','(61) 2807284')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Kokot','Mikowska 7','Lubiatowo','SLK','96-850','(21) 5929547')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Baron','Murarska 7','Jackowo','LBS','65-936','(80) 3728477')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Romanowicz','Mazepy 34','Kychw','WLP','18-286','(31) 9515433')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Eliasz','Mioszycka 10','Zuchw','LBL','39-642','(60) 4574006')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Drewniak','Muzealna 33','Nowa Kunia','LBS','69-455','(80) 4219086')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Hajduk','Mazowiecka 65','Podbrzezie Grne','MZW','58-696','(30) 6367793')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Dbiec','Minkowskiego 56','Mysw','SWT','30-765','(20) 6769121')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Wojnowicz','Mydlana 22','Nieport','MLP','45-445','(30) 6995986')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Janson','Mczna 12','Turawa','OPL','15-515','(80) 9217679')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Hager','Miska 11','Biaobr','OPL','74-197','(40) 3793249')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Kaczmarek','Mysowicka 55','Filipowo','OPL','34-298','(30) 7849845')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Romanowicz','Meissnera 5','Kalinwka','LBS','93-238','(80) 2276827')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Chwist','Miodowa 57','Rzdowice','LBL','05-116','(20) 6908982')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Niechcia','Myszkowska 3','Pasieka','MZW','75-374','(61) 2817242')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Dbiec','Melioracyjna 98','Kurw','LBL','06-053','(40) 7873218')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Baron','Mirkowska 5','Chmurw','LBL','81-355','(20) 2943715')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Drewniak','Mirtowa 56','Biaobr','KJP','45-570','(40) 7045648')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Janson','Mennicza 66','Pniewy','ZCH','25-245','(31) 9889239')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Edelman','Mleczarska 3','Malinowice','SLK','82-884','(50) 9850607')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Egmont','Na Grobli 24','Szumin','SWT','24-476','(51) 5268804')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Adamiak','Nefrytowa 5','Czerwiesk','PDK','52-832','(80) 6782218')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hager','Norblina 76','Borycz','SLK','21-600','(80) 2645675')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hajduk','Na Kocu 3','Muszyna','DLN','25-387','(60) 5332153')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Lewie','Nehringa 2','Tarnw','PDL','69-068','(40) 9783742')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Polak','Na Niskich kach 23','Tarnw','PMS','36-195','(30) 5112944')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Romanowicz','Nektarowa 3','Oporw','DLN','40-415','(21) 8892497')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Dawidek','Nenckiego 1','Zembrzychowice','KJP','29-473','(40) 5675200')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Dawidek','Noskowskiego 64','Bukowina','PMS','39-547','(31) 8834676')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Dbiec','Na Polance 86','Hajnwka','LDZ','38-828','(41) 3024113')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Edelman','Nenufarowa 4','Biaobr','MZW','04-803','(31) 3741834')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Adamiak','Notecka 5','Jawiec','PMS','07-514','(30) 6389348')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Egmont','Na Szacach 34','Kychw','MLP','10-269','(60) 8929735')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Wierzynek','Nepalska 4','Osiecko','LDZ','95-027','(61) 2098994')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Reiss','Nowa 6','wirowo','MLP','98-740','(60) 8092157')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Adamiak','Nabielaka 7','Pierzchnica','WLP','41-901','(31) 9108579')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Hepner','Niborska 3','Jakubowice','KJP','05-693','(90) 7253947')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Rzeszoto','Nabyciska 43','Stawice','MZW','89-577','(61) 5239352')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Reiss','Nowodworska 67','Chmurw','MLP','58-648','(30) 9489424')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Turo','Nadbrzena 12','Stawice','DLN','77-233','(51) 8484299')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Maysz','Niecaa 6','Pasieka','KJP','61-309','(40) 6024475')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Egmont','Nowogrdzka 3','Ludwinowo','SWT','62-437','(20) 8551622')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Nawotka','Niedziakowskiego 6','Niebytw','OPL','96-825','(30) 9436936')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Hager','Nowohucka 76','Nowe Miasto','ZCH','37-504','(78) 5042640')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hamak','Nadrzeczna 22','Rzdowice','MZW','09-585','(61) 4876099')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Polak','Niedwiedzia 77','Zatory','MLP','38-431','(40) 3219332')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Rusin','Nowosdecka 64','Wrzeszcz','LDZ','49-887','(20) 8790447')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Egmont','Nakowskiej 32','Lbark','SWT','68-287','(20) 4061003')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Eliasz','Niemcewicza 23','Rawa','MZW','90-891','(31) 3232951')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Niechcia','Nowotarska 78','Kojno','MLP','81-930','(60) 3339770')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Marszaek','Namysowska 3','Gardo','ZCH','52-200','(50) 3139527')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Eliasz','Niemczaska 2','Leajsk','DLN','03-928','(51) 8452858')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Romanowicz','Nankiera 2','Rzdowice','WLP','89-454','(61) 4677501')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Romanowicz','Nowy wiat 34','Siemianw','PMS','76-549','(20) 3856909')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Kaczmarek','Narciarska 66','Pokorniki','KJP','34-327','(70) 4153167')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Kokot','Niepierzyska 32','wirowo','WLP','59-726','(50) 5660786')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Eliasz','Nowy Targ 30','Zawiercie','PMS','94-279','(20) 7338790')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Hager','Narcyzowa 72','Borycz','MZW','29-825','(30) 4403579')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Wojnowicz','Niepodlegoci 23','Natolin','OPL','46-456','(80) 6999641')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Adamiak','Noownicza 12','Iawa','LDZ','49-130','(41) 4480784')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Edelman','Nasienna 13','Chodzie','LDZ','85-096','(41) 4266914')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Seweryn','Niklowa 1','Przychd','LDZ','02-908','(20) 3184887')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Maysz','Nulla 2','Nowa Kunia','MLP','06-843','(30) 7697614')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Drewniak','Nasturcjowa 65','Makowice','LDZ','25-917','(61) 9971802')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Lewie','Nizinna 54','Nowe Pole','MZW','43-298','(40) 9771761')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Drewniak','Nyska 34','Bagacz','WRM','65-250','(70) 8836893')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hamak','Nasypowa 3','Dolniki','OPL','75-246','(30) 6486504')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Smythe','Nauczycielska 23','Rawa','DLN','51-384','(21) 8351549')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Dbiec','Nobla 66','Rawa','OPL','87-870','(40) 7868991')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Kaczmarek','Objazdowa 4','ambinowice','SLK','74-293','(50) 6348527')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Jdraszek','Oksywska 3','Pasieka','PDK','51-368','(80) 5205086')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Jdraszek','Obodrzycka 23','Pokorniki','SLK','86-536','(80) 9812533')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Drewniak','Okulickiego 12','nin','MZW','36-337','(40) 6580274')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Baron','Orzeszkowej 15','Oporw','PMS','80-152','(20) 4870762')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Maysz','Obornicka 1','Zawada','MLP','98-288','(30) 6667358')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Stefanik','Oleska 3','Kropielniki','DLN','09-273','(21) 5456362')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Hepner','Osadnicza 5','Czerwiesk','LBL','90-693','(60) 6351774')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Kaczmarek','Obona 7','Stanowo','WRM','55-306','(20) 7633040')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Adamiak','Olenicka 98','Suchodolec','DLN','90-903','(21) 8046644')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Baron','Osiecka 33','Kychw','WRM','56-575','(60) 6115288')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Kaczmarek','Obrocw Helu 13','Skubianka','PDK','48-347','(20) 2425880')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Eliasz','Olszewskiego 34','Krzyanwka','MZW','49-285','(40) 7823937')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Niechcia','Osiedlowa 4','Bulin','MLP','89-362','(60) 4245959')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Lewie','Obrocw Poczty Gdaskiej 3','Stalowa Wola','MLP','91-693','(40) 3281008')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Drewniak','Olsztyska 6','Stanisaww','MLP','38-050','(30) 5188196')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Seweryn','Osiniecka 78','Wachw','DLN','68-357','(21) 2447092')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Eliasz','Oawska 3','ka','PDL','37-508','(91) 9243616')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Idzi','Osobowicka 2','Winowo','LBS','96-335','(80) 3931707')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hobica','Obiska 46','Kalinwka','PDK','80-842','(80) 6588769')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Edelman','Osolska 5','Blachw','PDK','80-217','(70) 8174372')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Talko','Odeska 3','Sulisawice','PDL','86-309','(60) 7535082')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Edelman','Oowiana 2','Pokorniki','WRM','87-854','(60) 3444354')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Janas','Ostowa 34','Krzywka','SWT','75-984','(30) 4483581')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Seweryn','Odkrywcw 76','Ligota','PDL','43-672','(91) 7295301')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Reiss','Otaszyska 34','ochw','KJP','42-305','(70) 3440094')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Hager','Ostrynowa 32','Piskory','SLK','61-433','(50) 8438254')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Kaczmarek','Odolanowska 65','Nowe Pole','PMS','11-898','(31) 5006274')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Reiss','Omska 67','Bogucice','WLP','63-330','(61) 7509726')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Reiss','Ostroroga 7','Gocina','ZCH','41-034','(50) 8495015')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Dawidek','Odrodzenia Polski 82','Limanw','WRM','57-277','(20) 5692841')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Egmont','Opatowiecka 81','Tarnw','LDZ','02-104','(20) 2970142')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Maciejewicz','Ostrowska 2','Halinw','SLK','69-287','(50) 7849740')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Chwist','Odrzaska 5','Bulin','LDZ','45-480','(21) 6875439')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Wierzynek','Opotkowa 15','Kunica','OPL','52-796','(40) 4963725')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Marszaek','Ostrowskiego 75','Jackowo','PMS','46-154','(30) 4212365')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Eliasz','Opolska 34','Godzienices','PMS','21-817','(20) 6543858')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Baron','Ostrdzka 34','Ujcie','WRM','69-503','(70) 2706061')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hepner','Oporowska 5','Kropida','SLK','79-796','(21) 3905991')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Maysz','Ostrzeszowska 64','Paczkw','ZCH','15-578','(50) 9990486')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Adamiak','Oficerska 3','Chocianw','MLP','41-053','(60) 2889434')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Hager','Oppmana 33','Konin','WLP','26-281','(50) 5455775')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Edelman','Otmuchowska 23','Malinowice','SLK','66-664','(50) 2928743')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Turo','Oraczy 12','Zoczew','PDL','64-811','(91) 3376156')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Janas','Otwarta 1','Zgorzelec','MZW','61-683','(40) 9111334')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Jdraszek','Orawska 9','Cezarw','WLP','01-746','(61) 9341040')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Drewniak','Otyska 94','Nadlesie','LBL','05-558','(40) 6068903')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Nawotka','Orkana 61','Strzelce','PMS','67-139','(20) 9547108')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Maciejewicz','Owczarska 10','Strumienna','PDL','12-632','(91) 8294860')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Maciejewicz','Owocowa 12','Krzywka','ZCH','53-018','(50) 6682491')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Edelman','Orlt Lwowskich 24','Wiciejowo','OPL','44-591','(30) 7884257')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Niechcia','Orliskiego 20','Pustkw','PDK','75-632','(70) 6285400')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Jdraszek','Owsiana 21','Zawiercie','MZW','21-748','(40) 2194919')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Niechcia','Oklna 12','Gajkw','LDZ','31-853','(41) 3258789')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Maysz','Orowicza 1','Pniew','WRM','05-021','(70) 6310753')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Smythe','Oynowa 1','Winiowiec','SWT','09-084','(20) 4241894')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Marszaek','Okrtowa 3','Wieliszew','MZW','45-496','(30) 5119449')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Rzeszoto','Orna 56','Dolniki','LBS','33-066','(80) 3701743')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Rzeszoto','Okrzei 2','Borycz','SLK','23-440','(21) 9528047')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Polak','Pabianicka 12','Paczyna','MZW','62-945','(61) 9362991')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Polak','Piawska 11','Krzyanwka','PDL','23-641','(40) 7854085')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hobica','Potockiego 72','Zbrosawice','LDZ','67-979','(20) 6877658')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Lewie','Pachnca 71','Kosowice','KJP','18-957','(70) 4877298')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Maciejewicz','Pikarzy 2','Skaryn','MLP','45-267','(30) 3292620')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Kokot','Potokowa 4','Blachw','SWT','58-935','(30) 7496086')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Romanowicz','Paczkowska 1','Zbiersk','SWT','62-858','(20) 3265953')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Jdraszek','Pisudskiego 35','Kamienica','DLN','85-389','(51) 9666220')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Eliasz','Powiewna 4','Blachw','LBL','37-637','(40) 5661465')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Janson','Paderewskiego 1','Rogowo','LBS','21-807','(80) 7329505')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wierzynek','Powstacw lskich 56','Dobropole','SLK','82-343','(50) 6291014')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Niechcia','Piounowa 32','Przybyw','ZCH','08-450','(78) 4136371')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Hager','Powstacw Warszawskich 12','Kaliszewo','ZCH','81-110','(50) 2560455')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Lewie','Pionierw 4','Szczawno','SWT','80-047','(20) 2719609')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Janson','Palisadowa 5','Pokrzywice','LDZ','77-893','(21) 5761308')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Edelman','Powstacw Wielkopolskich 7','Suchodolec','DLN','07-931','(51) 2240710')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Edelman','Paucka 33','Biaobrzegi','MZW','87-158','(30) 4835496')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Stefanik','Pionierska 12','Makowice','WLP','53-500','(50) 8949554')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Wierzynek','Poziomkowa 54','Niebytw','WLP','61-222','(50) 3195739')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Maysz','Pankiewicza 66','Chocianw','PMS','04-897','(20) 4583384')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wierzynek','Piotrkowska 85','Kocielisko','MZW','73-596','(31) 4522456')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hepner','Poznaska 1','Zawiercie','MLP','93-746','(40) 3175307')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Chwist','Papiernicza 23','Szczedrzyk','LDZ','02-733','(41) 9202260')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Janas','Pnocna 6','Zagaje','SWT','13-866','(30) 9279781')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hamak','Paprotna 23','Szczedrzyk','KJP','25-526','(40) 5180400')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Jdraszek','Pirenejska 4','Wrzosw','SWT','88-790','(20) 4190813')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Idzi','Parafialna 6','Nowa Kunia','LDZ','54-959','(41) 2908731')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Wierzynek','Parandowskiego 9','Sulisawice','PDK','60-005','(20) 8835826')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Stefanik','Piwniczna 17','Zwierzyn','LBL','81-269','(20) 6288072')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Chwist','Pracy Aleja 21','Nogat','LDZ','92-754','(41) 2399424')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Chwist','Parkowa 31','Antoninek','DLN','01-000','(21) 5237028')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hager','Prdzyskiego 12','Siemianw','DLN','21-310','(21) 5002525')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Wierzynek','Piwowarska 6','Zawada','WLP','43-313','(50) 5615634')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hobica','Platanowa 7','Morg','SWT','80-558','(30) 3628565')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Adamiak','Henryka Probusa 23','Skubianka','LBS','27-957','(80) 2383404')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Baron','Promenada 8','Chocice','WLP','95-797','(31) 9649765')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Maciejewicz','Paska 88','Pniewy','PMS','14-237','(30) 3593643')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Niechcia','Parnickiego 2','Wrzosw','DLN','27-611','(21) 3040658')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Eliasz','Poskiego 3','Pierzchnica','SWT','25-378','(51) 7109096')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Polak','Partynicka 23','Stanisaww','MZW','93-691','(30) 7692360')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Turo','Puna 76','Pytkie','KJP','57-659','(70) 9679294')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Wojnowicz','Prudnicka 78','Zimnica','WLP','14-497','(31) 8975295')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Maysz','Partyzantw 23','Krzyw','WRM','08-684','(70) 2193187')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Baron','Pobonego Henryka 2','Jeziorna','PDL','54-608','(91) 9892347')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Janson','Prusa 35','Jarzbinowo','KJP','84-168','(90) 2785898')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Janas','Pochya 48','Szczawno','LBL','56-664','(60) 4876657')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Chwist','Prusicka 53','Rawa','LBL','67-616','(20) 5717713')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Egmont','Pasieczna 49','Nowogrdek','LBL','89-749','(40) 3801534')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Wojnowicz','Przebiniegowa 2','any','SLK','62-265','(21) 5555619')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Turo','Pastelowa 65','Nowa Wie Krlewska','MZW','59-112','(40) 9086191')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Hager','Podbiaowa 2','Pasieka','LDZ','39-669','(61) 2537024')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Idzi','Przechodnia 6','Dugoka','PMS','49-083','(20) 2569296')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Jdraszek','Pasterska 7','Igw','WRM','54-297','(20) 8838459')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Hobica','Podchorych 62','Falmirowice','PMS','96-076','(20) 8808526')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Maciejewicz','Przedmiejska 4','Plesko','OPL','08-527','(30) 5568393')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Janas','Pasteura 67','Wiciejowo','LDZ','13-537','(41) 7868623')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Maciejewicz','Podrnicza 3','Tyniec','PMS','77-396','(31) 2025488')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Hajduk','Przednia 3','Drwale','SWT','15-722','(20) 7920648')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Adamiak','Pauliska 2','Lipinka','WRM','27-504','(70) 7233876')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Lewie','Podwale 8','Bukowo','PDK','12-182','(80) 6775415')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Niechcia','Pawia 40','Pruszkw','SLK','89-417','(50) 5379335')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Maysz','Podwrcowa 3','Zoczew','MZW','69-823','(30) 4877320')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Egmont','Przejazdowa 43','Czempinw','MZW','67-980','(61) 4800419')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hepner','Pawowa 23','Wrzosowisko','MZW','64-420','(40) 2601031')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hamak','Pogodna 5','Gniazdw','LDZ','99-876','(21) 8493918')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Niechcia','Pawowicza 78','Bylica','PDL','68-457','(60) 4569758')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Pola 1','Witowice','LBL','92-841','(60) 3750220')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Przemiowska 33','Aleksandrw','LDZ','47-175','(41) 7777084')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Wierzynek','Pedagogiczna 7','Niwki','OPL','05-887','(30) 6619430')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Sotysik','Przemkowska 78','O','ZCH','59-690','(50) 8214549')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Rusin','Peczyska 3','Wonice','LDZ','54-914','(41) 7170337')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hobica','Polanowicka 8','Wierzchowiska','LBS','87-075','(80) 6781489')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Jdraszek','Przemyska 1','Stanowo','PMS','53-096','(20) 7028571')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Nawotka','Pereca 32','Gniazdw','ZCH','34-262','(31) 5239822')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Turo','Polarna 13','Gajkw','KJP','20-401','(90) 7139547')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Niechcia','Przemysowa 21','Natolin','LBS','77-646','(80) 8940761')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Kokot','Przerwy-Tetmajera 18','Kozielice','SLK','21-626','(80) 5424035')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Maysz','Perska 3','Szczedrzyk','PMS','55-278','(20) 7113674')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Lewie','Polkowicka 67','Krzywka','MLP','17-325','(30) 2079457')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Talko','Przesiecka 3','Zaborowo','PMS','21-494','(20) 7361558')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Wierzynek','Perzowa 7','Cezarw','PDL','37-006','(60) 4288245')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Idzi','Przestrzenna 1','Piawa','LDZ','12-892','(61) 3279840')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Edelman','Przy Krzyu 7','Przybyw','SLK','08-961','(21) 8113864')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Niechcia','Pgowska 35','Paszczew','PMS','97-493','(20) 3771483')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Dawidek','Pkalskiego 77','Hajnwka','DLN','06-116','(21) 9263334')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Hamak','Przybyy 100','Rybaczwka','DLN','03-998','(51) 6969612')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Dawidek','Piaskowa 5','Grdek','ZCH','92-274','(78) 8513359')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Rzeszoto','Przybyszewskiego 56','Tyniec','PDK','52-978','(70) 3401126')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Turo','Przyjani 7','Tyniec','PDK','78-119','(70) 3561383')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Hobica','Piastowska 3','Ligota','MLP','36-915','(60) 7143017')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Janson','Przylaszczkowa 12','Szymanw','PDL','21-362','(91) 8994194')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Kaczmarek','Przystankowa 67','Piskory','ZCH','20-926','(78) 3874365')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Dbiec','Piastw Aleja 9','Kodzko','OPL','30-402','(30) 4261901')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Egmont','Poabian 89','Wieliszew','MZW','61-075','(61) 2317231')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hajduk','Piechoty 78','Brochw','KJP','55-884','(70) 7135385')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Chwist','Poaniecka 53','Stoczek','SWT','62-144','(51) 2073909')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Turo','Pszczelarska 95','ambinowice','WRM','79-512','(20) 8760565')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hepner','Pszczyska 23','Skaryn','LDZ','21-713','(61) 4436260')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Reiss','Pszenna 21','Kalenica','KJP','34-509','(90) 3738076')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Kokot','Pielgniarska 65','Grochw','OPL','32-463','(40) 3004099')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Marszaek','Pomaraczowa 8','Nidowo','SLK','17-093','(50) 7127199')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Reiss','Ptasia 9','Podbrzezie Grne','KJP','39-548','(40) 4792853')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Wojnowicz','Pieniska 8','Biaobr','KJP','73-341','(40) 8193144')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Hager','Pomorska 5','Wrzosw','PDL','74-918','(60) 6683952')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Adamiak','Pieprzna 3','Kojno','PDL','70-823','(60) 4450014')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hepner','Poniatowskiego 23','Gniedzina','LDZ','15-478','(20) 5859681')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Adamiak','Pucka 75','Knieja','LDZ','89-369','(21) 5901063')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Dawidek','Piernikowa 3','Gniazdw','PMS','36-940','(30) 5026457')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Maysz','Popielskiego 3','Piawa','MZW','90-357','(61) 5232085')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Wojnowicz','Pierwiosnkowa 6','Krlikowo','ZCH','60-263','(78) 7183753')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Egmont','Popowicza 4','Osiecko','LBS','48-894','(80) 7579011')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Janas','Puaskiego 7','Paowice','DLN','12-541','(51) 4682127')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Talko','Pierwszej Dywizji 4','Winowo','ZCH','58-255','(50) 7774092')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Polak','Piesza 43','Dolniki','MLP','49-216','(40) 9256093')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Reiss','Putuska 44','Kropielniki','LDZ','40-972','(20) 4697227')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Janson','Pieszycka 32','Kaliszewo','MZW','09-503','(61) 3945788')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Reiss','Poranna 6','Dolniki','OPL','25-928','(80) 8543302')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Idzi','Purkyniego 3','Rybnik','PMS','01-886','(20) 3400659')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Janson','Pietrzykowicka 87','Brzeg','MLP','75-851','(60) 6802625')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Rzeszoto','Porbska 7','Borycz','SWT','41-566','(20) 3616634')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Drewniak','Pusta 29','Kropida','LBS','74-569','(80) 8539803')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Turo','Poroniska 26','Niwki','WRM','86-746','(20) 3605514')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Adamiak','Pustecka 85','Zuchw','MZW','08-409','(40) 8938652')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Janas','Pikna 84','Mokre','WRM','45-612','(20) 3877519')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Rzeszoto','Porzeczkowa 26','Jeziorna','SWT','01-100','(20) 5681988')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Eliasz','Puszczykowska 64','ubniany','OPL','50-888','(40) 8450251')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Baron','Postpowa 96','ochw','MLP','86-586','(40) 8996394')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Rusin','Pyrzycka 23','Krlikowo','OPL','23-857','(80) 3171504')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Eliasz','Postoliska 2','Wieczyce','OPL','29-094','(40) 5167291')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Egmont','Pilczycka 6','Zbiersk','LDZ','74-699','(41) 4975663')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Idzi','Powicka 9','Paczkw','PMS','24-833','(30) 3095939')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Drewniak','Pilnikarka 34','nin','MLP','11-037','(40) 7064655')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Rabczaska 74','Wrzosowisko','MZW','44-729','(61) 7863170')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Baron','Rezedowa 22','Daniec','LDZ','48-381','(61) 3852374')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Stefanik','Raciborska 11','Widowa','KJP','56-119','(40) 4792668')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Turo','Rdziska 3','Jagnicin','SWT','06-861','(20) 6177412')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Edelman','Racawicka 7','Rdziny','DLN','45-808','(60) 6503770')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Egmont','Rkodzielnicza 345','Bartniki','PDL','91-751','(60) 9102003')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hobica','Ruciana 45','Pokrzywice','PDL','02-515','(60) 4955634')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Stefanik','Radarowa 65','Makowice','LBS','86-540','(80) 4390358')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Hager','Robotnicza 42','Wrblin','MLP','82-733','(30) 8526069')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hobica','Rudawska 23','Bodzanw','LBL','69-006','(20) 2100343')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Eliasz','Rodakowskiego 21','Gajkw','KJP','51-923','(40) 4216553')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Rzeszoto','Rudzka 12','Wrblin','SWT','49-259','(51) 4272057')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Janson','Radowa 15','Grdek','LBL','74-696','(20) 9842095')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Dawidek','Rodziewiczwny 30','Bylica','MLP','20-667','(30) 2240125')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Talko','Rumiankowa 39','Kropida','MZW','69-452','(61) 4669708')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Marszaek','Radomska 3','Zoty Jar','KJP','33-048','(70) 5309056')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Baron','Rodzinna 6','Krzyw','MZW','74-351','(40) 8883209')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Janas','Ruska 77','Antoninek','MZW','22-507','(40) 6671270')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Polak','Radosna 32','Turawa','LBL','96-477','(60) 9041327')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Idzi','Roentgena 73','Rawa','WRM','57-284','(60) 2158615')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Janas','Radzionkowska 23','wirowo','DLN','41-092','(60) 3901327')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Maciejewicz','Rogowska 65','Szydw','WRM','83-994','(20) 3657496')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Egmont','Rajska 84','Winiowiec','OPL','42-831','(80) 7582625')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Marszaek','Rolna 32','Mierzcin','LBS','83-633','(80) 6992937')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Nawotka','Rybia 38','Ozimek','PMS','45-738','(20) 8822101')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Hobica','Rolnicza 50','Rdziny','SLK','71-724','(21) 3908179')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Jdraszek','Rybickiego 82','Stanowo','ZCH','03-992','(78) 6905104')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Rusin','Rakowa 3','Krlikowo','OPL','01-982','(30) 9928659')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Niechcia','Rybnicka 23','Rembertw','MLP','00-221','(30) 7183334')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Hager','Rakowiecka 21','Kaliszewo','WRM','57-859','(60) 9995461')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Rusin','Romera 2','Wonice','PDK','03-267','(70) 4890100')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wojnowicz','Rycha 1','Rembertw','SWT','41-374','(51) 5365581')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Eliasz','Rakowska 9','Pylnik','MZW','12-274','(61) 3938654')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Wierzynek','Roosevelta 82','Leniczwka','WRM','93-563','(20) 3746609')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Kokot','Rychtalska 3','Siemianw','LDZ','58-985','(41) 7540578')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Kokot','Rapackiego 5','Lbark','ZCH','05-957','(50) 4344654')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Stefanik','Rydygiera 6','Zuchw','PMS','65-118','(31) 7357437')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Drewniak','Rataja 5','Krzyanwka','KJP','07-445','(40) 7534627')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Janas','Rostafiskiego 13','Zaborowo','WRM','76-685','(60) 7885179')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Rusin','Rymarska 35','Zuchw','MLP','35-909','(30) 8958211')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Drewniak','Ratajw 6','Cezarw','LBS','22-152','(50) 4932978')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Romanowicz','Rolinna 6','Walendowo','DLN','28-990','(21) 3764113')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Maciejewicz','Rynek 4','Bogucice','OPL','66-294','(80) 6824519')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Nawotka','Ratyska 23','Kropida','ZCH','93-381','(78) 4735454')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Lewie','Roweckiego-Grota 4','Korzonkowo','PDL','56-635','(40) 5199912')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Turo','Rawicka 4','ochw','WRM','37-001','(70) 8145370')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Janson','Rowerowa 5','Bylica','PDL','84-327','(91) 4018734')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Wojnowicz','Ryska 30','Zatory','LDZ','73-437','(41) 2959188')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Rzeszoto','Rawska 43','Jackowo','LBS','06-379','(80) 9647888')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Wierzynek','Rozbrat 1','Pogorzelica','PMS','33-034','(31) 9152762')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Maciejewicz','Rytownicza 32','Mierzcin','KJP','01-065','(90) 6750276')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Kokot','Rdestowa 3','Wolica','WRM','39-987','(60) 5089805')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Eliasz','Rozjezdna 6','Wrzeszcz','ZCH','53-432','(31) 2610487')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Wojnowicz','Rzeczna 5','Strumienna','PDK','39-837','(80) 5348329')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Polak','Rozmarynowa 23','Bodzanw','KJP','92-746','(70) 8827965')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Egmont','Rzemielnicza 3','Iawa','ZCH','86-724','(31) 9131518')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Dawidek','Redycka 3','Borowina','MZW','28-772','(61) 7063399')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Chwist','Rodzieskiego 3','Przychd','SWT','24-787','(30) 4757641')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Adamiak','Reja 67','Rybaczwka','ZCH','58-755','(78) 3444278')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Eliasz','Rwna 2','Muszyna','MZW','23-069','(30) 2017844')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Talko','Rzepakowa 3','Szumin','PDL','41-986','(40) 6606842')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Janson','Rzeszowska 12','Jackowo','MZW','48-327','(61) 2275911')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Janas','Rejonowa 24','any','LBL','63-807','(60) 6018902')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Adamiak','Rana 3','Laryszw','DLN','85-096','(21) 9917343')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Romanowicz','Rzebiarska 2','Zgorzelec','SLK','35-963','(21) 5258233')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Eliasz','Rejtana 1','Pogorzelica','PMS','37-403','(20) 7005351')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Seweryn','Rewalska 6','ka','DLN','05-138','(51) 7138528')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Eliasz','Ry Wiatrw 7','Blachw','OPL','71-484','(40) 6734597')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Rusin','Reymonta 6','Chodzie','PMS','66-582','(20) 9352112')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Dawidek','Ryckiego 5','Planica','MZW','83-905','(30) 7677786')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Janson','Subicka 32','Gardo','LBL','04-689','(60) 7383901')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Stefanik','Starachowicka 12','Gardo','SLK','04-442','(21) 8355449')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Kaczmarek','Supska 11','Brzezina','LDZ','07-396','(20) 3448313')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Idzi','Strachowskiego 2','Stanowo','WRM','68-099','(70) 3986509')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Lewie','Sadownicza 6','Pokrzywki','SWT','26-296','(20) 6220111')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Eliasz','Smardzowska 74','Wianki','WRM','15-653','(70) 9109482')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hager','Samborska 30','Ostrda','ZCH','79-320','(31) 8127385')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Polak','Smtna 10','Stanowo','LBL','07-071','(60) 7959392')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Seweryn','Stranicza 2','Kosowice','OPL','17-879','(30) 8862147')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Polak','Samolotowa 4','Cezarw','MZW','57-211','(61) 8108760')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Maysz','Smocza 5','Filipowo','WRM','05-325','(20) 3970265')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Adamiak','Strczkowa 5','Ostrda','PDK','28-156','(20) 7384247')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Dawidek','Samotna 3','Morg','MLP','78-626','(60) 3181688')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Hager','Smolecka 23','Zaborowo','PMS','37-558','(31) 5627807')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Jdraszek','Stroma 64','Korzonkowo','WLP','90-113','(50) 9326200')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Baron','Samotworska 21','Pokorniki','PMS','67-383','(31) 3132432')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Drewniak','Smoleskiego 2','Krzyw','MZW','51-182','(31) 2523154')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Janson','Struga 1','Gbie','WRM','82-418','(60) 9469843')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Egmont','Sanocka 23','Nowa Wie Krlewska','SWT','24-819','(51) 8286919')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Niechcia','Smolna 6','Kaliszewo','LDZ','92-912','(20) 8534713')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Niechcia','Strumykowa 66','Widowa','PDK','38-837','(20) 2638000')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Dawidek','Saperw 31','Zaborowo','MZW','20-743','(30) 3385270')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Stefanik','Smoluchowskiego 12','Jagnicin','LBS','16-686','(80) 8482052')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Egmont','Stryjska 53','Jakubowice','SLK','53-467','(80) 2820373')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Turo','Sarbinowska 22','Pogodna','PMS','47-713','(30) 4528263')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Reiss','Snopkowa 11','Zawada','SWT','95-640','(30) 5366404')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hajduk','Strzegomska 18','Zembrzychowice','WLP','43-760','(50) 5003807')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Rzeszoto','Sarnia 19','Skibice','OPL','51-775','(80) 6388570')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Polak','Snycerska 2','Pytkie','LDZ','53-951','(20) 7331363')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Janson','Strzegomska 34','any','DLN','00-317','(21) 8104461')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Wierzynek','Sasankowa 12','Kurw','KJP','34-574','(40) 2251888')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Idzi','Jana III Sobieskiego 2','Nowa Wie Krlewska','PMS','43-007','(20) 6285949')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Adamiak','Strzelecka 56','Gorzw','ZCH','95-899','(31) 3202143')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Talko','Sdowa 33','Pokrzywki','MZW','39-015','(40) 9322790')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Reiss','Sobieszowska 27','Bodzanw','MLP','72-839','(40) 5819666')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hepner','Strzeliska 78','Knieja','LBL','58-210','(60) 3516499')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Wierzynek','Semaforowa 2','Czerwiesk','WLP','91-301','(50) 6148173')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Hamak','Studzienna 12','Zagaje','MLP','12-949','(40) 4162360')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Niechcia','Sobtki 24','Ostrda','KJP','27-129','(90) 8388607')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Lewie','Serbska 22','Wierzchowiska','MLP','52-751','(60) 6425661')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Hager','Sochaczewska 1','Siemiatycze','LBL','79-482','(20) 2972292')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Wierzynek','Stysia 6','Skrzypnik','LDZ','31-244','(61) 3531490')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Janas','Serowarska 93','Korzonkowo','LBS','05-565','(80) 9575935')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Jdraszek','Sucharskiego.12','Pokorniki','DLN','79-747','(51) 2114693')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Lewie','Sewastopolska 3','Polichna','OPL','88-535','(40) 2080406')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Egmont','Spa-Szarzyskiego 2','Rogowo','KJP','46-871','(40) 6518837')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Lewie','Solskiego 1','Zaborowo','KJP','35-511','(70) 5823561')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Niechcia','Spia 76','Chocianw','LBL','88-509','(40) 9742273')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Wierzynek','Sotysia 92','Knieja','SWT','27-513','(51) 4396536')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Chwist','Siatkarzy 21','Jankw','WRM','17-590','(70) 6759631')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Janson','Sotysowicka 26','Stanisaww','ZCH','68-254','(78) 6251254')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Turo','Sulejowska 27','Jeziorna','KJP','47-977','(90) 7999363')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Hobica','Siedlecka 26','Ludwinowo','MZW','03-612','(31) 8231113')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Janson','Sopocka 17','Gorzw','MLP','91-879','(30) 8788155')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Lewie','Sulmierzycka 73','Ozimek','PDK','08-696','(80) 2573059')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hepner','Siedlczan 36','Chocice','KJP','95-155','(90) 8383316')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Stefanik','Sosnkowskiego 26','Wiciejowo','PMS','64-358','(30) 8157528')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Rusin','Supiskiego 63','Kopiczew','DLN','19-880','(51) 6442483')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Maciejewicz','Sielska 2','Zuchw','WLP','70-037','(31) 4922971')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Turo','Swobodna 12','Leniczwka','SLK','08-555','(21) 2645235')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Janas','Siemiskiego 67','Nieport','DLN','64-801','(60) 3874925')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Wojnowicz','Sosnowiecka 17','Zwierzyn','MLP','89-330','(30) 3211464')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Rusin','Siemiradzkiego 1','Podbrzezie Grne','DLN','53-470','(60) 7776858')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Eliasz','Sowia 56','Mirw','SWT','06-626','(20) 8102586')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Janson','Sycowska 6','Nogat','LBS','59-694','(80) 3079250')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Idzi','Sowiskiego 73','Bukowina','MZW','86-503','(31) 2622955')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Seweryn','Sygnaowa 21','Cezarw','MZW','52-859','(40) 5805632')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Chwist','Sienna 1','Niebytw','OPL','71-197','(40) 3103051')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Adamiak','Syjamska 6','Bartniki','ZCH','51-558','(31) 6506665')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Nawotka','Sieradzka 12','Kocielisko','DLN','02-537','(60) 6931987')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Maciejewicz','Spadochroniarzy 3','Hajnwka','PMS','66-593','(31) 7150092')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Turo','Sierakowskiego 12','Knieja','PDL','57-716','(60) 8684341')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Egmont','Spiska 9','Mysw','KJP','92-518','(70) 4593465')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Kokot','Siewcw 21','Witowice','KJP','87-463','(70) 7215705')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Romanowicz','Spiowa 2','Chocianw','LBL','91-862','(60) 9883280')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Janson','Szachistw 58','Rybnik','LBL','87-238','(20) 4956265')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Baron','Siewierska 89','Pytkie','LDZ','55-996','(41) 2839987')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Maysz','Szafera 3','Siemianw','SWT','84-197','(51) 2992842')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Edelman','Szafranowa 23','Jarzbinowo','PDL','72-264','(60) 3502583')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Drewniak','Sikorza 31','Lubiatowo','MLP','72-888','(60) 6775878')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Adamiak','Sportowa 37','Gniedzina','SWT','02-460','(20) 4795545')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Maysz','Szajnochy 73','Witowice','WRM','07-578','(60) 9014083')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hajduk','Siostrzana 36','Knieja','MLP','44-486','(30) 6837056')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Reiss','Szara 26','Piawa','LBS','10-608','(80) 9424581')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Rzeszoto','Szarotki 38','Kodzko','ZCH','74-113','(78) 3843759')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Jdraszek','Skarbka 31','Rawa','PDL','81-131','(60) 5179662')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Polak','Skarbowcw 26','Godzienices','LDZ','88-673','(41) 8265492')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Marszaek','Szarych Szeregw 73','Ujcie','SWT','13-623','(51) 7723468')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Niechcia','Stacyjna 17','Lipinka','MLP','99-590','(30) 7044733')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Chwist','Staffa 74','Nowa Kunia','KJP','60-518','(40) 7816220')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Baron','Szczawiowa 2','Rzdowice','LBS','45-615','(80) 2540721')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Baron','Stajenna 7','Szczawno','DLN','98-382','(60) 4396816')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Reiss','Szczeciska 3','Nadlesie','PDK','23-635','(80) 5051473')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Adamiak','Szczepanowska 8','Oarw','LDZ','81-961','(20) 7137914')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Maysz','Stalowowolska 2','Wiciejowo','PMS','58-934','(30) 5644158')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Dawidek','Skierniewicka 5','Stobrawa','PDK','95-496','(80) 4454817')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Maciejewicz','Stanisawowska 2','Suchy Br','SLK','61-792','(80) 7935562')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Wojnowicz','Szczepowa 48','Szumin','OPL','35-690','(80) 2572779')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Dbiec','Skadowa 58','Kunica','MZW','42-272','(40) 7725595')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Eliasz','Stanisawskiego 27','any','WRM','85-671','(70) 3584561')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Talko','Szczliwa 27','Kamionka','SLK','80-097','(21) 3120077')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Dbiec','Skoczna 2','Czersk','PDL','64-372','(40) 8130334')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Kokot','Stanw Zjednoczonych 7','Natolin','WRM','71-476','(60) 7930252')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Lewie','Szczycieska 84','Nowogrdek','PMS','60-649','(20) 2505273')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Baron','Skoczylasa 24','Koswki','DLN','99-759','(21) 3188767')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Kaczmarek','Starobielawska 27','Gbie','OPL','86-558','(80) 3843441')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Idzi','Starodbowa 21','Siemianw','PDL','01-791','(40) 3289073')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Reiss','Skrajna 94','Dobropole','LBL','09-144','(20) 7342795')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Edelman','Starodworska 43','Dbkowice','LBL','26-851','(60) 7813471')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Romanowicz','Szczytnicka 5','Lbark','WLP','45-112','(50) 9042419')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Kaczmarek','Starogajowa 4','Falmirowice','SWT','10-040','(20) 3573272')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Jdraszek','Szeli 2','Gocina','MZW','27-780','(31) 8034323')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Baron', 'Skrzydlata 74','Bodzanw','LDZ','80-653','(41) 5835400')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Nawotka','Starogroblowa 27','Wieczyce','PMS','61-817','(20) 8201129')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Janson','Staromyska 73','Nowe Pole','PMS','57-031','(31) 6664389')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Hepner','Starociska 26','Zychw','PMS','05-058','(20) 6052007')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Kokot','Szklarska 73','Zuchw','WRM','29-992','(20) 8387937')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Kaczmarek','Skwerowa 23','Skibice','WLP','03-676','(50) 9109042')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Dawidek','Starzyskiego 3','Pogorzelica','LBS','42-154','(50) 7853096')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Lewie','Sodowa 21','Strumienna','MLP','09-822','(30) 3230267')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Kaczmarek','Somiana 18','Stanowo','LDZ','49-567','(21) 6375866')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Hajduk','Soneczna 16','Szczodrw','PDL','80-311','(60) 3608816')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Niechcia','Szpilkowa 16','Aleksandrw','MZW','19-129','(31) 3152604')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Stefanik','Sonecznikowa 15','Kychw','MLP','63-691','(30) 5851991')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hepner','Szprotawska 1','Botnica','KJP','63-884','(40) 6303416')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Drewniak','Sotna 6','Krzyw','PMS','76-751','(20) 9242216')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Drewniak','Stobrawska 42','Pytkie','DLN','25-596','(21) 5374861')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Stefanik','Szronowa 19','Oarw','PDK','17-367','(70) 7074549')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hepner','Stoczniowa 5','Limanw','MLP','38-953','(30) 2917565')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Turo','Sztabowa 4','nin','PDK','85-543','(70) 8731763')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Janson','Stodolna 12','any','WRM','36-794','(60) 5026591')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Dbiec','Szwajcarska 12','Kropielniki','LDZ','09-540','(61) 8364184')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Siemianowska 24','Jankw','SLK','80-724','(80) 8542654')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Maciejewicz','Gbinowa 11','Wolica','PMS','98-943','(20) 8774777')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hajduk','Zaporowa 21','Czempinw','PDK','26-497','(80) 8631527')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Idzi','Jawiecka 4','Walendowo','DLN','71-575','(21) 3393183')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Lewie','Leajska 12','Wodziejkowice','MLP','58-529','(30) 4522240')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Idzi','Daniecka 3','Filipowo','LBL','26-099','(40) 4966680')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Janson','Pokrzywowa 12','Stawice','SLK','52-948','(50) 7148894')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Turo','Pniewska 26','Stanisaww','PDL','57-202','(40) 3879297')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Talko','Sowiaska 4','Borowa Gra','PMS','53-512','(31) 6504212')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Polak','Strachociska 7','Skibice','LBL','35-242','(40) 4644535')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Adamiak','cinawska 12','Wieczyce','LBS','69-805','(80) 2312145')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Adamiak','miga 16','Szczedrzyk','LDZ','97-202','(61) 3510418')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Dbiec','wieradowska 1','Kamienica','WRM','32-074','(70) 3899147')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Dbiec','niadeckich 6','Pylnik','KJP','20-873','(40) 3793852')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hajduk','niegockiego 5','Szerokie','MLP','62-072','(30) 3008945')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Smythe','wiea 8','Rybaczwka','MZW','79-092','(31) 7778496')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Turo','lepa 5','Turawa','ZCH','44-306','(31) 5192919')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Eliasz','niena 83','Tyniec','DLN','95-949','(21) 5897628')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Rzeszoto','witej Trjcy 73','Suchodolec','MZW','07-037','(31) 7680406')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Janas','redzka 74','Piaski','LBS','51-816','(50) 9887712')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Wojnowicz','witochowicka 38','Kocielisko','PDL','47-429','(60) 5366559')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Kokot','rodkowa 38','Pokrzywki','PMS','09-075','(20) 2837645')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Janson','witochowskiego 3','Botnica','LDZ','60-211','(41) 4695569')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Drewniak','laska 23','Zoty Jar','PDK','55-432','(80) 8604900')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Rusin','rdlena 35','Nidowo','DLN','54-230','(21) 3247367')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Adamiak','witojaska 4','Strumienna','MLP','86-682','(30) 5727021')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hepner','rubowa 59','Witowice','MLP','66-267','(60) 6679141')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Reiss','witokrzyska 48','Kojno','OPL','75-798','(30) 4140220')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Dawidek','rutowa 37','Czempinw','DLN','06-499','(21) 4879265')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Edelman','winoujska 36','Pruszkw','PDK','00-227','(70) 5839002')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Nawotka','liwkowa 23','Siemiatycze','SWT','94-972','(51) 6946479')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Edelman','witnicka 11','ochw','PDK','24-261','(70) 4014079')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Wierzynek','liwowa 5','Wrzosw','OPL','73-469','(30) 4923415')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Wojnowicz','widnicka 9','Zakroczym','ZCH','58-367','(50) 9434011')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Seweryn','lusarska 8','Sulisawice','MLP','02-134','(40) 9836823')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hager','wiebodzka 4','Pierzchnica','MZW','42-341','(30) 6954304')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Wierzynek','Talliska 1','Skrzypnik','WRM','75-251','(60) 2012070')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Hager','Tokarska 91','Machnice','KJP','24-162','(70) 2682944')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Lewie','Trzebiatowskiego 28','Konin','OPL','15-528','(30) 7120780')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Rusin','Trzebnicka 73','Pruszkw','DLN','31-427','(51) 4768560')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hobica','Taskiego 58','Zawiercie','MZW','31-272','(40) 8110688')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Dbiec','Tomaszowska 67','Rudno','LBS','57-245','(80) 6466718')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Kokot','Trzebowiaska 29','Bylica','MLP','45-840','(60) 4339063')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Kokot','Tapicerska 5','Pylnik','MLP','07-452','(30) 2192028')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Romanowicz','Topolowa 4','Czerwiesk','LBS','33-714','(50) 3954292')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Lewie','Trzemeska 94','Gniazdw','WRM','81-026','(20) 5349069')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Edelman','Tarninowa 37','Iawa','PDK','22-607','(20) 9193469')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Wojnowicz','Torfowa 36','Mysw','MLP','80-592','(30) 6776321')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Romanowicz','Trzmielowicka 37','Wonice','MLP','45-949','(30) 8327077')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Rusin','Tarnobrzeska 89','Knieja','LBL','74-868','(20) 6370594')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Nawotka','Torowa 83','Wrzosowisko','PDL','55-147','(40) 5957117')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Hobica','Tunelowa 35','Sulisawice','PDL','59-948','(91) 4797659')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Janas','Tarnogajska 35','any','MZW','25-980','(61) 5537268')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Rusin','Toruska 34','Winowo','MLP','91-280','(40) 3972054')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Baron','Turecka 4','Dbrwka','SLK','18-506','(21) 3782931')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Janas','Tarnopolska 7','Morg','LBL','83-232','(60) 3074291')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Chwist','Towarowa 8','Obory','PDL','74-873','(91) 2713236')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Jdraszek','Tarnowska 84','Przesieka','LBL','98-102','(60) 2837918')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Stefanik','Traktatowa 76','Sulimw','PMS','64-383','(20) 7119377')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Wojnowicz','Turniejowa 46','Wrzeszcz','PMS','71-460','(31) 8869167')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Jdraszek','Traktorowa 35','Dolniki','SLK','10-203','(50) 9206849')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Wierzynek','Turoszowska 58','Krzyanwka','PMS','45-695','(20) 2792157')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Romanowicz','Tatarakowa 45','Leniczwka','OPL','57-082','(80) 4101443')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Niechcia','Tramwajowa 35','Ozimek','WLP','08-635','(61) 3800857')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Adamiak','Tuwima 33','Bulin','LDZ','64-480','(61) 2016087')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Jdraszek','Tatarska 23','Strumienna','MZW','59-125','(61) 9658296')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Janas','Traugutta 21','Lubiatowo','MZW','34-437','(30) 4872878')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Drewniak','Twardogrska 32','Plesko','SLK','46-433','(50) 7630726')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Baron','Tatrzaska 23','Grdek','PDK','08-599','(70) 5050900')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hajduk','Trawna 19','Grdek','MLP','55-354','(60) 8171709')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Wojnowicz','Tybetaska 10','Stoczek','MLP','93-755','(30) 2015673')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hepner','Tczewska 12','Szczedrzyk','LBS','33-898','(80) 8234354')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Drewniak','Trawowa 32','any','MZW','00-268','(31) 2627317')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Kokot','Teatralna 12','Borycz','SLK','85-425','(21) 8790164')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Reiss','Tymiankowa 2','Szymanw','MLP','02-758','(60) 4877796')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Kokot','Tenisowa 76','aziska','PDK','72-121','(80) 5416211')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Maysz','Treski 87','Pierzchnica','DLN','57-449','(21) 6749805')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Maysz','Tyrmanda 9','Pisk','DLN','01-654','(51) 8622622')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hager','Terenowa 2','Igw','MLP','35-509','(30) 3997178')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Edelman','Tyska 94','Skubianka','PMS','93-933','(30) 8787574')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Chwist','Trjktna 12','Rogowo','DLN','56-796','(21) 6555880')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Romanowicz','Truskawkowa 4','Pniewy','DLN','49-808','(51) 2289284')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Idzi','Tkacka 3','Czersk','LDZ','33-361','(61) 9423947')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Chwist','Trwaa 6','awsk','PMS','68-592','(31) 5685703')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Dawidek','Ubocze 42','Bagacz','ZCH','57-093','(50) 7636962')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hobica','Ulanowskiego 2','Stoczek','SLK','86-303','(80) 2767887')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Janas','Upalna 21','Paczyna','OPL','90-887','(40) 3160908')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hobica','Uczniowska 20','Skaryn','WRM','31-468','(70) 2991261')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hobica','Ulowa 23','Wrzosw','OPL','47-689','(80) 9444492')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Seweryn','Urbaskiego 74','Chyw','MLP','20-387','(60) 8314249')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Maysz','Uaska 73','Rudno','KJP','66-822','(40) 5447286')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Edelman','Ustronie 27','Winiowiec','PMS','38-730','(30) 7030984')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Kaczmarek','Ujejskiego 58','Polichna','PMS','21-938','(20) 8660284')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Seweryn','Uniwersytecka 12','Sulisawice','OPL','81-324','(80) 3336070')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Janas','Uznamska 7','Biaobrzegi','MLP','19-997','(40) 7226702')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Wojnowicz','Ukraiska 8','Jackowo','OPL','47-037','(30) 5477610')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Kaczmarek','Ukryta 32','Ozimek','OPL','75-632','(40) 4564138')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Dawidek','Wadowicka 12','Kychw','LDZ','10-591','(41) 9197977')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hajduk','Wielkopolska 2','Mirw','PDL','70-279','(40) 8469412')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Kokot','Waflowa 93','Pniewy','LDZ','18-225','(21) 7170041')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Rusin','Wieluska 28','Stoczek','DLN','30-448','(21) 6398700')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Hajduk','Wojrowicka 27','Mierzcin','LBS','79-051','(80) 9199819')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Edelman','Wagonowa 1','Drwale','MZW','84-508','(30) 2568790')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Janson','Wieniawskiego 29','Ostrda','WRM','48-990','(70) 4040772')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Adamiak','Wojska Polskiego 8','Ludwinowo','DLN','82-373','(21) 2786568')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Lewie','Walecznych 7','Wierzchowiska','MLP','29-158','(30) 3376216')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Maysz','Wierzbowa 53','Antoninek','LDZ','87-434','(41) 2680062')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Kokot','Wojszycka 3','Wodziejkowice','LDZ','25-584','(41) 6941561')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Romanowicz','Waligrskiego 12','Kamierzw','SLK','75-153','(50) 5045655')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Hamak','Wierzchowicka 49','Zuchw','SWT','42-130','(20) 9370357')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Hamak','Wojtkiewicza 26','Wierzchowiska','SLK','97-654','(21) 6144292')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Dbiec','Witolda 35','Tarnw','ZCH','03-491','(50) 3576350')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Hager','Wieniacza 12','Halinw','LBL','98-722','(20) 4622796')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Polak','Wolbromska 83','Rydzewo','PMS','30-143','(30) 9382042')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Talko','Waloska 2','Kamierzw','LDZ','88-551','(61) 8843615')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Kaczmarek','Wietnamska 2','Muszyna','MLP','12-125','(60) 6310438')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Talko','Wabrzyska 1','Morg','LBS','12-646','(80) 4425609')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Lewie','Wietrzna 84','ambinowice','MZW','53-519','(40) 2969986')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Edelman','Waowa 35','Podbrzezie Grne','WLP','74-230','(61) 5575720')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Adamiak','Wizienna 25','Wolica','MZW','84-512','(61) 6108901')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Reiss','Wolska 35','Gajkw','WRM','94-553','(60) 4217604')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Maciejewicz','Wilanowska 31','Konin','PDK','62-911','(20) 5928359')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Talko','Woczyska 12','Paczyna','MZW','20-456','(30) 8403589')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Nawotka','Wakowicza 12','Rudno','MLP','11-980','(60) 8362266')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Janson','Wilcza 54','Oporw','SLK','13-580','(21) 3988539')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Drewniak','Wogogradzka 21','Wiciejowo','PDL','66-491','(60) 3226587')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Seweryn','Wilczkowska 12','Kamionka','PMS','80-592','(20) 3090475')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Maciejewicz','Wapienna 24','Jarzbinowo','SWT','23-843','(20) 6797433')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Rzeszoto','Wilczycka 60','Zuchw','PMS','28-802','(30) 9322037')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Dbiec','Woyska 43','Wieliszew','PMS','22-139','(31) 7803398')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Baron','Warciaska 95','Borycz','PDL','56-537','(60) 3400144')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Drewniak','Worcella 36','Rudno','PMS','92-091','(20) 7319844')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Reiss','Wileska 3','Rogowo','PMS','12-673','(20) 6804437')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Reiss','Woronowicka 6','Laryszw','WLP','54-629','(31) 9512118')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Turo','Warmiska 7','Kopiczew','PMS','84-661','(20) 3537351')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hamak','Wilgotna 3','Kodzko','PMS','61-080','(20) 5918908')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Eliasz','Woskowa 21','Rydzewo','PDK','99-464','(20) 5342908')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Edelman','Warszawska 4','Tomaszw','MLP','97-817','(60) 5953219')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Chwist','Wilgowa 6','Natolin','LBS','46-746','(50) 4486580')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Lewie','Wonicza 7','Skaryn','MZW','02-216','(40) 8515673')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Nawotka','Wjtowska 32','Walendowo','LDZ','58-702','(61) 7579809')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Chwist','Warzywnicza 6','Brzezina','KJP','61-829','(90) 3348116')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Dbiec','Willowa 33','Turawa','SLK','05-919','(80) 2403029')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Hajduk','Watowa 31','Witowice','LBL','93-638','(20) 4873743')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Hobica','Wawrzyniaka 76','Jackowo','KJP','93-603','(70) 7271295')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Baron','Winogronowa 64','Kluczbork','MZW','25-249','(61) 3432211')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Rusin','Wronia 33','Gajkw','ZCH','67-595','(50) 2967840')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Rzeszoto','Wiska 54','Laryszw','WRM','24-920','(20) 8419457')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Nawotka','Wrbla 2','Pisk','PMS','64-512','(20) 4641179')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Jdraszek','Wejherowska 2','Paczkw','WLP','52-302','(31) 8323195')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Hepner','Wrblewskiego 44','Dugoka','SLK','65-410','(50) 5784585')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Wojnowicz','Weniana 63','Chocice','OPL','26-742','(40) 2191306')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Lewie','Wrzosowa 43','Rembertw','LBS','37-341','(80) 7754040')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Turo','Wesoa 68','Dbiec','LBS','72-162','(80) 6751003')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Wierzynek','Wschodnia 43','Gniedzina','SLK','25-587','(50) 6621606')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Edelman','Wesoowskiego 12','Skrzypnik','SLK','57-005','(80) 3929584')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Rusin','Wszystkich witych 2','Antoninek','PMS','60-568','(31) 6208549')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Wierzynek','Wdkarzy 3','Brochw','WRM','35-744','(60) 2427981')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Janas','Wybickiego 2','Szerokie','DLN','23-427','(51) 5513419')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Reiss','Wita Stwosza 52','Kamie','SLK','45-862','(80) 5055253')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Janson','Wyboista 21','Jakubowice','KJP','03-146','(90) 5224901')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Stefanik','Wgierska 32','Pokrzywki','ZCH','40-085','(31) 4394792')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Reiss','Wyczkowskiego 1','Strumienna','ZCH','02-409','(78) 9827728')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Egmont','Wglowa 23','Obory','LBS','27-149','(80) 7017080')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Niechcia','Witebska 2','Ostrda','ZCH','41-461','(31) 4864449')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Niechcia','Wygodna 1','Nadlesie','SWT','91-088','(51) 7667574')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Kaczmarek','Wykadowa 22','Kamionka','WRM','54-543','(60) 3632856')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Stefanik','Wiaduktowa 26','Walendowo','KJP','73-416','(70) 7050807')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Turo','Witkowska 33','Jdrzejowice','MZW','00-778','(61) 8282516')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Egmont','Wylotowa 30','Jankw','SLK','27-565','(80) 9049070')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Talko','Wizowa 1','Kamierzw','KJP','36-391','(90) 3897139')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Turo','Widawska 31','Paowice','SLK','79-971','(21) 7112237')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Baron','Witosa 32','Krlikowo','MZW','20-128','(30) 2289743')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Kokot','Wysockiego 3','Nowogrdek','LBL','57-176','(60) 3508608')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Niechcia','Widakowa 6','Wiciejowo','SLK','48-753','(80) 2443846')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Wierzynek','Wittiga 7','Ludwinowo','LDZ','63-313','(61) 3266844')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hager','Wysoka 7','Obory','SWT','44-500','(51) 8157136')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Chwist','Widna 30','Muszyna','LDZ','17-366','(20) 6526340')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Janas','Wyspiaskiego 2','Rybnik','WLP','41-353','(50) 5771355')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Edelman','Wieczorna 99','Krzyanwka','MLP','84-566','(60) 9032639')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Wojnowicz','Poranna 3','Rybnik','ZCH','42-027','(50) 6594359')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Stefanik','Wadysawa Jagiey 2','Rogowo','DLN','61-303','(21) 6533721')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Adamiak','Wystawowa 3','Pruszkw','MZW','42-531','(31) 4969570')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Romanowicz','Wadysawa okietka 1','Antoninek','MLP','97-925','(40) 8819269')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Janson','Wyszyskiego 35','Walendowo','MLP','46-176','(30) 8527289')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Hobica','Wiedeska 35','Palenisko','SLK','68-814','(80) 7230247')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Eliasz','Wodkowica 31','Stoczek','ZCH','13-925','(78) 3556597')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Idzi','Wycigowa 27','Czarny Las','LBS','24-087','(80) 9232387')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Reiss','Wiejska 74','Bogucice','SWT','22-931','(30) 8037803')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Nawotka','Wociaska 32','Ozimek','PMS','82-325','(20) 7985438')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Eliasz','Wielka 3','Borycz','ZCH','30-164','(50) 7367662')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Niechcia','Wodna 33','Pogorzeliska','WRM','48-689','(70) 4496254')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Maciejewicz','Wodzisawska 32','Stanisaww','LDZ','62-984','(21) 9201832')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Maysz','Zabocie 14','Rybaczwka','WRM','67-798','(70) 2216075')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Baron','Zapolskiej 4','Szczawno','ZCH','83-550','(31) 8452287')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Turo','Zgodna 6','Dbrwka','LBL','45-750','(20) 7785599')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Talko','Zabrodzka 8','Zawada','KJP','98-923','(70) 6990657')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Polak','Zgody 1','Oporw','LDZ','00-665','(61) 9716678')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Talko','Zabrzaska 8','Kocielisko','MZW','13-752','(30) 2924709')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Jdraszek','Zapotocze 2','Bukowina','OPL','26-103','(40) 4664734')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Eliasz','Zielarska 98','Muszyna','WRM','47-415','(20) 2125451')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Drewniak','Zachodnia 63','Aleksandrw','DLN','76-768','(60) 7130249')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Janson','Zarembowicza 2','O','ZCH','62-485','(31) 2822553')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Dbiec','Zieliskiego 2','awsk','OPL','10-836','(40) 4391907')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Drewniak','Zaruskiego 12','Mierzcin','WLP','76-399','(31) 9940083')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dawidek','Zielna 34','Nowe Miasto','LBS','48-301','(50) 4218248')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Baron','Zagaje 94','Chyw','WRM','53-207','(70) 2028753')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Hamak','Zarzecze 47','Gocina','SLK','29-727','(50) 5341914')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Wojnowicz','Zagbiowska 34','Strzelce','PDK','97-271','(80) 7329159')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Marszaek','Zatorska 12','Witowice','PMS','84-739','(20) 2292835')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Marszaek','Zielonego Dbu 15','Leniczwka','PDK','95-798','(70) 8102724')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Janas','Zielonogrska 23','Wieliszew','PMS','44-684','(20) 2370958')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Kokot','Zagony 3','Chocianw','SLK','82-070','(80) 9517321')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Baron','Ziemniaczana 89','Wodziejkowice','MZW','58-782','(31) 2580348')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Rusin','Zagrodnicza 23','Sulimw','MLP','16-254','(30) 4207786')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Egmont','Zawalna 3','Malinowice','SWT','98-183','(51) 4167761')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Hager','Ziemowita 6','Zgorzelec','OPL','05-668','(40) 5023797')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Reiss','Zagrzebska 15','Witowice','MLP','57-287','(40) 8593040')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hager','Zawierciaska 63','Borowina','MZW','11-370','(31) 8903833')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Eliasz','Zibicka 51','Lubiatowo','OPL','86-701','(80) 4667917')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Hajduk','Zajazdowa 84','Piskory','PMS','12-956','(20) 4470190')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Hamak','Zawiszy Czarnego 23','Wielkie','PMS','17-213','(20) 6531066')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Reiss','Zimowa 56','Palenisko','WLP','28-430','(61) 2124256')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Adamiak','Zajczkowska 21','Kurw','SLK','59-158','(50) 4399509')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Hajduk','Zawoska 3','Pytkie','WLP','11-032','(61) 3506534')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Drewniak','Zocieniowa 3','Borycz','PMS','86-550','(20) 3604711')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Stefanik','Zakadowa 30','Zawada','ZCH','69-893','(78) 4941115')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Lewie','Zakopiaska 47','Kalinwka','LBS','40-353','(50) 9858962')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Dbiec','Zboowa 48','Wodziejkowice','KJP','86-390','(40) 3657584')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Turo','Zotnicka 4','Tyniec','PMS','10-265','(30) 4441882')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hager','Zakrzowska 47','Kluczbork','MZW','23-084','(61) 9536562')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Dawidek','Zotoryjska 4','Gorzw','LBL','79-400','(60) 2928157')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hajduk','Zaleskiego 49','Halinw','LBL','47-105','(40) 3210368')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Idzi','Zdrojowa 48','Rybnik','MLP','41-230','(30) 5470836')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Wierzynek','Zotostocka 4','Aleksandrw','PMS','14-875','(31) 7039510')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Baron','Zalewowa 47','Szumin','PDK','23-169','(70) 8156789')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Hamak','Zdrowa 3','Widowa','MLP','90-020','(40) 6076979')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Chwist','Zotowska 2','Wrzosw','WRM','76-169','(20) 7278168')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Romanowicz','Zalipie 2','Kocielisko','WLP','91-377','(50) 9370558')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Eliasz','Zduska 33','wirowo','SLK','14-720','(21) 2261972')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Dawidek','Zmorskiego 56','Kamienica','MLP','92-938','(30) 8687625')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Marszaek','Zae 88','Gniedzina','KJP','16-591','(70) 4997043')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Drewniak','Zebrzydowska 35','Wielkie','PMS','22-632','(20) 9172159')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Baron','Zoli 34','Borowa Gra','LBL','16-741','(20) 9372107')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Wojnowicz','Zamenhofa 3','O','OPL','31-805','(40) 4858925')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Drewniak','Zefirowa 3','Kozietuy','LBS','54-723','(80) 4659684')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Romanowicz','Zwiadowcw 2','Pogorzeliska','MLP','32-287','(60) 5648049')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Rzeszoto','Zamojska 88','Chocice','MLP','59-988','(40) 6531983')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Stefanik','Zegadowicza 36','Biernaty','PMS','22-899','(20) 8637458')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Wierzynek','Zwrotnicza 78','Kamionka','PDL','84-457','(91) 9591101')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Dawidek','Zamoyskiego 36','Dugoka','OPL','52-296','(30) 8432909')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Janas','Zwyciska 38','Kamierzw','LDZ','16-723','(61) 6963142')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Kokot','Zaolziaska 36','Rybnik','OPL','90-016','(80) 7239555')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Reiss','Zelwerowicza 21','Czerwiesk','DLN','37-281','(21) 8800082')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Baron','Zapanicza 37','Gniazdw','LDZ','02-599','(21) 3514295')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Maciejewicz','Zemska 37','Bdziew','PDK','99-143','(70) 9508487')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Jdraszek','eromskiego 22','Dolniki','ZCH','56-662','(78) 3867350')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Wojnowicz','urawia 2','Kamionka','WRM','43-219','(20) 7312421')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Talko','agaska 1','Lbark','PDL','95-810','(60) 9030806')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Talko','ulowcw 24','Gardo','LDZ','82-831','(21) 5997138')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Hamak','arska 21','Wrzosowisko','SLK','63-237','(50) 6599075')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Idzi','michowskiej 94','Sulimw','LDZ','16-765','(41) 2578405')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Kokot','egiestowska 26','Orzechowice','MZW','66-912','(40) 5243508')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Eliasz','migrodzka 85','Polichna','PMS','55-183','(31) 6584546')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Polak','wirowa 35','Kamie','SWT','09-221','(30) 3298610')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Nawotka','eglarska 36','Lipinka','LBS','67-826','(50) 2822551')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Niechcia','mudzka 20','Przesieka','SWT','27-932','(51) 2317603')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Niechcia','ymierskiego 2','Szymanw','PMS','88-847','(31) 3177850')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Seweryn','elazna 12','Strumienna','LDZ','20-365','(20) 2434274')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Egmont','niwna 2','ubniany','DLN','37-656','(21) 7445586')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Drewniak','ytnia 1','Pruszkw','PMS','47-639','(31) 6244354')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wojnowicz','onierska 27','Krzywka','LDZ','40-166','(21) 6759487')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Maciejewicz','ywiecka 28','Niebytw','MLP','40-876','(30) 3993877')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Hajduk','ecw 88','Kychw','ZCH','59-794','(31) 5401683')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Dbiec','ywopotowa 35','Biaobrzegi','LBS','56-227','(80) 2738254')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Turo','ernicka 2','Winowo','PMS','72-610','(20) 6818052')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Janas','ubrza 2','Wieliszew','SWT','50-608','(30) 4353015')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Niechcia','Blokowa 2','Krzywka','LDZ','46-001','(41) 7528948')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Rusin','Bobrw 3','Chodzie','MZW','75-004','(31) 7043451')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Baron','Bagnowska 49','Rembertw','SWT','05-217','(20) 4677405')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Maciejewicz','Borsucza  2','Paczkw','WRM','07-244','(70) 3140617')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Drewniak','Banachiewicza 21','Pokorniki','LBS','97-197','(80) 8976149')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Maciejewicz','Boruty 2','Borowa Gra','PDL','71-078','(91) 3891417')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Hepner','Baranowicka 24','Godzienices','SLK','86-026','(80) 8878032')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Turo','Botaniczna 24','Bartniki','MLP','13-488','(60) 4112741')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Maysz','Bracka 47','ubniany','LDZ','39-405','(41) 9549706')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Eliasz','Barszczaska 26','Trzebicz','SWT','37-046','(20) 9290871')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Stefanik','Braska 26','Kojno','OPL','90-520','(30) 8588657')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Marszaek','Brodowicza 73','Mynwka','SWT','09-251','(51) 2045624')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Niechcia','Przyklasztorna 12','Nieport','SWT','84-676','(51) 4101921')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Hajduk','Batalionw Chopskich 2','Leniczwka','WLP','95-678','(31) 6490953')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Niechcia', 'Baniowa 29','Biaobrzegi','WRM','03-431','(20) 5926111')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Idzi','Brukowa 26','Szczodrw','WLP','36-033','(50) 6382425')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Rusin','Baantarska 42','Bdziew','OPL','79-745','(40) 6182060')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Eliasz','Brzechwy 2','Turawa','OPL','26-808','(80) 2756813')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Hepner','Bednarska 12','Kozietuy','PMS','29-636','(30) 7466721')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Kokot','Berezyska 81','Czarny Las','PDL','06-366','(60) 6381235')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Polak','Budowlana 2','Kosowice','PDK','27-942','(70) 7599929')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Polak','Buska 26','Krzywka','SWT','50-459','(20) 8976259')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Turo','Blicharskiego 2','Nogat','LBS','61-225','(80) 2258474')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Polak','Caa 26','Gardo','OPL','30-961','(40) 6526602')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Kaczmarek','Ciepa 12','Oarw','MLP','84-168','(30) 3446763')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Dawidek','Cedrowa 2','Kamie','LBS','97-852','(50) 3755434')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Wierzynek','Ciesielska 2','Tyniec','LDZ','29-491','(20) 5945359')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Maciejewicz','Cegielniana 24','Kalenica','PMS','28-782','(30) 6147087')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Maysz','Cieszyska 12','Bylica','LBS','55-743','(80) 3347494')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Hager','Celownicza 32','Kamienica','LBL','68-078','(40) 4261617')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Drewniak','Ciokowskiego 12','Wiciejowo','LDZ','42-385','(20) 5499902')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Talko','Cisowa 48','Gardo','MLP','02-093','(30) 5015952')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Hobica','Cygaska 32','Krlikowo','SLK','66-487','(50) 3172555')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Hamak','Czarnej Haczy 2','Pruszkw','DLN','42-745','(60) 6823593')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Adamiak','Choroszczaska 26','Pokrzywki','OPL','20-460','(40) 3537156')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Hepner','Chopska 26','Suchy Br','SLK','16-147','(50) 9218080')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Hajduk','Cienista 25','Suchy Br','PMS','55-164','(30) 6383487')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Jdraszek','Daktylowa 1','Koswki','LBS','78-172','(50) 5780700')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Stefanik','Dunikowskiego 4','Czersk','WLP','57-799','(61) 8702932')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Janson','Dojlidzka 4','Pokoty','OPL','03-872','(30) 7058150')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Eliasz','Dojnowska 39','Kluczbork','MLP','98-917','(60) 7430802')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hager','Dolistowska 27','Pierzchnica','LDZ','22-571','(61) 6340124')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Maysz','Dzielna 2','O','SWT','07-964','(30) 4092281')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Hager','Dziesiciny 27','Zbiersk','PDK','95-559','(20) 2889053')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Maysz','Doynkowa 27','Suchy Br','WRM','61-704','(70) 9105093')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Rusin','Drewniana 28','Kychw','ZCH','58-233','(50) 7475446')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Rzeszoto','Dwiska 3','Jarzbinowo','ZCH','94-919','(31) 5544237')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hajduk','Elektryczna 38','Kopary','MLP','73-553','(40) 5003571')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Marszaek','Ekologiczna 83','Biaa Woda','LBS','67-737','(80) 9929387')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hamak','Familijna 1','Rogowo','DLN','68-724','(21) 2800438')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Polak','Figowa 38','Niebytw','LBL','48-984','(20) 2098791')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Hobica','Gajowa 4','Bodzanw','MZW','51-934','(40) 7534295')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Niechcia','Godapska 4','Krzyw','DLN','99-922','(60) 9526765')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Drewniak','Gedymina 32','Daniec','PDL','31-063','(60) 7407115')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Hamak','Giycka 43','Rogowo','OPL','67-759','(80) 2308134')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Niechcia','Grottgera 45','Oporw','MLP','81-207','(30) 6306796')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Maysz','Gruntowa  2','O','KJP','23-291','(70) 7996209')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Lewie','Glogera 9','Zbiersk','LBS','32-915','(80) 6811026')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Stefanik','Gwiazdkowa 28','Chyw','MZW','02-068','(40) 2655135')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Maysz','Gogola 2','Gardo','WRM','77-993','(20) 8701050')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Baron','Gwiezdna  21','Winiowiec','MLP','33-442','(30) 7285721')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dbiec','Gorkiego 22','Walendowo','KJP','14-777','(70) 3761801')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Idzi','Jaworowa 28','Pogorzelica','OPL','66-893','(40) 5903080')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Lewie','Jagielloska 26','Szczodrw','LBL','79-713','(20) 5565107')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Nawotka','Jaowcowa 73','Nadlesie','SWT','29-981','(30) 6573679')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Hobica','Jelenia 63','Makowice','LBL','37-164','(20) 3138954')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Rusin','Jaracza 2','Niwki','SLK','77-319','(50) 9486652')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Maysz','Jowisza 23','Gorzw','KJP','24-276','(40) 9038015')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hajduk','Jurowiecka 28 ','Paowice','WLP','14-950','(31) 7636446')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Reiss','Jutrzenki 3','Ozimek','LBS','72-802','(80) 6833922')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Maciejewicz','Arabska 23','Zbrosawice','LBS','09-463','(80) 3889171')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Nawotka','Abramowskiego 2','Krzywka','PDK','54-765','(70) 4490990')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Rzeszoto','Alpejska 22','Borowa Gra','SWT','16-274','(20) 6235229')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Kaczmarek','Archeologw 34','Bodzanw','ZCH','23-807','(78) 2640369')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Seweryn','Adamczewskich 33','wirowo','DLN','86-411','(21) 4973072')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Hepner','Altanowa 22','Bogucice','PDK','49-129','(70) 8322840')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Eliasz','Arctowskiego 5','Ludwinowo','PMS','36-193','(31) 9467189')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Dawidek','Adamieckiego 7','Nowogrdek','MLP','63-879','(30) 3075727')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Talko','Armii Krajowej 8','Siemianw','OPL','89-166','(30) 8417645')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Lewie','Admiralska 82','Pokoty','DLN','74-868','(60) 7917634')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Janson','Amarantowa 22','Rdziny','ZCH','24-700','(78) 7179801')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Nawotka','Afgaska 45','Bylica','PMS','05-489','(20) 6309995')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Lewie','Asfaltowa 42','Rybaczwka','KJP','92-575','(90) 2077016')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Polak','Agrestowa 4','Sulimw','DLN','68-717','(51) 7456628')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Niechcia','Ananasowa 53','Paczkw','KJP','77-981','(90) 9294464')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Maysz','Asnyka 9','Jarzbinowo','PDK','92-061','(70) 7025789')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Jdraszek','Augustowska 7','Nogat','PDK','26-270','(70) 4302382')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Hobica','Australijska 3','Zawada','SLK','41-341','(50) 3826431')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Kokot','Aleja Piastw 2','Chmurw','WLP','61-851','(61) 5237358')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Kokot','Avicenny 2','Koswki','MLP','15-170','(30) 9275635')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Hajduk','Aleja Pracy 23','Koswki','MZW','60-606','(61) 8393495')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Edelman','Azaliowa 23','Wrzosw','KJP','07-015','(90) 4469435')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Reiss','Aleja R 43','Kropielniki','LDZ','60-189','(61) 5257554')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Hobica','Biaowieska 22','Brzezina','MZW','56-714','(40) 9380515')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Polak','Baczyskiego 22','Paowice','OPL','17-599','(80) 8937400')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Marszaek','Braniborska 5','Chodzie','SLK','82-144','(80) 8618306')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Kaczmarek','Badury 32','Igw','MZW','84-433','(40) 3736671')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Idzi','Biegasa 35','Kunica','PDL','95-916','(60) 8287645')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Baron','Braniewska 2','Dbkowice','PDL','78-512','(60) 2077513')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Baron','Biega 3','Botnica','WRM','42-410','(20) 3957097')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Chwist','Brata Alberta 44','Borowina','LDZ','41-474','(61) 4245490')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hajduk','Bielarska 42','Kamionka','LBS','59-683','(50) 2082069')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Janas','Braterska 7','Lipinka','SWT','90-168','(30) 7191274')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Egmont','Bielawska 8','Mirw','WLP','64-803','(31) 2520117')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Egmont','Bratkowa 3','Zawada','LBS','73-998','(50) 5833664')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Edelman','Bierdzaska 9','Blachw','MZW','25-089','(30) 5954321')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Niechcia','Balzaka 8','Przesieka','WRM','31-115','(70) 6209454')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Eliasz','Bakaska 37','Rudno','KJP','39-114','(40) 7741601')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Niechcia','Biskupia 32','Korzonkowo','LBS','93-451','(50) 2703999')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Chwist','Bauckiego 33','Oarw','KJP','61-854','(90) 3900560')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Hepner','Biwakowa 4','Skrzypnik','OPL','12-453','(30) 7990463')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hepner','Brodatego Henryka 7','Pasieka','SWT','33-353','(30) 4994718')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hamak','Bliska 98','Wieliszew','PDL','02-390','(91) 2610955')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Stefanik','Brodziskiego 22','Czempinw','SLK','95-266','(50) 7730208')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Edelman','Bardzka 3','Krzyanwka','DLN','23-117','(51) 8668040')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Niechcia','Brodzka 4','Turawa','PDK','04-692','(70) 3908298')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Hepner','Bliniacza 7','Sawkw','MLP','49-171','(40) 6763317')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Kaczmarek','Bawatna 8','Przychd','LBS','79-616','(50) 4513314')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Wierzynek','Botna 53','Kurw','LDZ','97-061','(41) 8503059')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Wojnowicz','Brylantowa 34','Przybyw','PDL','35-400','(60) 2790824')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Hobica','Barycka 5','Kamienniki','PDL','07-644','(40) 7702117')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Hager','Bobrza 7','Kluczbork','ZCH','96-634','(78) 9882164')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Maysz','Bobrzaska 3','Biadacz','LBS','05-447','(50) 6765566')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Maysz','Bocheska 9','Bartniki','KJP','93-781','(40) 2985660')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Romanowicz','Brzeziska 22','Leajsk','PDL','81-828','(40) 5153805')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Talko','Bociania 24','Stobrawa','MZW','78-934','(30) 3495135')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Hager','Bazaltowa 34','Szczawno','KJP','73-828','(40) 6603083')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Marszaek','Becka 45','Borowina','OPL','20-114','(80) 9245540')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hobica','Buczacka 5','Osiecko','LDZ','35-611','(21) 7902673')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Lewie','Bednarska 87','Kychw','MLP','58-442','(60) 2310813')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Polak','Bogusawskiego 22','Dolniki','MLP','24-345','(40) 5928153')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Chwist','Belgijska 43','Kopiczew','LDZ','37-585','(20) 8137300')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Dbiec','Budziszyska 32','Kamie','ZCH','47-427','(78) 5704526')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hager','Belgradzka 8','Przychd','LDZ','39-839','(61) 8035343')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Chwist','Boguszowska 3','Kalinwka','SLK','42-901','(50) 6281135')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Edelman','Buforowa 2','Chocice','LBL','88-228','(20) 4366863')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Seweryn','Bujna 2','Biaobr','LDZ','89-952','(41) 7109602')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Egmont','Boiskowa 4','Bukowina','OPL','98-997','(30) 4501046')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hamak','Bujwida 53','Czarny Las','PDK','71-362','(20) 7712253')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Adamiak','Benedyktyska 5','Wrblin','MZW','93-865','(40) 3178472')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Nawotka','Bojanowska 7','Lipinka','WRM','34-786','(70) 7381747')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Idzi','Bolesawa Chrobrego 9','Wianki','LDZ','06-421','(41) 4976273')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Idzi','Bukowskiego 20','Koswki','LBS','24-737','(80) 5660891')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Maysz','Beniowskiego 22','Strzelce','ZCH','42-038','(31) 2740177')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Dawidek','Berberysowa 53','Szerokie','PMS','82-143','(31) 6348835')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Reiss','Bolesawa Krzywoustego 73','Jakubowice','LBL','75-675','(20) 5604518')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Chwist','Berenta 3','Tarnw','LDZ','33-366','(61) 5810144')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Edelman','Bolesawiecka 7','Nogat','DLN','96-948','(21) 4504569')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Dawidek','Bugarska 4','Nowa Wie Krlewska','MZW','15-537','(40) 4283440')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Nawotka','Berlinga 5','Falmirowice','LDZ','36-835','(20) 4752776')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Chwist','Bolkowska 7','Pokorniki','LBL','10-109','(60) 8982608')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Maysz','Buraczana 9','Kamienica','LBS','35-399','(50) 9588761')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Teresa','Talko','Bernardyska 202','Czempinw','MZW','81-470','(31) 7769757')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Lewie','Bursztynowa 4','Lbark','MLP','34-912','(30) 8379152')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Eliasz','Beskidzka 53','Gorzw','KJP','42-532','(40) 6022433')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Maysz','Bombardierska 3','Zbiersk','MLP','07-725','(30) 9162626')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Hamak','Burzowa 22','Gardo','LBL','94-122','(40) 5611777')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Reiss','Betonowa 28','Nowe Pole','WLP','53-298','(31) 5441720')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Baron','Buska 23','Sawkw','PDL','10-100','(91) 6630618')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Edelman','Bora-Komorowskiego 3','Kopary','WLP','23-733','(61) 8790280')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Seweryn','Byczyska 45','Brzezina','SLK','65-034','(21) 2661705')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Wojnowicz','Bydgoska 29','Podbrzezie Grne','SWT','62-203','(30) 9216633')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Lewie','Bezpieczna 24','wirowo','PMS','26-353','(20) 6285556')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Kaczmarek','Borna 27','Stanowo','WLP','63-643','(31) 6834818')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Niechcia','Bystrzycka 8','Wieliszew','WLP','57-799','(31) 7711635')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Maciejewicz','Bdziska 9','Palenisko','MLP','92-089','(30) 4745485')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Rusin','Bytomska 33','Szczodrw','LDZ','06-107','(41) 3094833')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Niechcia','Biaodrzewia 5','Gbie','WRM','14-022','(20) 6816295')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wierzynek','Borwczana 3','Dbrwka','LDZ','67-746','(41) 7404469')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Egmont','Bosaka-Haukego 22','Pisk','LBS','32-111','(50) 2136915')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Wojnowicz','Biaoskrnicza 5','ochw','PDK','57-630','(70) 8655275')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Wierzynek','Boya-eleskiego 73','Pasieka','KJP','28-719','(40) 7799962')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Idzi','Biaostocka 3','Muszyna','SLK','26-634','(21) 6054092')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Baron','Poznaskiej 27','Pokrzywki','PDL','53-550','(40) 3986471')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Reiss','Boego Ciaa 23','awsk','MZW','99-838','(40) 4987243')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Idzi','Cholewkarska 3','awsk','WRM','14-810','(20) 4770752')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Idzi','Cybulskiego 3','Korzonkowo','SLK','32-332','(50) 3550793')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hobica','Ceglana 7','Jawiec','SLK','58-258','(80) 6749716')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Stefanik','Chorwacka 22','Laryszw','LBS','04-479','(50) 7323182')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Polak','Cynowa  5','Krzyanwka','LBS','43-528','(80) 6983013')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Lewie','Celtycka 3','Gardo','LBS','03-510','(50) 7219933')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Janson','Chorzowska 35','Wachw','PMS','52-086','(30) 4112590')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Idzi','Cytrynowa 23','Pokrzywki','PDK','63-316','(70) 9058416')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Dbiec','Cementowa 35','Zagaje','LDZ','86-204','(41) 2384492')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Dawidek','Czackiego 3','Wrblin','WLP','59-326','(61) 5732874')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Chwist','Centralna 7','Morg','MZW','43-330','(30) 8337019')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Jdraszek','Czajcza 22','Ludwinowo','PDL','80-326','(91) 8589196')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Baron','Cerkwica 22','Morg','OPL','75-208','(30) 3927570')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Turo','Chrzanowskiego 35','Bagacz','PMS','24-118','(31) 8927143')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Hager','Czajkowskiego 83','Jeziorna','DLN','66-162','(51) 9691773')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Idzi','Chudoby 23','Zgorzelec','MLP','88-875','(30) 6191997')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Kaczmarek','Czarnieckiego 5','Niebytw','MLP','89-876','(30) 9998745')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Talko','Chabrowa 35','Gniazdw','SWT','57-081','(20) 9733861')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Dbiec','Chwakowska 3','Kamionka','DLN','29-075','(51) 9781575')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Edelman','Czarnoleska 3','Zegrzynek','WRM','93-913','(60) 2900065')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Hamak','Czechowa 3','Hajnwka','WRM','67-461','(70) 6790369')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Wierzynek','Chaubiskiego 7','Sulimw','MLP','06-965','(30) 4025411')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Micha','Polak','Cicha 8','Turawa','PMS','88-309','(30) 8939463')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Niechcia','Czechowicka 2','Korzonkowo','PDK','39-161','(70) 9366212')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Hepner','Chaupnicza 3','Skubianka','DLN','39-058','(60) 4625631')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Rusin','Ciechociska 78','Kosowice','SWT','91-756','(20) 4471358')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Eliasz','Czekoladowa 23','Laryszw','SLK','46-303','(80) 3605398')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Maysz','Cieplicka 22','Gocina','LDZ','99-292','(21) 8788865')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Polak','Czeremchowa 4','Wrblin','SLK','90-550','(50) 4379790')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Hager','Chemoskiego 5','Oarw','PDK','03-370','(20) 8457628')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Egmont','Ciepa 3','Laryszw','MLP','75-118','(30) 9669122')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kamila','Maysz','Czereniowa 33','Leajsk','ZCH','97-131','(78) 9714362')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Chwist','Chemska 33','Jawiec','LDZ','48-544','(20) 5843662')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Karolina','Turo','Czerwonego Krzya 24','Piaski','MZW','37-329','(30) 7947921')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Radosaw','Drewniak','Cieszkowskiego 28','Dobropole','PDK','64-887','(70) 7920269')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Janson','Chiska 5','Przychd','LDZ','45-830','(21) 4968499')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Hamak','Cielikowskiego 2','Zapiecek','LBS','91-302','(80) 2106351')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Marszaek','Czogistw 5','Nidowo','OPL','47-463','(80) 9331391')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Monika','Rusin','Chopska 7','Zwierzyn','MLP','97-244','(30) 3341725')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Lewie','Cisowa 8','Zychw','DLN','16-061','(60) 4486327')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Adamiak','Czorsztyska 9','Szydw','LDZ','84-691','(61) 7891238')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Eliasz','Czysta 77','Borowina','LDZ','25-585','(21) 7333560')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Maciejewicz','Chociebuska 5','Paczkw','LBL','43-764','(40) 6510235')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Chwist','Cukiernicza 9','Winowo','SLK','28-203','(21) 6227199')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Egmont','Chocimska 23','Przybyw','ZCH','43-106','(50) 9999212')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Sabina','Kokot','Cukrowa 5','Oarw','PDL','06-188','(40) 8858497')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Stefanik','Chojnowska 23','Koswki','WLP','89-402','(31) 9005264')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Krzysztof','Dawidek','Drzewna 25','Wodziejkowice','PDL','69-530','(60) 9032066')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Dariusz','Dbiec','Dugopolska 22','Stanisaww','KJP','15-420','(90) 7628154')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Adamiak','Drzymay 3','Trzebicz','PMS','96-123','(20) 2905236')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Hamak','Dalimira 35','Malinowice','WRM','80-931','(70) 8749107')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Edelman','Dugosza 35','Strzelce','LBL','36-401','(20) 3511025')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Wierzynek','Dubois 22','Makowice','PMS','95-912','(20) 6755673')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Hager','Daliowa 53','Kopiczew','LDZ','29-300','(61) 4382448')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Kokot','Dutowa 3','Kocielisko','SLK','00-375','(50) 5388246')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Maja','Dawidek','Dubrownicka 8','Limanw','PDK','01-439','(80) 4873116')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Jacek','Dbiec','Dmowskiego 5','Laryszw','MZW','60-213','(31) 8530091')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Kaczmarek','Dunikowskiego 3','Pruszkw','ZCH','46-358','(78) 4052364')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Nawotka','Daniowskiego 87','Nowa Kunia','SLK','63-449','(21) 5660963')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Egmont','Dobra 2','Przesieka','WRM','05-727','(70) 7863366')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Egmont','Darowska 23','Rydzewo','LBS','26-235','(80) 7647675')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Polak','Dobreckiego 3','Bdziew','ZCH','99-367','(31) 8350948')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Lewie','Dusznicka 37','Pruszkw','WLP','43-000','(61) 6795195')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Ryszard','Kaczmarek','Darwina 7','Leajsk','PDL','75-993','(60) 7609091')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Maysz','Dobroszycka 8','Zagaje','MLP','40-115','(60) 8705124')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Jdraszek','Dworska 23','Gajkw','DLN','81-511','(60) 9304315')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Rzeszoto','Dojazd 3','Zaborowo','LDZ','17-440','(41) 5870647')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Robert','Maysz','Dokerska 78','Pisk','WRM','66-796','(70) 6485438')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Eliasz','Dygasiskiego 7','Stoczek','PMS','87-149','(20) 4604300')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Hobica','Dyrekcyjna 8','Czersk','MZW','81-772','(61) 4376406')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cezary','Edelman','Dolnobrzeska 43','Tyniec','ZCH','44-184','(50) 3189149')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Filip','Talko','Dziadoszaski 49','Niebytw','OPL','27-716','(40) 7000184')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Talko','Dogi-Mostowicza 3','Trzebicz','DLN','27-733','(21) 4888217')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Egmont','Dziadowska 7','Zwierzyn','ZCH','64-622','(31) 2335909')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Hobica','Domasawska 58','Niwki','PMS','58-090','(30) 7642267')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marian','Kokot','Dziakowa 35','Sawkw','SLK','95-537','(21) 6675784')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Idzi','Dekarska 23','Szymanw','KJP','58-295','(90) 2162270')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Edelman','Domeyki 37','Igw','SWT','74-707','(20) 7153432')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Chwist','Dembowskiego 8','Paczkw','PDK','94-894','(80) 4131161')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Kaczmarek','Dominikaska 9','Ozimek','SWT','11-441','(51) 2917667')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Wierzynek','Dziarska 9','Ujcie','MLP','97-237','(40) 4424725')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Maciejewicz','Dereniowa 2','Bukowo','PMS','66-539','(31) 3895922')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Katarzyna','Stefanik','Desantowa 2','Bodzanw','LBS','39-648','(50) 2873698')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Szymon','Romanowicz','Doynkowa 78','Nogat','OPL','63-189','(80) 7868779')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Rzeszoto','Dzielnicowa 75','Suchodolec','OPL','95-872','(40) 5482447')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Eryk','Janson','Deszczowa 7','ochw','SWT','59-178','(30) 2541340')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Nawotka','Drabika 27','Dugoka','SLK','00-159','(50) 2829803')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Joanna','Polak','Dzieronia 22','Bulin','PMS','52-315','(30) 9338388')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Rusin','Drobnera 5','Paszczew','LDZ','74-360','(61) 5297893')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Marek','Dbiec','Dzieroniowska 53','Nowogrdek','SLK','15-925','(21) 3900581')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Hajduk','Drogosawicka 5','Kunica','SLK','05-424','(50) 5058079')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Michalina','Reiss','Dziwnowska 50','Gocina','MLP','86-305','(40) 5629122')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Jdraszek','Drnicza 32','Rydzewo','PDL','82-646','(40) 8366336')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Mateusz','Turo','Druckiego-Lubeckiego 20','Nowe Miasto','DLN','49-004','(60) 7481646')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Wojnowicz','Drzewieckiego 20','Stawice','WRM','29-070','(60) 4102659')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Chwist','Ekonomiczna 3','Kamierzw','SLK','95-796','(21) 2416274')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Julia','Wojnowicz','Elsnera 3','Rybaczwka','KJP','86-397','(90) 8112358')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Maciejewicz','Energetyczna 22','Dobropole','WLP','49-254','(50) 5373067')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Aniela','Hager','Czempiska 7','Bobrzec','SLK','79-513','(50) 4469191')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Wojnowicz','Zawiejska 2','Paczkw','SLK','45-491','(80) 4313553')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Kaja','Talko','Pocztowcw 2','Ldziny','SLK','99-647','(21) 7738219')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Justyna','Chwist','Radosawskiego 11','Bodzanw','MLP','53-907','(40) 3326563')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Stefan','Kaczmarek','Kotliska 9','Muszyna','MLP','22-346','(30) 3243741')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Laura','Polak','Zieliskiego 29','Wielkie','MLP','80-478','(60) 5553170')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Hamak','Czarnoleska 33','Przychd','LBL','90-145','(60) 3376412')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Kaczmarek','Czechowa 16','Nidowo','OPL','62-131','(30) 3825073')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Rusin','Chaubiskiego 17','Gocina','DLN','22-215','(51) 8660523')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Bartosz','Hobica','Cicha 28','Wielkie','SWT','51-540','(20) 4690778')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Romanowicz','Czechowicka 11','Zoty Jar','SWT','60-306','(20) 8285106')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Magorzata','Janas','Chaupnicza 62','Wolica','MLP','45-251','(30) 2266991')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Piotr','Turo','Ciechociska 7','Korzonkowo','PMS','97-549','(20) 5664360')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Cecylia','Edelman','Mysowska 5','Biadacz','MZW','24-310','(40) 8593333')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Amelia','Maysz','Czekoladowa 12','Paczyna','MZW','09-732','(61) 2923315')
INSERT INTO tblKlienci (Imie, Nazwisko,Adres,Miasto, Wojewodztwo, KodPocztowy, Telefon) Values ('Grzegorz','Dawidek','Cieplicka 11','Rawa','SWT','19-725','(51) 2618448')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Gumowy kurczak',0.78,2.99,'Bez gumowego kurczaka ani rusz.')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Wesoy brzczyk',2.04,9.99,'Przestrasz swoich przyjaci.')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Butelka na tabletki',3.12,15.24,'Tabletki sprzedawane oddzielnie.')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Mrwcza ferma',3.45,14.99,'Podgldaj ycie mrwek.')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Nakrcany robot',5.94,29.99,'Gigantyczny robot: do ataku!')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Gumowe gaki oczne',0.12,0.99,'Buuuuuuu!')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Psia niespodzianka',0.42,1.99,'Fuj!')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Minikamera',2.09,9.99,'Dla przyszych szpiegw!')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('wiecce robaki',0.4,1.99,'atwo je znale w ciemnym pokoju!')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Strzelajce owady',0.18,0.99,'Oferta specjalna')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Marsjaski budzik',9.59,45.99,'Czy wiesz, ktra tam jest godzina?')
INSERT INTO tblProdukty (NazwaProduktu,  CenaHurtowa, CenaDetaliczna, Opis) Values ('Cynamonowe wykaaczki',0.4,1.99,'Naprawd wiey oddech')
SET IDENTITY_INSERT tblZamowienia ON

INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (109,174.11, '07-Feb-98',255)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (110,100.56, '03-Jan-98',1647)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (117,247.76, '06-Jan-98',214)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (125,15.31, '28-Mar-98',645)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (133,19.29, '03-May-99',142)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (150,225.34, '21-Sep-98',573)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (151,193.36, '12-Apr-98',1759)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (169,185.76, '06-May-98',648)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (174,241.33, '23-Dec-97',864)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (178,39.25, '07-Jul-97',1182)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (192,154.53, '23-Sep-98',194)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (193,79.98, '11-Nov-98',442)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (200,185.78, '23-Sep-98',1644)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (202,30.15, '02-Apr-98',896)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (211,212.52, '24-Oct-98',634)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (224,26.05, '27-Sep-97',978)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (227,242.83, '10-Sep-97',1029)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (248,58.27, '28-Jan-99',755)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (249,247.26, '27-Mar-99',790)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (251,147.86, '21-Aug-98',1942)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (252,159.46, '29-Oct-97',1324)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (256,15.15, '09-Feb-99',883)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (258,60.05, '22-Mar-99',844)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (269,126.69, '03-Sep-98',1058)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (272,211.29, '03-Dec-98',506)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (278,226.24, '27-Jan-98',473)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (281,116.94, '03-Sep-98',1137)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (297,124.9, '13-Mar-98',1801)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (299,123.67, '02-Apr-99',702)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (300,239.21, '14-Jun-97',988)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (312,239.06, '08-Dec-97',243)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (316,127.79, '03-Aug-98',1061)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (322,138.58, '10-Sep-98',1307)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (331,69.67, '26-Apr-99',730)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (338,172.78, '08-Sep-98',1108)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (348,195.46, '30-Sep-98',1487)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (349,154.86, '28-Jun-98',134)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (358,183.08, '13-Feb-98',535)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (373,119.11, '26-May-98',819)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (374,14.96, '26-Feb-98',1482)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (389,176.22, '15-Aug-97',981)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (406,117.45, '20-Jan-99',1310)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (446,13.24, '17-Nov-97',1208)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (461,9.7, '08-Mar-98',956)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (464,110.36, '22-Jul-98',1345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (466,168.73, '19-Jan-98',978)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (473,198.56, '26-Apr-98',697)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (476,23.43, '22-Nov-97',1899)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (482,8.27, '24-Nov-97',1145)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (492,189.68, '14-Aug-97',493)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (495,198.58, '05-Jun-98',988)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (497,155.54, '31-Aug-97',907)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (515,70.05, '11-Feb-98',1735)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (522,122.31, '24-May-98',1246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (523,146.86, '22-Dec-97',254)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (524,125.92, '17-Jun-97',1710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (533,12.4, '16-Feb-99',1227)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (535,102.68, '01-Aug-97',836)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (546,177.69, '16-Oct-97',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (549,91.25, '17-Apr-98',1535)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (554,178.87, '01-Jun-98',759)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (563,11.8, '26-Feb-99',1924)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (567,42.25, '01-Sep-98',827)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (570,12.97, '12-Apr-99',889)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (571,54.49, '06-Feb-98',230)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (581,226.23, '11-May-99',322)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (586,133.63, '15-Jan-98',1269)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (594,55.99, '15-Jan-99',1786)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (608,201.67, '03-May-99',1834)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (617,210.88, '08-Mar-98',1283)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (619,194.34, '12-Aug-97',1744)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (622,208.89, '20-Feb-99',1949)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (633,123.97, '16-Dec-97',1317)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (639,73.91, '29-Mar-99',1081)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (649,148.72, '07-Feb-98',428)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (654,63.36, '11-Sep-98',122)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (656,13.39, '05-Nov-98',542)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (667,1.18, '04-Jan-98',1046)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (669,62.97, '14-Apr-98',100)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (671,221.98, '07-Jun-98',794)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (675,50.06, '10-Feb-99',220)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (678,66.74, '24-Feb-98',1163)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (683,238.51, '02-Jan-98',1155)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (685,231.25, '19-Mar-98',1002)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (690,164.37, '07-Aug-98',1601)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (700,114.67, '08-Sep-98',658)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (702,211.67, '22-Sep-98',656)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (707,29.66, '02-Feb-99',468)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (716,162.33, '25-May-99',1801)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (748,238.9, '13-Mar-98',615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (757,231.98, '28-Feb-99',1258)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (773,92.45, '30-Mar-98',1772)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (774,51.11, '15-Jan-99',151)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (792,100.37, '19-Sep-97',596)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (796,238.62, '17-May-99',1407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (804,72.11, '24-Feb-98',292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (809,34.6, '07-Nov-97',784)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (818,235.43, '07-Jun-98',300)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (852,6.1, '01-Jul-98',652)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (856,49.93, '14-Jul-98',202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (875,83.48, '14-Aug-98',796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (878,231.43, '14-Jun-98',225)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (897,63.4, '08-Jul-97',597)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (906,154.64, '15-May-98',1150)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (908,203.7, '25-Dec-97',252)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (912,1.34, '01-Aug-97',254)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (916,93.01, '11-Dec-98',1180)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (925,22.27, '07-Jun-98',1291)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (939,18.97, '20-Aug-98',1145)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (940,113.26, '23-Nov-97',1292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (944,219.71, '04-Jan-99',9)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (951,196.61, '26-Apr-99',1545)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (956,58.16, '18-Jul-97',77)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (960,184.61, '07-Feb-98',1438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (962,31.39, '30-Sep-97',73)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (967,172.83, '06-Mar-99',742)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (973,77.51, '03-Jun-99',994)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (993,166.47, '03-Nov-97',1622)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1019,201.65, '14-Aug-98',1677)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1021,152.51, '09-May-98',829)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1041,178, '10-Feb-98',1864)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1054,160.27, '01-Oct-97',863)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1057,8.57, '09-Feb-99',1349)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1073,232.44, '20-Sep-97',1786)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1074,47.49, '21-Dec-98',509)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1082,172.67, '07-Apr-98',1543)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1083,184.55, '05-Mar-99',678)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1087,169.69, '23-Jul-98',521)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1104,80.26, '29-May-99',624)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1115,204.66, '15-Jan-99',1204)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1117,111.81, '22-Jan-98',895)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1121,135.25, '12-Apr-98',1310)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1132,242.57, '01-Apr-98',329)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1139,228.51, '03-Mar-99',407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1143,61.35, '16-Nov-97',1317)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1152,202.26, '02-Feb-98',1397)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1162,129.76, '22-Feb-99',774)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1163,146.89, '30-Jan-99',1400)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1166,61, '13-Jun-97',1362)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1167,188.58, '22-Feb-99',793)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1171,194.28, '08-Mar-99',567)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1185,47.51, '11-May-99',1505)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1207,2.75, '16-Nov-97',1710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1210,1.63, '28-Jan-98',300)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1213,150.15, '22-Jul-97',1488)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1243,61.79, '11-Oct-97',145)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1249,244.35, '05-May-98',1934)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1255,1.54, '05-Aug-98',1456)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1266,182.23, '23-Aug-97',1253)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1281,75.48, '20-Jul-98',362)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1286,14.17, '20-Nov-97',1156)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1294,163.69, '15-Mar-99',265)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1310,70.17, '13-Jan-98',1717)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1318,157.18, '05-Sep-98',1248)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1323,242.49, '06-Oct-97',662)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1348,52.44, '17-Apr-99',1386)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1371,58.23, '20-Feb-98',22)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1372,3.02, '05-Jun-97',1036)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1391,192.5, '03-Dec-98',220)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1393,200.84, '10-Jan-98',477)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1414,106.97, '30-Aug-97',1)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1420,193.45, '05-Oct-98',1433)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1422,154.7, '30-Jul-98',106)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1433,107.71, '19-Nov-97',139)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1444,42.99, '02-May-98',1241)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1450,156.47, '15-Apr-99',1552)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1453,154.62, '16-Nov-97',1528)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1466,82.48, '27-Jul-98',627)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1474,226.67, '23-Aug-98',961)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1475,26.13, '22-Jul-98',1492)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1484,100.52, '07-Sep-97',760)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1485,146.31, '27-Aug-98',1032)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1495,222.78, '02-Aug-97',1692)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1499,196.98, '15-Feb-98',838)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1504,32.04, '07-Aug-98',1645)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1507,193.48, '12-Sep-98',1330)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1517,147.9, '29-May-99',595)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1526,234.48, '04-Jun-98',345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1529,89.23, '13-Jul-98',359)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1531,50.09, '09-Jun-98',251)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1549,156.39, '19-Feb-98',217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1550,37.02, '30-Jul-97',885)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1572,58.71, '23-Aug-97',1243)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1578,108.95, '08-Oct-98',1129)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1582,37.74, '30-Jan-98',1695)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1591,16.8, '25-Nov-98',1490)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1592,118.56, '20-Jun-98',1731)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1595,64.62, '30-Mar-98',1127)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1599,66.54, '31-Jul-97',1087)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1608,54.33, '23-Apr-99',1288)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1616,87.79, '19-Feb-98',1922)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1634,241.63, '17-Feb-98',96)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1637,216.2, '21-Apr-98',650)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1638,114.96, '06-Mar-99',704)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1653,166.6, '24-Oct-97',95)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1658,230.06, '17-Mar-99',1458)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1661,40.89, '02-Oct-97',1229)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1666,67.94, '06-Jun-97',1412)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1668,92.73, '27-Jul-98',1391)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1669,149.6, '27-Jul-98',1429)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1670,213.5, '01-Feb-98',504)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1672,29.58, '19-Jan-98',1070)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1686,14.76, '15-Mar-98',1245)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1696,102.06, '11-Jun-98',1956)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1705,228.12, '24-Oct-97',1350)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1706,201.74, '15-Nov-97',1644)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1712,144.04, '01-Sep-98',554)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1716,31.67, '27-Nov-98',1780)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1742,218.2, '15-Feb-98',1936)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1752,209.36, '01-Aug-97',540)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1753,1.99, '20-Jan-99',1672)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1754,196.15, '23-Feb-99',321)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1770,19.38, '13-Jan-98',378)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1774,240.67, '29-Mar-99',1222)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1776,105.46, '12-Jun-97',248)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1789,40.3, '09-Feb-98',1121)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1794,116.26, '28-Aug-98',1634)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1801,153.32, '12-Aug-98',1189)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1809,165.58, '08-Apr-98',1160)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1825,102.89, '25-Dec-98',1348)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1826,65.1, '19-Dec-98',429)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1856,160.24, '25-Aug-97',546)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1862,131.85, '02-Sep-98',1466)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1872,184.44, '03-Apr-99',696)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1874,158.83, '23-Apr-98',1428)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1878,67.47, '03-Feb-99',1447)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1879,60.94, '30-Jan-99',300)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1888,176.03, '11-Dec-98',627)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1902,196.09, '17-Sep-98',829)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1905,176.75, '03-Nov-98',1570)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1915,38.45, '12-Nov-98',1525)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1917,180.02, '02-Feb-98',1951)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1933,207.99, '23-Jan-99',246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1941,46.46, '07-Apr-98',1977)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1948,53, '22-May-99',900)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1965,81.11, '26-Jun-97',629)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1969,206.59, '08-Apr-98',886)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1970,196.04, '20-Jan-98',774)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1986,172.95, '15-Jul-97',1849)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (1997,214.12, '20-Nov-97',1071)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2010,96.15, '14-Jun-97',1117)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2024,27.34, '12-Oct-98',776)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2029,105.02, '07-Apr-98',1571)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2030,44.83, '21-Oct-97',1373)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2033,22.01, '08-Aug-97',437)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2038,127.39, '16-Jun-97',882)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2044,189.79, '15-Sep-98',67)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2046,200.31, '22-Apr-99',1156)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2053,34.21, '09-Dec-97',345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2055,101.64, '16-Jan-98',216)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2056,55.99, '17-Jan-98',930)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2060,32.92, '18-Apr-99',1503)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2066,205.62, '20-Mar-99',1585)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2077,53.56, '16-Jul-97',557)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2092,195.43, '11-Nov-97',903)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2094,114.44, '17-Dec-97',122)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2097,122.01, '06-Nov-98',222)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2107,194.69, '25-Apr-99',1576)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2111,214.4, '09-Aug-98',1653)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2131,211.62, '16-Jun-97',734)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2143,204.37, '22-Mar-98',311)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2151,184.19, '03-Apr-99',278)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2154,227.6, '17-Jul-97',1454)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2156,190.44, '22-Jul-98',816)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2161,8.58, '29-Dec-97',241)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2168,95.41, '15-Aug-98',1112)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2188,21.95, '04-Sep-98',1329)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2201,179.28, '24-Feb-99',1662)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2212,247.97, '30-Jul-98',317)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2213,234.81, '07-Jul-98',1133)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2225,179.73, '19-Jan-99',495)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2229,13.27, '25-Oct-97',1105)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2232,206.04, '01-Sep-97',131)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2233,21.28, '29-Aug-98',1833)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2235,15.24, '22-Feb-98',281)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2237,145.45, '27-May-98',628)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2238,214.5, '20-Apr-98',1093)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2268,123.91, '02-Aug-98',1111)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2287,77.72, '15-Jan-99',390)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2289,135.46, '04-Jan-98',983)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2291,82.93, '31-May-99',1826)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2292,133.02, '25-May-99',326)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2303,130.51, '10-Sep-97',107)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2312,25.15, '31-Oct-98',524)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2330,232.79, '23-Jun-97',1760)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2337,227.02, '25-Sep-98',97)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2344,240.54, '06-Apr-98',269)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2347,111.32, '13-Apr-98',621)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2353,126.77, '17-Nov-98',1706)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2362,42.29, '27-Jun-97',1302)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2367,6.7, '13-Nov-97',61)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2368,97.63, '26-Jul-98',1375)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2371,213.73, '15-Mar-99',344)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2391,63.53, '27-Oct-97',1568)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2392,113.03, '10-Dec-97',1050)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2394,2, '06-Feb-99',1841)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2396,60.58, '08-Feb-98',586)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2406,223.09, '05-Jan-99',806)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2419,74.42, '15-Jun-98',5)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2425,195.79, '22-Sep-98',338)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2428,246.82, '13-Aug-98',132)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2434,220.54, '24-Feb-99',1806)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2435,17.79, '26-Nov-98',1484)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2441,216.59, '19-Mar-98',1090)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2449,23.32, '02-Oct-97',1354)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2453,118.21, '26-Feb-98',375)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2464,171.66, '20-May-98',1794)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2470,180.07, '21-Oct-98',463)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2478,85.5, '07-Jun-97',1286)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2484,92.38, '14-Nov-98',1560)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2491,80.27, '05-Sep-98',506)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2492,35.31, '11-Mar-99',339)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2496,183.5, '11-May-98',176)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2507,177.28, '20-May-98',1347)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2509,32.92, '14-Feb-99',1109)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2511,15.42, '29-Apr-98',1047)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2520,116.91, '16-Apr-99',964)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2524,138.55, '04-Apr-99',998)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2527,209.53, '09-Apr-99',32)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2537,185.27, '24-Nov-98',1222)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2540,85.42, '25-Mar-98',1467)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2550,20.3, '29-Jun-98',1418)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2559,94.75, '30-Oct-97',1328)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2561,4.39, '11-Aug-97',517)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2566,16.21, '04-Oct-98',1794)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2585,239.78, '20-Sep-98',79)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2594,147.55, '14-Nov-98',355)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2602,39.04, '13-Feb-99',1499)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2617,186.52, '12-Dec-97',953)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2621,214.85, '13-Apr-99',774)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2626,206.07, '21-Mar-98',1553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2646,71.87, '17-Mar-99',845)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2648,10.09, '06-Apr-98',1816)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2655,242.54, '14-Nov-98',1814)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2659,248.48, '27-Sep-97',757)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2664,20.96, '26-Nov-98',1871)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2672,200.66, '03-Jan-98',1816)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2676,54.69, '01-Jan-99',1153)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2678,95.3, '25-Apr-98',146)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2679,116.56, '23-Dec-97',437)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2721,234.14, '09-Feb-99',1503)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2731,226.16, '14-Jan-99',1075)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2744,108.84, '06-Sep-98',726)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2752,26.19, '26-Oct-98',591)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2754,184.24, '18-Aug-97',1307)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2779,60.68, '13-May-99',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2792,40.62, '15-Mar-98',1903)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2795,56.9, '03-May-99',721)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2796,134.64, '22-Oct-98',1589)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2797,138.08, '22-Apr-98',1160)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2803,145.79, '30-Apr-99',166)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2830,95.38, '18-Dec-98',234)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2834,182.33, '27-May-99',808)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2837,86.81, '20-Aug-98',1517)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2838,19.85, '18-May-98',343)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2865,71.05, '10-Jun-98',924)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2866,236.91, '05-Oct-98',1977)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2877,213.67, '28-Dec-97',558)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2882,54.71, '01-Sep-98',1997)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2883,128.38, '06-Mar-98',1027)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2890,78.6, '22-Nov-97',695)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2901,246.1, '22-May-98',27)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2926,162.76, '20-Dec-98',1433)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2932,121.7, '12-Jul-97',1392)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2934,166.26, '31-Oct-98',414)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2937,207.28, '11-Jun-97',1666)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2946,135.19, '17-Oct-98',819)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2970,77.18, '29-Dec-97',1873)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2974,192.49, '25-Apr-99',1176)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2981,104.81, '27-Apr-98',1308)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2987,6.61, '31-Aug-97',1065)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2992,185.61, '07-Jun-97',1456)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2994,197.28, '21-Mar-98',1613)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2996,195.77, '05-Sep-98',163)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (2997,239, '05-May-99',1983)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3012,120, '01-Apr-98',1650)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3021,100.73, '11-May-98',1148)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3022,136.25, '20-Nov-97',347)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3026,124.39, '03-Aug-98',262)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3031,168.3, '25-Apr-99',1748)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3045,92.15, '10-Nov-97',346)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3047,7.16, '15-Jul-97',38)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3050,135.05, '08-Aug-98',1778)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3051,226.67, '03-Aug-97',1648)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3061,236.23, '09-Nov-98',1079)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3062,163.21, '12-Jul-97',1955)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3065,61.43, '09-Mar-98',591)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3071,211.98, '08-Aug-97',18)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3072,90.19, '12-Jan-98',758)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3091,13.54, '22-Aug-97',1136)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3100,8.69, '11-Jan-99',1331)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3112,113.52, '23-Jan-98',458)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3125,18.05, '13-Apr-98',410)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3126,58.92, '26-Jun-97',1202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3144,157.96, '14-Apr-99',730)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3147,76.53, '04-Jun-98',150)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3159,161.79, '07-Sep-97',1597)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3166,79.2, '23-Dec-97',1934)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3170,188.14, '11-Mar-99',1823)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3180,138.31, '10-Nov-98',1303)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3183,102.26, '14-Oct-98',1497)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3186,121.55, '14-Jun-97',950)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3193,57.9, '22-Jul-98',454)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3195,221.31, '01-Dec-97',1709)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3197,65.46, '10-Apr-99',1813)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3209,183.43, '05-Oct-97',1910)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3213,19.32, '09-Oct-97',1279)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3216,205.2, '01-Oct-98',1409)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3222,52.17, '07-Sep-97',1917)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3229,224.16, '09-Apr-98',761)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3230,70.76, '07-May-98',155)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3244,168.91, '15-Jun-97',1451)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3256,10.65, '10-Sep-97',1321)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3263,84.61, '21-Jun-97',1520)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3267,41.64, '22-Jun-97',133)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3274,40.77, '21-Jan-98',130)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3283,248.83, '19-Jul-98',44)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3290,37.93, '27-Jun-98',1345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3316,152.05, '06-Jul-97',1282)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3320,156.85, '25-Aug-98',575)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3321,192.68, '19-Jul-98',1255)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3322,80.64, '18-Jul-98',770)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3339,43.03, '16-Sep-98',612)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3343,160.83, '29-Jul-98',502)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3354,22.56, '15-Mar-98',1192)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3355,186.49, '15-Apr-98',1761)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3371,230.14, '19-Oct-98',581)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3373,234.75, '23-Dec-98',500)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3374,24.58, '30-May-98',1815)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3377,17.34, '01-Jan-98',142)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3381,250.08, '15-Jan-99',78)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3387,237.23, '28-Sep-98',822)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3391,51.42, '30-Nov-97',1192)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3395,43.02, '26-Feb-99',1710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3400,18.44, '10-Sep-97',1262)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3402,59.46, '11-Sep-98',1817)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3410,143.87, '05-Dec-97',1749)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3420,117.14, '15-Oct-98',136)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3432,1.62, '29-Jan-99',1123)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3433,169.31, '03-Jun-99',381)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3434,62.64, '10-Nov-98',979)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3445,208.79, '29-Dec-97',581)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3451,146.03, '29-Oct-98',995)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3452,85.01, '19-Jul-98',1557)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3466,215.04, '16-Aug-98',1137)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3493,246.73, '09-Jan-98',174)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3509,201.07, '09-Nov-98',1318)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3519,158.54, '25-Dec-97',1802)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3526,152.37, '20-Jul-97',1921)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3533,169.54, '04-Aug-97',1186)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3536,28.09, '09-Dec-97',1634)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3557,16.69, '25-Oct-98',1087)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3588,226.71, '11-Jul-98',723)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3596,188.91, '16-Feb-99',1296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3601,75.34, '20-Oct-98',767)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3622,93.26, '23-Jul-98',615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3625,133.35, '18-Sep-98',820)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3626,219.12, '21-Jun-97',1869)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3646,173.97, '22-Aug-98',1338)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3648,33.46, '11-Aug-97',1574)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3659,26.75, '22-Apr-99',1068)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3660,165.14, '12-Nov-97',1092)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3663,154.42, '22-Feb-99',1031)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3669,151.68, '05-Feb-98',437)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3674,161.15, '19-Nov-98',194)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3676,163.4, '15-Sep-98',1898)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3686,155.97, '25-Jan-98',975)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3690,217.6, '27-Oct-97',134)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3711,145.8, '19-Nov-98',726)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3723,53.13, '29-Sep-97',362)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3727,183.77, '29-Jul-97',340)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3733,17.49, '19-Aug-98',1994)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3735,57.37, '24-Mar-99',1267)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3737,11.17, '08-Mar-99',957)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3740,44.79, '13-Sep-97',1049)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3744,37.33, '13-Aug-97',1524)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3758,214.02, '19-Aug-98',1104)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3760,110.95, '03-Feb-99',1997)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3761,77.83, '28-Mar-98',1900)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3768,161.45, '15-Sep-98',1916)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3772,67.98, '23-Dec-97',1182)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3774,218.34, '15-Nov-97',1531)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3777,250.3, '27-Dec-98',2000)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3784,115, '01-Jul-97',1591)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3796,212.48, '06-Jun-98',1290)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3807,116.7, '23-May-98',41)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3809,213.85, '04-Nov-98',1306)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3811,193.79, '28-May-98',1122)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3830,96.44, '31-Oct-97',885)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3838,11.27, '06-Feb-98',104)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3848,160.41, '21-Jan-98',1841)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3871,6.73, '11-Nov-97',1752)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3874,35.96, '16-Jan-98',232)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3896,238.43, '09-Jul-98',659)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3900,219.07, '05-Aug-97',422)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3908,231.42, '24-Nov-97',494)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3928,178.13, '10-May-99',1897)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3938,130.28, '20-Jun-97',811)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3943,221.43, '11-Jun-97',735)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3945,110.64, '29-Apr-98',1240)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3959,6.94, '23-Feb-99',328)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3972,200.75, '28-Dec-97',1901)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3973,189.44, '04-Mar-98',1485)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (3990,165.25, '05-Mar-98',378)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4014,127.87, '27-Jul-97',317)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4019,157.01, '30-Apr-98',89)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4021,164.14, '16-May-98',653)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4024,206.73, '17-Dec-97',339)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4026,72.72, '05-Jan-99',146)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4028,11.47, '01-Nov-98',600)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4044,204.39, '28-Oct-97',1040)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4045,237.34, '29-Oct-98',1225)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4051,101.03, '24-Sep-97',1772)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4069,190.23, '07-Oct-97',1829)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4073,197.01, '12-Feb-99',48)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4083,23.33, '11-Nov-97',1639)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4090,180.88, '27-May-98',813)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4097,82.33, '27-Dec-98',1453)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4098,44.44, '23-Jul-98',942)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4099,131.7, '15-Mar-99',891)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4116,85.77, '26-Feb-98',183)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4117,204.46, '11-Nov-97',1261)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4131,206.15, '03-Dec-98',1783)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4152,64.33, '10-Jan-99',957)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4156,194.18, '13-Sep-97',1716)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4162,230.65, '27-May-98',468)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4163,9.87, '16-May-99',859)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4164,192.69, '16-Sep-98',30)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4167,180.89, '04-Sep-98',1524)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4170,124.11, '25-Aug-98',1626)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4171,226.98, '10-Mar-98',1985)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4178,230.27, '28-Jun-98',34)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4180,27.42, '26-Apr-98',1414)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4186,212.17, '30-Jun-97',1785)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4188,192.68, '17-Jan-98',1673)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4190,154.55, '12-Aug-98',1601)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4204,86.19, '02-Mar-99',1790)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4222,75.23, '29-Dec-97',213)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4230,217.58, '28-Oct-97',1780)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4257,172.77, '10-Nov-98',1501)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4292,134.3, '20-Jul-97',1204)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4300,184.45, '03-Aug-98',693)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4315,59.57, '13-Dec-98',961)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4316,238.04, '11-Dec-97',210)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4320,146.61, '01-Feb-98',114)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4325,246.38, '30-Dec-98',325)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4328,3.94, '21-Jul-98',407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4329,42.67, '26-Jul-97',478)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4336,157.96, '22-Sep-97',176)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4338,122.7, '21-Aug-97',18)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4343,90.15, '26-Dec-97',576)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4349,61.17, '21-Jun-98',845)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4365,172.13, '21-Jul-98',1366)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4366,28.06, '22-Sep-98',203)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4373,116.34, '22-Oct-98',460)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4378,62.33, '06-Dec-98',624)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4379,166, '07-Mar-99',783)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4381,36.07, '17-Aug-98',1902)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4392,66.13, '23-Jan-99',774)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4395,99.96, '25-Apr-99',541)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4411,247.37, '18-Nov-98',1719)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4414,229, '05-Jun-98',1557)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4422,103.3, '28-Feb-99',868)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4430,38.39, '16-Sep-97',1881)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4435,176.35, '06-Apr-99',292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4436,24.27, '13-Jan-99',1185)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4451,223.46, '04-Feb-98',804)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4454,14.1, '26-Nov-97',1077)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4461,74.12, '30-May-98',1051)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4472,106.59, '20-Apr-98',977)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4503,14.32, '18-Jun-97',357)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4504,173.77, '17-Jun-97',1395)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4508,227.02, '04-May-99',1649)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4512,107.94, '22-Jul-97',1362)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4524,25.69, '18-Sep-98',1122)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4529,245.25, '01-Aug-98',727)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4535,169.31, '22-Aug-98',115)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4545,24.46, '19-Jan-99',1530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4550,16.25, '30-Sep-98',181)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4557,55.15, '22-Jan-98',1263)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4567,114.82, '15-Jan-99',1805)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4571,194.76, '20-Apr-99',1654)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4572,2.68, '13-Aug-98',98)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4578,199.98, '21-Jan-98',750)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4583,164.15, '13-Sep-98',1501)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4591,64.19, '11-Feb-98',1764)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4592,106.38, '26-Nov-97',1294)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4601,34.64, '04-Nov-97',824)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4616,71.91, '02-Jun-98',624)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4622,152.38, '07-Feb-99',823)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4628,109.1, '03-Nov-98',1598)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4641,7.96, '11-May-98',94)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4642,118.41, '12-Dec-97',157)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4652,159.98, '17-May-98',245)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4668,82.14, '02-Jun-99',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4678,70.52, '16-Dec-97',433)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4680,11.59, '04-Apr-99',171)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4700,221.96, '22-May-99',1447)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4701,19.29, '21-Nov-98',695)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4704,71.22, '06-Sep-97',970)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4711,175.43, '11-Jan-99',1466)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4715,169.63, '04-Sep-97',1583)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4730,131, '21-Aug-98',1630)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4753,18.68, '21-Jun-97',1117)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4762,147.03, '07-Oct-98',880)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4774,147.77, '07-Dec-97',1705)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4779,214.8, '26-Jan-98',994)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4780,184.59, '30-Aug-97',306)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4790,101.19, '23-Dec-98',133)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4794,63.27, '30-Jun-98',1126)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4804,57.85, '05-Mar-99',276)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4806,13.1, '18-Oct-98',1622)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4811,15.54, '08-Nov-97',1726)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4815,182.73, '02-Aug-97',1953)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4820,199.89, '20-Apr-99',371)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4854,132.26, '26-Nov-97',1958)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4863,86.17, '24-Jul-97',1061)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4865,215.18, '05-Jun-99',45)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4867,238.85, '16-Jan-99',978)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4869,106.27, '15-Nov-98',204)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4895,19.82, '29-Aug-98',1009)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4900,83.97, '13-Feb-98',365)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4908,99.51, '30-Jul-98',1305)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4909,79.48, '21-Apr-98',1553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4917,200.55, '01-Feb-98',1834)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4926,197.75, '12-Feb-98',453)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4939,245.19, '07-Apr-98',1486)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4943,167.33, '25-Dec-97',1743)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4947,161.15, '18-Jan-98',1444)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4949,160.64, '14-Dec-98',1119)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4957,88.27, '01-Jun-99',949)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4971,59.77, '06-Sep-98',635)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4987,4.61, '15-Oct-98',466)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (4992,119.43, '07-Aug-97',1056)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5006,18.7, '09-Nov-98',1284)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5017,173.29, '17-Apr-98',994)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5018,157.72, '12-Jun-97',738)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5035,244.26, '13-Sep-98',984)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5046,63.46, '13-Feb-99',1338)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5048,10.33, '26-Dec-97',1529)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5069,124.95, '19-Apr-99',1302)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5080,203.99, '22-Jun-97',1127)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5086,40.26, '23-Sep-97',1778)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5106,201.19, '20-Nov-98',1585)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5129,123.24, '26-Jul-98',1614)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5130,43.88, '09-May-99',1973)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5132,94.91, '17-Dec-98',1089)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5142,201.97, '06-Aug-97',1351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5145,62.02, '10-Dec-98',154)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5147,180.25, '06-Aug-98',1925)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5155,5.81, '16-Aug-97',1274)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5160,188.11, '10-Nov-98',964)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5212,249.25, '23-Sep-98',1222)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5214,229.9, '31-Mar-99',1267)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5219,151.77, '30-Sep-97',1360)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5224,146.57, '25-Aug-97',628)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5225,57.34, '06-May-99',1512)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5246,181.2, '17-Nov-97',1755)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5273,93.07, '20-Mar-99',252)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5275,216.22, '09-Jul-97',396)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5279,95.13, '09-Jul-97',1199)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5287,150.06, '10-May-98',1663)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5293,205.19, '12-Sep-97',410)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5299,144.23, '28-Mar-99',624)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5310,221.18, '13-Jun-97',1968)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5312,148.85, '28-Nov-98',988)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5317,24.68, '01-May-98',1791)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5318,196.54, '24-May-98',752)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5319,98.53, '30-Jan-98',43)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5330,227.47, '07-Jan-98',743)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5341,122.09, '21-May-98',861)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5342,59.85, '22-May-98',1694)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5343,168.96, '01-Nov-97',801)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5346,172.74, '02-Aug-97',1613)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5349,93.46, '26-Nov-98',1808)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5351,87.52, '13-Jan-99',357)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5361,119.41, '20-Nov-97',42)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5372,227.89, '24-Jun-98',947)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5388,214.29, '08-May-99',1680)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5394,168.62, '10-Mar-99',1967)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5396,240.97, '13-Aug-98',1846)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5398,62.46, '05-Sep-98',213)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5400,13.04, '13-Sep-98',1265)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5401,13.42, '11-Feb-99',1287)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5402,101.11, '28-Aug-97',57)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5406,120.57, '26-Jul-98',384)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5414,238.21, '18-Jun-98',1790)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5419,218.78, '30-Oct-97',500)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5454,222.43, '20-Sep-98',611)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5487,58.1, '11-Aug-98',996)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5490,14.16, '12-Jun-97',24)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5492,230.52, '29-Apr-98',32)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5501,197.19, '19-Apr-99',814)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5507,194.41, '06-Apr-98',1832)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5508,1.01, '07-Feb-98',991)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5511,129.26, '13-Mar-98',929)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5515,81.48, '17-Dec-97',760)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5519,23.38, '17-Aug-97',1149)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5522,94.42, '27-Sep-98',1369)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5528,195.75, '27-Mar-98',710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5531,211.1, '30-Mar-98',152)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5535,98.9, '22-Mar-98',1013)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5540,53.86, '21-Apr-98',1314)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5545,178.9, '28-Mar-99',1228)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5564,238.62, '25-Jun-98',862)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5577,95, '19-Jul-98',1897)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5581,192.76, '13-Jul-98',1340)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5587,244.19, '07-Aug-97',1477)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5594,17.48, '31-Mar-98',1005)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5599,62.04, '28-Feb-98',1552)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5600,152.59, '11-Dec-98',781)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5610,55.14, '26-Mar-99',828)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5639,34.81, '21-Oct-98',192)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5645,202.84, '05-Jan-98',525)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5650,161.53, '30-Nov-97',1708)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5656,18.78, '25-May-99',1093)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5659,169.01, '15-Jan-98',1436)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5668,69.57, '13-Aug-97',1316)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5682,113.32, '19-Mar-98',533)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5685,145.66, '12-May-98',837)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5700,25.58, '26-Jan-98',995)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5715,233.73, '25-Dec-97',1296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5717,65.22, '30-Aug-98',1528)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5719,50.25, '26-May-98',441)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5721,56.93, '21-Mar-99',476)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5724,28.53, '25-Jan-98',997)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5734,195.98, '17-Dec-98',1246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5744,87.77, '21-Feb-98',231)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5745,218.43, '07-Sep-98',393)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5767,80.67, '14-Jan-99',392)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5789,136.34, '03-Apr-98',1422)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5790,39.26, '07-Mar-98',1197)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5792,222.61, '16-Oct-98',1092)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5793,109.4, '11-Aug-98',1499)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5797,106.72, '09-Jun-97',699)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5815,200.01, '07-Jun-97',943)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5817,196.55, '10-Jun-97',1750)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5825,62.06, '27-Jun-98',747)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5834,132.8, '24-Jul-97',1992)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5851,57.46, '15-Jul-98',1370)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5866,241.72, '11-Jun-97',1858)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5895,16.84, '22-Nov-98',1530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5897,58.46, '12-Nov-98',559)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5902,211.74, '28-Jun-98',172)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5904,71.84, '18-Mar-98',1662)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5917,170.33, '08-Jul-98',1548)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5919,33.9, '16-Jun-97',265)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5922,5.82, '15-Feb-99',34)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (5934,32.62, '21-Oct-98',1450)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6017,31.04, '08-Oct-97',1216)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6026,25.44, '17-Nov-98',1124)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6029,4.44, '09-Dec-98',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6032,136.97, '24-May-99',1986)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6033,92.86, '26-Oct-98',569)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6051,118.3, '20-Oct-97',1298)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6055,213.74, '24-Apr-98',1457)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6067,36.96, '26-Dec-98',946)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6078,66.47, '26-Dec-97',312)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6079,82.57, '08-Aug-98',881)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6087,122.68, '23-Jun-97',1244)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6088,20.45, '17-Jun-97',753)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6093,10.57, '06-Oct-97',1379)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6103,60.34, '08-Oct-98',1862)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6105,217.22, '07-Nov-97',1237)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6113,103.48, '04-Nov-98',366)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6120,179.52, '17-May-98',1786)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6137,6.85, '02-Jul-97',1056)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6141,194.26, '27-Jan-99',276)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6150,134.17, '10-Sep-97',1331)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6154,192.34, '15-Jun-98',467)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6167,164.8, '01-Jan-99',1669)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6171,158.76, '27-Jun-97',947)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6179,54.48, '01-May-98',765)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6181,96.06, '12-Jul-98',318)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6196,2.74, '17-Jan-99',1275)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6198,103.13, '14-Mar-99',671)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6214,178.09, '03-Apr-99',1574)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6222,204.08, '23-Mar-98',1532)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6232,119.16, '22-Mar-99',1294)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6235,159.46, '30-Dec-97',65)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6236,57.81, '30-May-99',772)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6238,54.25, '17-Nov-97',934)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6260,181.55, '29-Nov-97',748)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6262,33.42, '24-Jan-99',152)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6267,188.46, '03-Nov-97',650)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6273,148.45, '31-Oct-98',122)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6274,173.3, '27-Mar-99',29)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6280,121.1, '23-Mar-99',1269)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6282,250.55, '27-Aug-97',748)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6291,109.55, '29-Jul-97',834)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6293,3.78, '01-Feb-99',1483)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6307,130.97, '24-Jun-98',1170)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6308,8.83, '19-Jul-98',390)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6338,179.67, '23-Nov-98',23)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6341,90.14, '27-Dec-98',1399)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6347,53.96, '02-Jan-98',728)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6351,23.52, '05-Aug-97',1307)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6358,80.04, '13-Feb-99',1219)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6361,27.3, '25-May-98',1432)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6365,149.01, '25-Jun-98',1875)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6369,181.36, '06-May-99',678)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6378,50.64, '16-May-99',167)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6381,225.4, '28-Apr-99',492)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6383,193.33, '24-Sep-98',1166)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6392,4.42, '21-Mar-98',396)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6393,137.09, '10-Nov-97',1720)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6398,90.46, '23-Apr-98',208)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6404,7.28, '26-Jul-97',304)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6407,168.65, '28-Jul-98',455)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6410,198.08, '24-Jun-98',1966)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6417,157.3, '15-Sep-97',686)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6428,85.33, '13-May-99',805)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6440,142.73, '09-Nov-97',1279)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6443,87.61, '07-May-98',460)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6450,51.5, '01-Nov-97',1162)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6461,11.47, '12-Jun-98',1296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6472,226.7, '22-Aug-97',145)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6496,124.28, '31-Oct-97',1529)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6502,54.11, '18-Oct-98',1348)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6512,153.42, '05-Jun-99',1709)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6515,81.34, '07-Oct-97',1719)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6517,47.47, '03-Aug-97',343)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6537,122.73, '19-Jun-98',460)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6546,64.03, '26-Aug-97',333)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6552,218.74, '04-Jan-99',25)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6557,203.97, '15-Mar-98',1245)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6560,42.22, '24-Sep-98',930)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6566,11.09, '03-Aug-98',1005)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6583,118.42, '09-Feb-99',1440)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6585,167.34, '24-Aug-97',929)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6593,86.21, '20-Jul-98',278)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6595,50.09, '28-Apr-99',822)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6600,242.41, '14-Apr-98',1817)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6604,59.26, '17-Dec-97',1320)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6605,78.37, '31-Dec-98',1417)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6608,197.82, '29-Apr-99',1923)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6638,201.56, '19-Jun-97',342)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6642,46.93, '19-Nov-98',968)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6643,214.15, '08-Jun-98',835)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6651,35.51, '23-Aug-98',987)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6653,224.53, '29-Sep-97',1721)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6656,55.99, '16-Sep-98',939)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6661,113.88, '23-Feb-99',456)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6668,1.91, '17-Oct-98',882)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6683,147.52, '07-Dec-98',458)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6684,240.28, '28-Aug-97',1629)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6686,104.82, '25-Jun-97',905)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6702,53.8, '15-Nov-98',966)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6705,4.05, '29-Nov-97',685)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6712,11.1, '02-Aug-97',182)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6734,171.1, '23-Sep-97',897)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6745,48.28, '29-May-99',1256)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6747,179.84, '10-Sep-98',1452)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6748,85.09, '30-Sep-98',547)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6753,228.02, '13-Apr-98',678)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6757,79.1, '02-Nov-98',566)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6765,202.9, '12-Oct-97',1693)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6767,110.54, '05-Jan-98',301)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6771,238.27, '22-Sep-98',889)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6780,92.49, '26-Jan-99',562)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6783,217.69, '11-Jul-98',370)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6802,87.56, '18-Aug-97',1948)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6808,4.11, '14-Dec-98',1729)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6827,202.45, '07-Feb-99',914)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6844,21.29, '09-Apr-99',1706)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6847,53.35, '19-Feb-98',1730)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6857,222.54, '01-Oct-97',1700)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6871,127.98, '20-May-99',15)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6872,133.52, '14-Dec-97',866)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6879,219.21, '14-Apr-99',1560)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6889,186.07, '07-Aug-97',1021)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6891,32.19, '27-May-99',560)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6896,209.46, '02-Jan-98',105)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6899,152.7, '23-Aug-98',1880)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6901,160.33, '08-May-98',782)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6909,82.04, '31-Oct-98',568)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6916,212.45, '09-Jun-98',1251)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6922,148.31, '11-Jan-98',1214)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6923,100.72, '20-Feb-99',1408)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6928,23.67, '04-Mar-99',508)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6960,206.45, '09-Sep-98',33)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6982,76.75, '25-Aug-97',269)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (6983,90.91, '15-Jan-98',300)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7018,163.81, '03-Nov-97',399)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7044,52.27, '21-Mar-98',81)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7048,64.22, '01-Nov-98',1928)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7051,150.53, '12-May-99',1637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7061,18.04, '05-Mar-99',955)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7062,241.08, '20-Feb-99',1722)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7063,185.4, '05-Jun-99',1077)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7083,232.9, '24-Sep-97',904)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7089,33.91, '24-Nov-98',568)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7099,186.63, '24-Oct-97',793)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7100,215.77, '15-Feb-98',1124)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7117,147.18, '27-Mar-98',1455)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7121,62.68, '29-Jul-98',314)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7123,138.34, '19-Jun-97',1182)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7134,190.96, '30-Dec-98',1111)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7139,242.77, '26-Oct-98',405)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7147,202.96, '27-Aug-97',1487)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7166,107.69, '21-Sep-97',1364)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7176,88.84, '16-Oct-98',318)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7191,107.73, '26-Dec-97',457)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7201,7.09, '09-Feb-98',1341)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7203,102.15, '13-Jan-99',256)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7208,14.7, '28-Aug-97',1469)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7209,128.78, '23-Apr-99',1206)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7213,66.95, '17-Jan-98',1258)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7229,8.94, '31-Jul-98',651)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7230,76.51, '24-Jun-97',1109)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7236,107.47, '08-Jun-97',1960)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7237,219.44, '15-Feb-99',1525)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7246,139.12, '27-Mar-99',262)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7248,167.71, '05-Mar-98',1202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7250,201.37, '25-Sep-97',675)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7254,154.49, '27-May-98',986)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7260,114.37, '01-Feb-98',321)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7262,129.6, '06-Jul-98',601)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7263,84.06, '15-Sep-98',344)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7266,128.85, '08-May-99',1428)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7292,11.08, '13-Jan-98',1274)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7300,154.86, '27-Aug-98',555)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7301,45.73, '07-Jun-98',1149)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7302,122.47, '29-Nov-97',311)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7303,96.35, '29-Jul-98',917)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7305,89.56, '05-Jan-98',1280)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7309,65.77, '25-Aug-97',1587)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7310,43.73, '02-Jul-98',1237)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7314,72.37, '02-Feb-99',1430)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7316,216.85, '28-Dec-98',135)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7319,171.38, '04-Mar-98',774)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7320,16.6, '04-May-98',1387)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7329,46.03, '12-May-98',1497)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7335,67.55, '29-Jul-97',1114)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7342,188.71, '15-Apr-99',1344)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7344,114.28, '01-May-98',772)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7345,6.06, '04-Sep-97',177)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7347,22.19, '23-Nov-97',1481)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7350,34.11, '26-Nov-98',940)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7362,71.22, '07-Sep-98',1799)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7365,157.59, '23-Aug-97',1007)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7368,44.22, '09-Apr-98',1538)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7377,105.97, '04-Mar-99',391)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7382,85.23, '10-Dec-97',417)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7387,56.35, '14-Feb-98',1778)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7390,209.55, '26-Aug-97',1028)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7395,145.75, '13-Feb-99',1216)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7404,213.32, '06-Sep-98',31)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7406,113.06, '28-Feb-99',796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7411,216.57, '22-Jul-98',219)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7424,195.75, '18-Jun-98',1246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7429,53.04, '06-Oct-98',1100)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7434,98.54, '31-Jul-97',461)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7438,144.42, '02-Apr-98',141)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7453,55.59, '29-May-98',1195)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7467,206.43, '11-Nov-98',420)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7480,238.81, '08-Feb-99',1075)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7493,235.06, '15-Oct-97',1427)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7495,22.34, '21-Dec-98',1100)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7510,156.29, '08-Feb-99',786)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7515,53.79, '26-Jun-98',1656)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7540,17.58, '24-Jul-98',1943)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7542,141.19, '26-Aug-97',1493)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7543,10.27, '19-Sep-97',773)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7557,202.66, '20-Sep-98',1988)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7560,4.56, '29-May-98',1116)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7564,69.44, '02-Feb-98',605)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7572,104.01, '02-May-99',830)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7582,61.69, '31-May-98',1551)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7600,172.39, '19-Nov-98',952)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7616,177.82, '17-Jul-98',971)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7620,229.72, '02-Nov-97',795)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7625,48.07, '03-Sep-97',1582)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7629,215.98, '20-Jun-97',1494)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7637,101.87, '16-Nov-97',207)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7639,6.87, '30-Jun-98',1919)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7640,40.07, '29-Aug-97',1290)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7673,229.05, '27-Feb-99',1289)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7683,192.34, '16-Apr-98',47)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7691,10.24, '03-Nov-98',1847)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7694,18.74, '18-Aug-98',760)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7696,19.16, '23-Aug-98',1518)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7701,147.52, '07-Aug-98',1296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7705,136.26, '28-Feb-99',229)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7718,174.29, '04-May-98',1157)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7754,115.6, '03-Apr-99',1983)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7757,21.72, '04-May-98',97)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7761,99.26, '01-Apr-98',39)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7772,143.65, '05-Jun-97',96)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7775,122.23, '11-May-99',1847)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7777,40.52, '13-Apr-98',1927)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7779,53.06, '03-Oct-97',1962)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7782,237, '07-Nov-97',1517)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7786,189.94, '26-Mar-99',1614)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7802,31.94, '25-Jan-98',1802)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7804,180.67, '31-Dec-98',1986)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7826,57.18, '19-Jul-98',912)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7832,27.09, '22-Sep-97',1044)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7835,224.25, '01-Apr-99',1702)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7840,158.89, '17-Dec-97',660)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7860,16.35, '12-Aug-98',15)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7861,229.55, '28-Jun-97',1293)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7867,130.73, '03-Jun-99',1466)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7872,20.51, '01-Jan-99',1386)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7879,198.45, '25-Mar-98',294)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7887,114.31, '08-Aug-97',660)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7904,1.72, '22-May-98',1232)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7921,189.69, '13-Jun-97',1758)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7922,219.92, '18-Dec-97',1079)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7936,100.51, '17-Feb-98',200)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7937,121.06, '06-Mar-98',1917)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7951,213.82, '06-Nov-97',438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7956,239.1, '13-Jan-99',1423)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7958,105.07, '25-Dec-98',83)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7959,96.31, '22-Jun-97',1423)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7969,101.4, '26-Dec-97',1340)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7971,170.77, '24-Apr-98',1750)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7973,32.52, '28-Dec-98',101)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7977,25.46, '16-Jan-99',1557)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7984,189.9, '25-Nov-98',754)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7991,75.41, '13-Feb-99',8)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (7994,183.47, '13-May-99',993)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8007,205.78, '25-Nov-97',1901)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8013,55.12, '16-Dec-98',117)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8016,21.9, '08-Jan-98',1275)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8020,41.43, '28-Jul-97',1717)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8023,94.03, '27-Dec-97',527)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8034,70.99, '17-Aug-97',416)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8040,203.82, '16-Aug-98',385)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8048,221.47, '28-Jun-97',916)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8050,109.13, '10-Aug-97',246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8060,234.85, '26-Mar-98',468)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8062,67.51, '23-Apr-99',370)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8070,192.07, '09-Mar-99',1819)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8072,195.89, '25-Dec-97',305)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8076,58.19, '14-Nov-98',1786)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8099,215.64, '19-Mar-99',280)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8103,130.23, '13-Jul-97',908)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8108,187.12, '13-Jul-97',952)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8115,164.92, '22-Aug-97',1802)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8116,224.67, '07-Oct-98',1192)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8134,165.84, '07-Dec-98',1593)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8139,191.99, '06-Aug-98',188)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8141,33.79, '14-Sep-98',1532)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8142,183.94, '05-Dec-97',1494)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8143,222.81, '08-Jan-98',1177)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8149,204.26, '07-Jan-99',480)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8150,120.25, '23-Apr-99',1691)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8155,149.67, '01-Sep-98',107)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8172,112.98, '30-May-98',396)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8178,141.66, '18-Nov-98',351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8180,83.32, '27-Oct-97',197)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8191,122.3, '05-May-99',1926)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8196,192.75, '15-May-99',1743)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8203,179.84, '21-Jun-98',889)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8204,157.91, '17-Aug-98',675)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8207,212.64, '22-Nov-97',1893)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8208,245.07, '14-Feb-98',941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8245,21.26, '10-Jun-98',1264)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8256,90.39, '16-Nov-98',1539)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8285,177.78, '20-Sep-97',496)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8286,204.95, '23-Feb-99',268)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8301,16, '09-Nov-97',871)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8306,63.51, '10-Oct-97',1393)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8312,42.56, '06-Oct-97',753)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8332,147.94, '03-Jan-98',502)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8338,42.98, '01-Jan-98',394)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8344,38.58, '11-Feb-99',702)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8348,83.94, '05-Jan-99',897)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8355,227.3, '20-Nov-97',152)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8362,62.54, '30-Aug-98',298)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8378,124.9, '30-Nov-98',1952)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8389,223.05, '20-Apr-98',615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8424,155.12, '23-Feb-98',1417)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8450,192.48, '15-Jul-97',53)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8454,250.09, '04-Oct-97',229)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8460,27.28, '06-Jan-99',1266)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8461,218.58, '06-Jun-98',1674)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8471,68.27, '20-Dec-98',817)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8481,225.53, '25-Sep-97',90)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8483,194.1, '30-Aug-97',1495)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8488,218.32, '28-Aug-98',1785)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8489,185.17, '13-Sep-98',541)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8491,75.25, '19-May-99',380)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8494,40.65, '15-Mar-99',1086)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8501,3.3, '14-Mar-99',931)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8503,187.69, '27-Mar-98',339)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8514,19, '04-Jan-99',516)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8523,20.25, '11-Jun-97',408)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8527,65.92, '02-Nov-98',1485)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8535,97.62, '25-Sep-98',1796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8550,95.13, '08-Sep-97',1619)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8551,130.16, '10-Jun-98',1374)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8561,120.55, '28-May-99',781)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8569,85.62, '10-May-99',1268)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8573,247.34, '30-Apr-98',1982)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8574,246, '01-Apr-98',1141)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8583,162.62, '11-Apr-99',1980)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8586,86.84, '19-Feb-99',1111)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8601,238.88, '13-Sep-98',1849)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8608,227.49, '25-Nov-97',498)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8636,192.93, '08-Oct-97',1386)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8653,101.59, '08-Dec-97',1571)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8659,31.5, '03-May-99',887)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8661,58.64, '27-Feb-98',753)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8662,122.85, '19-Sep-98',1290)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8674,139.69, '19-Mar-98',354)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8675,96.39, '14-Feb-98',1517)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8679,250.13, '21-Feb-99',402)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8686,133.89, '25-Dec-97',1551)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8692,217.33, '18-Nov-98',675)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8703,238.53, '11-Feb-99',617)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8719,149.02, '23-Jun-97',1052)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8720,221.99, '08-Aug-97',364)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8723,133.98, '29-Jul-97',680)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8733,11.19, '27-May-99',1526)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8775,197.31, '17-Jan-98',1226)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8785,20.45, '16-Aug-98',351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8788,32.99, '21-Sep-97',1028)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8794,173.26, '07-Jan-99',1106)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8800,192.78, '10-Jan-98',106)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8807,10.41, '19-Jun-97',368)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8809,21.15, '09-Sep-98',23)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8811,145.92, '28-Sep-97',1422)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8833,7.27, '16-Dec-98',431)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8839,113.02, '11-Feb-98',1443)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8852,228.58, '17-Jul-98',619)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8853,239.08, '16-Jul-97',972)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8856,49.07, '02-Jul-98',360)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8865,233.65, '10-Feb-98',1496)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8875,190.09, '18-Feb-98',833)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8877,73.14, '19-Dec-97',1617)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8879,215.48, '31-Mar-99',116)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8881,154.15, '12-Nov-98',1581)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8905,175.61, '17-Nov-98',1385)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8906,142.42, '15-May-99',1227)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8910,134.96, '09-Mar-98',541)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8915,149.9, '23-Sep-97',1463)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8922,37.8, '26-Sep-98',98)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8924,59.81, '04-Jul-98',1933)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8929,149.87, '04-Nov-97',50)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8935,162, '02-Jun-99',1271)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8951,69.03, '17-Oct-98',1684)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8955,197.88, '02-Aug-98',193)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8958,168.64, '08-Jul-98',312)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8966,213.15, '10-Aug-98',1235)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8968,193.26, '20-Oct-98',1229)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8974,77.1, '05-Jan-98',110)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8983,39.24, '17-Jun-98',211)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8989,189.86, '20-Apr-98',842)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8990,164.42, '13-Jan-99',1093)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8995,219.44, '06-Jan-99',1240)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8996,94.84, '03-Feb-98',438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (8998,215.86, '09-Oct-97',389)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9008,172.35, '11-Feb-99',1476)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9015,50.97, '10-May-99',671)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9032,24.25, '07-Apr-99',1714)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9050,42.64, '28-Jan-98',27)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9054,41.34, '15-May-98',1893)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9059,224.08, '06-Jul-97',388)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9067,34.06, '30-Sep-98',474)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9073,97.45, '20-Mar-98',1874)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9084,72.03, '28-Feb-98',1892)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9086,173.48, '11-Mar-99',1911)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9087,239.73, '04-Jul-97',1979)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9115,197.64, '11-Nov-98',480)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9130,197.36, '05-Jun-98',576)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9131,220.55, '06-Oct-98',823)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9135,4.83, '06-Nov-97',164)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9145,131.89, '28-Jun-97',1941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9150,72.15, '20-Feb-99',1187)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9164,163.13, '05-Feb-98',1601)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9165,170.4, '05-Mar-99',1609)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9169,155.06, '30-Apr-99',936)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9170,66.59, '28-Jan-99',1544)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9173,161.03, '20-Apr-99',1026)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9174,124.44, '16-Feb-98',889)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9175,202.39, '22-Mar-98',1975)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9178,188.8, '16-Jan-99',893)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9182,90.66, '06-Apr-98',445)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9183,140.47, '15-Mar-99',825)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9193,235.8, '07-Mar-99',1136)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9197,30.68, '20-Apr-98',235)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9199,226.87, '07-Oct-97',762)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9203,156.97, '03-Jan-99',31)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9204,101.35, '09-Dec-97',1153)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9205,164.59, '17-Jan-98',603)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9209,201.26, '25-Oct-98',1521)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9223,218.98, '24-Jul-97',168)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9225,29.38, '26-Oct-98',984)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9231,85.41, '24-Jan-99',212)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9234,117.43, '13-Aug-98',1831)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9253,76.05, '30-Sep-97',1017)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9256,90.29, '16-Jun-98',1974)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9268,245.58, '25-Nov-98',392)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9270,149.33, '29-Nov-98',140)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9273,56.2, '17-Jan-98',1336)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9281,159.86, '17-Jun-98',1915)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9282,63.92, '08-May-98',1848)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9285,101.35, '09-Jun-98',741)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9292,83.01, '01-Sep-97',958)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9299,5.84, '05-Jul-98',1858)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9303,195.88, '06-Aug-98',1824)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9320,48.75, '01-Apr-99',1639)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9322,178.94, '04-Jul-97',293)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9328,122.72, '19-Aug-98',881)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9329,179.28, '17-May-99',545)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9337,196.72, '08-Mar-99',1385)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9355,98.47, '18-Mar-99',1078)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9368,60.56, '20-Nov-97',17)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9381,229.63, '13-May-98',265)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9382,20.92, '09-Sep-97',440)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9383,235.04, '17-Oct-98',565)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9401,121.82, '23-Mar-98',1668)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9413,39.51, '16-Dec-98',223)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9420,143.19, '12-Nov-98',1254)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9423,204.1, '11-Aug-97',18)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9425,198.35, '02-Dec-97',1014)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9438,109.25, '02-Dec-98',361)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9442,113.45, '28-Sep-97',1217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9449,81.46, '19-Aug-97',1565)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9452,109.07, '17-Apr-99',1005)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9456,11.97, '13-Apr-98',33)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9463,150.69, '29-Aug-98',140)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9464,102.99, '16-Oct-97',217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9466,131.52, '29-May-99',1114)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9469,103.92, '12-Mar-99',292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9481,195.2, '01-Feb-99',1882)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9491,95.87, '18-Feb-99',1470)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9507,243.77, '14-May-98',986)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9509,22.51, '08-Aug-98',450)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9515,194.07, '22-Nov-97',339)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9516,209.82, '13-Sep-97',1621)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9527,162.24, '21-Jun-98',1002)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9540,74.18, '26-Mar-99',1532)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9541,118.97, '07-Feb-99',643)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9546,79.71, '23-Apr-98',286)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9560,82.16, '10-Nov-97',6)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9565,23.68, '03-May-98',1764)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9566,79.51, '08-Sep-97',1726)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9583,175.7, '20-Apr-98',1773)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9584,40.52, '23-Jul-97',139)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9589,136.14, '09-Mar-99',105)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9606,19.02, '25-Mar-99',1085)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9616,30.62, '04-Apr-98',1699)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9623,105.48, '22-May-99',1797)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9636,64.73, '10-Apr-98',1387)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9637,206.71, '19-Jun-98',1573)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9646,32.89, '28-Sep-98',1766)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9649,72.58, '18-Mar-99',408)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9666,108.09, '17-Dec-98',170)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9673,1.13, '19-Oct-98',1267)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9677,238.21, '29-May-98',1648)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9685,15.41, '10-Jun-98',1299)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9686,127.04, '15-Jul-97',488)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9689,1.18, '04-Jan-99',217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9697,133.49, '07-May-99',987)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9704,218.42, '09-Jul-97',796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9709,239.8, '28-Feb-99',1211)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9712,210.39, '17-Jun-98',1151)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9716,235.36, '31-Dec-98',1631)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9717,158.29, '24-Oct-98',1814)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9730,40.36, '24-Feb-98',1336)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9734,2.13, '18-Aug-98',867)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9736,104.76, '01-Mar-99',24)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9740,64.9, '17-Jun-98',468)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9741,248.28, '21-Nov-97',832)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9748,107.37, '04-Sep-97',752)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9764,80.44, '02-Aug-97',1390)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9773,17.66, '06-Aug-98',512)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9795,199.47, '12-Feb-99',872)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9805,44.94, '12-Apr-99',251)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9809,192.64, '31-Dec-98',662)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9816,228.22, '06-Mar-98',772)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9830,27.01, '29-Sep-98',1788)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9833,154.81, '02-Jul-98',1740)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9837,80.11, '08-Dec-97',48)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9844,58.4, '29-Oct-98',344)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9846,222.53, '23-Oct-97',157)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9847,125.21, '14-Feb-99',1326)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9851,65.31, '31-Jan-98',1915)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9854,159.09, '10-May-99',1193)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9855,38.58, '02-Mar-98',15)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9858,199.36, '30-Sep-97',621)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9860,114.46, '06-Jul-98',1538)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9862,126.55, '26-Aug-97',1587)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9887,218.28, '11-Aug-98',1603)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9888,93.17, '19-Feb-99',228)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9897,39.39, '26-Apr-98',90)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9910,218.03, '31-Oct-98',1748)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9914,43.75, '20-May-99',163)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9917,240.7, '25-Sep-98',1673)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9943,19.03, '02-Nov-98',129)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9957,32.82, '25-Jun-98',982)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9986,248.68, '21-Dec-98',843)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (9989,250.8, '27-Aug-98',1995)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10002,94.14, '20-Oct-98',1054)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10003,49.05, '03-Sep-98',747)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10005,222.94, '08-Feb-98',1586)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10008,176.71, '06-Sep-97',1933)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10019,17.1, '19-Sep-97',731)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10029,231.91, '27-May-99',63)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10034,117.09, '30-Nov-98',347)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10038,4.51, '02-Feb-98',1882)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10039,24.52, '03-Aug-97',1334)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10044,126.68, '05-Mar-98',1470)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10047,92.05, '22-Mar-98',1048)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10058,60.57, '09-Feb-99',1409)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10060,52.82, '18-Mar-99',1792)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10061,78.34, '23-Nov-97',270)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10075,30.19, '18-Dec-98',1086)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10078,116.69, '02-Jan-99',1559)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10093,185.67, '14-May-98',536)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10099,213.14, '01-Sep-98',1344)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10100,125.41, '10-May-99',583)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10102,43.49, '30-Apr-98',425)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10125,50.89, '25-Oct-98',861)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10129,29.62, '27-Apr-98',1814)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10149,99.62, '02-Mar-98',440)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10151,48.72, '02-Oct-98',359)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10157,174, '29-Mar-99',1244)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10167,91.12, '06-Jun-98',10)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10172,169.08, '02-Jun-99',1648)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10178,54.37, '08-Nov-97',1058)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10179,143.36, '29-Aug-97',1853)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10181,120.97, '14-Mar-98',1805)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10189,56.01, '22-Aug-97',1686)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10195,174.65, '16-Mar-99',593)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10197,118.79, '31-Jul-97',1571)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10198,129.64, '13-Dec-98',87)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10200,127.15, '04-Nov-97',1453)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10204,131.01, '08-Nov-97',1370)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10205,95.85, '01-Aug-98',54)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10215,157.12, '22-Apr-98',1865)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10220,8.72, '08-Jan-99',1370)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10234,231.76, '07-Apr-99',1157)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10240,20.79, '22-May-99',1120)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10243,235.95, '03-Dec-97',1587)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10257,160.45, '28-Dec-98',915)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10262,37.19, '15-Mar-98',1091)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10265,210.5, '19-May-99',304)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10268,222.87, '16-Apr-98',1928)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10290,179.15, '14-Jun-97',557)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10297,17.92, '26-Dec-98',241)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10305,190.74, '18-Mar-99',1289)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10314,144.37, '05-Apr-98',95)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10322,172.47, '24-Dec-98',1316)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10375,129.7, '27-Aug-97',1969)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10384,244.49, '24-Jun-98',834)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10385,181.6, '16-Apr-99',954)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10388,240.31, '04-Feb-98',1115)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10390,147.78, '06-Dec-97',53)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10401,170.28, '10-Nov-97',1494)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10404,19.7, '09-Jul-98',464)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10410,172.71, '15-May-99',1038)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10412,242.77, '03-Feb-99',1110)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10420,156.8, '28-Aug-98',530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10423,147.26, '28-Dec-98',176)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10431,22.1, '20-Oct-98',1941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10432,142.17, '03-Feb-99',1783)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10439,48.38, '19-May-98',545)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10458,128.58, '28-Jan-98',1121)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10474,22.97, '12-Oct-98',1647)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10479,60.93, '02-Jun-98',1942)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10485,243.71, '17-Sep-98',1754)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10486,80.77, '17-Apr-98',359)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10492,46.32, '17-Feb-99',570)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10510,10.78, '10-Oct-97',78)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10513,93.06, '18-Mar-99',1931)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10515,3.23, '19-Mar-98',23)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10516,238.24, '14-Jun-97',1000)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10521,161.9, '20-Jul-97',1437)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10525,74.12, '11-Mar-98',488)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10531,42.44, '26-Jan-99',477)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10539,63.9, '30-May-98',299)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10551,136.8, '15-Sep-98',1665)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10553,38.48, '20-Dec-98',1842)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10572,10.94, '27-Sep-98',1098)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10576,182.09, '04-Sep-98',266)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10590,154.86, '27-Apr-98',1393)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10592,244.83, '06-Mar-98',665)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10598,136.14, '30-Jul-98',1890)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10610,205.11, '08-Oct-97',467)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10616,53.74, '11-Jun-97',618)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10623,150.68, '30-Apr-99',1801)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10624,19.51, '13-Jun-97',805)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10625,202.61, '26-May-99',273)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10626,102.96, '19-Jun-97',1015)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10639,12.76, '28-Jun-98',244)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10644,127.48, '09-Jun-98',1823)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10646,39.89, '05-Apr-98',790)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10650,189.22, '12-Dec-98',1366)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10656,162.77, '28-Jan-99',66)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10662,92.12, '16-May-98',1547)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10669,101.5, '07-Nov-98',345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10674,203.59, '14-Jun-97',403)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10678,42.58, '04-Oct-98',1615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10680,54.68, '12-Feb-98',575)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10690,249.65, '01-Oct-98',1947)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10693,153.2, '12-Jul-97',1609)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10699,129.86, '06-Jul-98',1025)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10701,125.82, '16-Nov-98',1725)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10709,222.18, '21-Sep-98',1844)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10717,233.81, '18-Aug-97',561)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10743,71.69, '29-Jan-99',1906)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10745,173.46, '22-Jun-98',1754)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10762,114.91, '01-Jun-99',1194)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10766,134.1, '25-Feb-98',698)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10785,6.47, '13-May-99',87)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10793,124.21, '26-Nov-97',1593)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10805,148.87, '09-Jul-98',1690)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10812,240.76, '30-Dec-97',1601)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10814,229.04, '28-Apr-98',880)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10818,87.5, '15-Jul-98',762)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10831,201.6, '07-Nov-98',515)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10833,114.83, '17-May-99',973)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10863,227.14, '13-Sep-97',1078)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10874,182.88, '01-Jul-97',1975)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10880,222.89, '14-Apr-98',282)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10888,213.61, '23-May-98',1469)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10903,34.39, '13-Feb-99',281)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10923,178.74, '02-Mar-99',753)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10926,161.41, '09-Dec-97',1584)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10927,24.28, '01-Feb-98',504)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10941,236.99, '30-Jul-97',812)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10946,66.66, '12-Dec-97',516)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10952,224.44, '16-Jan-99',1485)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10953,127.68, '01-Jan-98',1070)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10962,153.23, '19-Oct-97',668)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10969,54.61, '28-Sep-97',1192)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10972,174.93, '12-Nov-97',1032)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10979,96.7, '30-Oct-97',1309)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10987,7.48, '18-Jun-97',399)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10989,230.97, '22-Jan-98',1776)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10993,172.64, '30-Apr-99',817)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (10996,39.78, '24-May-98',950)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11007,229.95, '05-Nov-98',351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11011,92.1, '05-Oct-97',1674)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11025,148.03, '24-Feb-99',211)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11035,149.31, '21-Dec-98',1927)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11043,66.77, '03-Jun-98',222)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11045,12.51, '18-Mar-98',800)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11054,47.68, '06-Aug-97',722)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11063,249.08, '28-Oct-97',1996)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11064,238.19, '08-Sep-97',1490)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11065,19.34, '09-Jun-98',1295)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11067,59.74, '19-Oct-97',51)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11072,24.12, '05-Mar-98',476)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11074,185.14, '25-Dec-98',1206)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11084,218.06, '07-Apr-98',404)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11086,236.14, '07-Apr-98',1121)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11091,234.78, '09-Jul-97',264)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11094,235.71, '24-Jun-97',1729)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11096,147.26, '10-Apr-99',854)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11102,191.04, '20-Aug-97',1226)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11105,211.03, '13-Jan-99',360)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11114,134.15, '02-Apr-99',1878)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11119,125.18, '07-Sep-98',189)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11127,14.59, '17-Apr-98',1217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11137,249.68, '08-Jan-98',1835)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11138,16.62, '10-Feb-99',28)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11142,96.96, '10-Apr-99',351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11143,231.92, '05-Mar-98',356)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11145,109.5, '02-Apr-99',1627)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11146,146.23, '23-May-99',1099)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11150,250.43, '27-Nov-97',1159)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11164,132.29, '03-Jan-98',596)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11167,235.14, '08-Feb-98',674)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11177,127.4, '16-Dec-98',1299)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11178,58.52, '17-Feb-99',1315)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11179,207.19, '17-Oct-97',743)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11182,74.26, '17-Nov-98',797)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11183,62.63, '11-Sep-98',552)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11190,153.87, '18-Jul-98',276)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11194,196, '07-Nov-97',1797)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11201,38.41, '05-Jun-97',1210)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11204,67.05, '10-Mar-98',1796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11205,186.43, '09-Nov-98',1413)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11207,72.53, '10-Oct-97',1745)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11213,193.62, '10-Feb-98',1763)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11217,249.44, '28-Jan-98',1559)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11227,147.45, '03-Nov-97',924)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11229,122.78, '05-Sep-98',1068)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11232,193.98, '03-Jun-98',1468)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11243,178.25, '19-Sep-97',1326)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11265,112.72, '28-Sep-98',819)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11269,192.56, '08-May-98',568)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11276,220.9, '17-Apr-98',261)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11285,90.59, '03-May-99',1331)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11288,203.44, '25-Feb-99',1077)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11308,165.04, '09-Feb-98',1536)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11310,242.16, '14-Oct-97',1810)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11313,136.09, '23-Dec-98',1148)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11319,23.59, '18-Feb-99',287)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11320,64.09, '12-Mar-98',1788)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11324,128.73, '17-Sep-97',438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11329,222.61, '16-Dec-97',663)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11334,125, '25-Mar-98',376)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11343,169.61, '07-Sep-97',1550)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11349,140.19, '17-Sep-98',779)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11360,204.75, '28-Sep-97',1441)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11362,69.57, '03-Jul-97',1032)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11367,1.64, '30-Mar-99',1556)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11383,180.42, '24-Mar-99',446)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11393,116.08, '31-Jan-99',741)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11401,244.7, '07-Apr-98',650)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11402,121.35, '01-Mar-98',722)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11405,111.21, '11-Jul-97',1895)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11411,24.82, '20-Dec-97',1101)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11413,225.37, '29-Dec-97',462)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11418,218.3, '28-Dec-98',941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11431,153.52, '05-Jan-98',15)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11433,82.75, '14-Oct-97',791)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11451,226.95, '31-May-98',856)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11457,46.13, '11-Feb-98',1053)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11470,32.31, '16-Mar-98',1114)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11473,41.73, '02-Sep-98',1637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11476,240.52, '09-Dec-98',1896)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11477,95.13, '09-Mar-99',378)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11500,5.82, '25-Nov-97',1979)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11507,223.48, '14-Nov-97',1933)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11510,116.58, '13-May-98',1432)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11515,65.59, '09-Sep-98',561)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11518,246.83, '23-Sep-98',417)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11521,11.76, '20-Jan-99',1600)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11522,54.89, '29-May-98',1632)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11523,226.12, '28-Jun-97',482)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11531,245.61, '02-Nov-98',289)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11532,90.28, '06-Sep-98',852)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11541,1.47, '12-Apr-98',530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11563,182.72, '05-Dec-98',259)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11565,76.64, '24-Sep-98',1116)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11567,50, '15-Oct-97',156)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11572,208.33, '14-Jan-98',1605)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11574,151.61, '11-Dec-97',1616)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11577,249.2, '27-Nov-97',747)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11582,106.96, '09-Feb-98',1099)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11584,211.5, '04-Feb-99',1306)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11603,220.58, '24-Apr-98',1416)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11605,192.38, '14-Apr-99',915)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11610,173.2, '21-Feb-98',483)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11614,229.21, '15-Dec-98',1059)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11617,117.78, '12-Jan-98',985)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11618,237.36, '06-Oct-97',1945)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11653,217.48, '07-May-99',421)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11669,167.87, '11-Mar-98',1535)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11673,152.67, '06-Oct-98',439)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11678,111.09, '12-Dec-98',218)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11692,99.55, '08-May-98',781)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11698,204.83, '13-Aug-97',1241)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11704,108.28, '21-Feb-98',1765)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11707,41.98, '13-Dec-98',1081)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11708,145.23, '23-Jan-99',1910)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11715,75.04, '02-Feb-98',152)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11717,219.66, '09-Mar-98',1217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11721,203.2, '04-Dec-97',952)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11724,18, '28-Mar-98',1881)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11725,11.43, '07-May-99',1802)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11726,16.32, '16-Dec-98',796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11730,21.25, '11-Aug-97',828)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11731,67.81, '27-Jan-99',298)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11737,235.87, '21-May-99',1777)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11741,10.74, '22-Sep-97',1576)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11768,144.8, '20-Sep-98',1957)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11771,20.94, '06-Nov-98',1723)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11773,16.28, '20-Jun-98',1168)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11780,248.45, '19-Jun-98',869)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11805,30.71, '09-Mar-99',819)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11814,6.31, '14-Feb-98',1699)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11822,69.86, '31-Aug-97',237)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11834,44.34, '10-Jan-99',271)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11837,52.04, '17-Nov-97',528)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11851,227.33, '08-Jun-97',745)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11853,67.16, '20-Mar-98',405)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11857,36.02, '01-Oct-97',1285)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11859,56.35, '15-Jun-97',117)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11862,238.11, '05-Aug-97',1127)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11863,84.34, '23-Apr-99',669)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11867,133.64, '24-Aug-97',313)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11869,84.26, '20-Jul-98',296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11877,191, '16-May-99',482)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11880,174.36, '29-Dec-97',395)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11897,129.65, '11-Oct-97',522)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11901,124.38, '14-Mar-99',137)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11915,4.71, '15-Nov-97',40)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11916,200.68, '14-Jun-98',1269)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11919,166.98, '15-Dec-98',1893)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11924,2.05, '24-Aug-97',1611)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11926,186.19, '31-May-99',725)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11933,174.39, '27-Oct-97',8)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11935,245.45, '16-Mar-98',116)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11937,108.91, '11-Aug-97',1492)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11978,152.05, '06-Mar-99',462)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11987,185.21, '19-Jun-97',874)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (11992,57.68, '28-Apr-98',1192)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12000,122.27, '26-Sep-98',368)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12019,36.35, '13-Oct-97',272)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12020,58.81, '06-Jul-98',1906)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12029,124.79, '20-Jul-97',15)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12046,192.46, '15-Jul-97',47)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12056,220.67, '26-Mar-99',563)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12059,127.82, '10-Nov-97',950)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12060,182.03, '10-May-99',202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12061,208.38, '30-Jan-98',135)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12081,85.14, '27-Jul-98',1851)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12085,55.05, '23-Apr-98',29)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12089,229.06, '18-May-99',200)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12091,68.88, '09-Dec-97',948)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12093,51.86, '04-Aug-98',313)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12100,3.16, '02-Nov-97',640)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12104,231.51, '18-Mar-99',597)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12109,101.56, '01-Nov-98',424)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12111,214.51, '09-Sep-97',1226)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12125,153.24, '27-Jan-99',550)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12126,16.39, '09-Apr-98',893)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12129,24.53, '13-Jan-99',1609)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12130,11.7, '14-Oct-97',20)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12136,106, '21-Mar-98',1396)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12157,14.51, '13-Jul-97',845)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12159,61.62, '24-Feb-99',1624)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12175,134.17, '30-Sep-97',1473)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12179,205.08, '11-Apr-98',17)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12189,134.68, '20-Dec-97',1199)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12190,179.89, '06-Jul-97',1927)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12208,159.17, '03-May-98',449)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12209,111.24, '10-Jul-97',249)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12215,40.24, '25-Nov-98',1336)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12221,12.74, '20-May-98',1612)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12229,2.88, '06-Jul-97',1021)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12237,79.23, '31-Jul-98',1840)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12252,246.13, '21-Mar-99',469)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12266,197.56, '09-Apr-99',1357)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12281,146.67, '16-Feb-98',1987)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12283,119.38, '02-Sep-98',296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12286,13.06, '20-Feb-98',1573)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12290,175.86, '15-Nov-98',151)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12318,48.37, '21-Mar-99',948)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12325,56.04, '20-Dec-98',1717)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12343,248.15, '15-May-99',950)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12346,204.04, '05-Jan-98',924)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12353,3.49, '17-Sep-98',36)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12356,214.43, '25-Aug-98',176)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12363,177.56, '26-Apr-98',1663)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12379,154.02, '05-May-98',1699)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12383,214.75, '12-Mar-99',377)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12385,70.78, '14-Apr-98',46)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12403,248.03, '13-Apr-98',1370)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12416,1.41, '15-Oct-97',896)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12441,224.24, '11-Jan-98',1962)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12443,189.29, '04-Oct-98',1052)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12446,57.16, '19-Jul-98',906)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12458,33.88, '26-Jan-98',1778)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12471,96.38, '16-Jun-97',1502)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12476,227.69, '19-Aug-97',166)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12484,156.04, '29-Jun-97',1350)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12500,227.92, '21-Oct-97',977)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12501,52.9, '19-Jun-97',924)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12536,200.57, '13-May-99',37)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12557,15.03, '22-Apr-98',1981)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12559,16.81, '15-Feb-99',374)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12560,134.21, '17-Jun-98',1664)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12574,207.27, '01-Jul-97',1802)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12581,2.5, '27-Oct-97',1150)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12587,51.54, '10-Jun-97',218)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12591,204.4, '19-Mar-98',351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12593,31.42, '18-Feb-98',1069)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12609,42.84, '25-Aug-98',1755)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12614,16.35, '22-Sep-98',1952)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12632,211.36, '06-Sep-98',1701)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12633,96.39, '28-Mar-98',116)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12635,8.59, '10-Jun-97',517)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12638,54.56, '02-Aug-97',726)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12647,215.13, '17-Nov-98',275)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12649,112.24, '26-Sep-97',839)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12652,127.52, '07-Jun-98',183)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12653,167.01, '02-Mar-98',1666)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12698,18.76, '26-May-98',231)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12699,184.17, '24-Jun-97',807)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12707,247.88, '16-Nov-97',1739)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12733,10.39, '21-Oct-97',1181)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12736,171.14, '21-Sep-98',1766)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12741,35.11, '04-Nov-98',825)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12742,179.3, '24-Apr-98',1265)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12743,57.58, '24-Jan-98',396)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12749,148.04, '24-Oct-97',1878)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12760,214.23, '11-Jan-98',1616)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12762,109.13, '01-Nov-97',782)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12767,219.91, '30-Mar-98',98)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12801,190.66, '12-Feb-98',1755)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12807,152.14, '28-Apr-98',144)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12812,127.9, '14-Feb-98',54)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12818,73.33, '26-Apr-99',1953)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12823,170.86, '28-May-99',1290)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12825,34.74, '07-Aug-97',379)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12852,153.06, '23-Jan-99',1862)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12858,115.73, '01-Jan-99',1578)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12864,147.33, '20-Feb-98',1504)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12870,232.57, '10-Jul-97',1517)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12880,246.63, '19-Mar-98',483)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12881,207.21, '15-Feb-98',1596)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12895,2.92, '03-Nov-97',1880)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12907,121.21, '22-Oct-97',1261)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12912,157.68, '14-Feb-99',1531)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12913,139.13, '23-Jan-98',697)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12923,31.47, '03-Jan-98',857)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12933,190.86, '17-Apr-98',869)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12934,30.44, '27-Sep-97',119)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12944,187.3, '20-May-98',1700)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12956,123.09, '29-Apr-98',745)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12969,124.11, '04-Apr-99',1493)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12971,166.38, '14-Mar-98',672)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12975,82.08, '07-Dec-98',892)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12976,84.51, '29-Dec-97',990)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12980,46.25, '13-Sep-98',1044)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12985,46.1, '04-Jan-99',1585)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12995,237.16, '14-Jul-98',1859)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12996,79.58, '11-Feb-99',422)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (12999,149.3, '13-Jul-98',796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13001,80.74, '17-Feb-99',755)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13003,217.12, '25-Dec-97',1403)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13004,164.31, '21-Jan-98',146)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13005,150.82, '08-Mar-99',23)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13015,161.07, '16-Apr-98',242)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13020,39.05, '24-Mar-99',131)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13021,76.02, '04-Feb-99',969)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13031,246.98, '09-Nov-97',172)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13038,237.45, '30-Jan-99',369)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13039,164.81, '24-Mar-99',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13045,88.69, '17-Jul-97',306)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13049,226.15, '16-Sep-98',228)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13050,161.54, '30-Jul-98',65)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13063,134.17, '31-May-98',1482)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13076,237.38, '14-Nov-97',577)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13092,105.71, '23-Jan-98',512)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13094,47.88, '22-Jul-97',931)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13105,226.7, '11-Sep-97',287)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13108,79.75, '18-Dec-97',1164)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13110,49.71, '20-Oct-97',1351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13115,78.01, '30-Jan-98',1846)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13121,57.27, '08-Jan-98',1442)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13131,196.77, '24-May-98',1164)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13142,244.1, '14-Feb-99',125)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13145,217.56, '01-May-99',506)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13150,91.74, '26-Nov-98',560)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13161,54.57, '23-Aug-98',1697)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13163,10.35, '24-Oct-98',313)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13164,226.95, '01-Aug-97',427)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13170,51.09, '06-Dec-97',689)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13176,30.13, '03-Apr-99',1719)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13200,175.26, '14-Feb-99',1411)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13202,241.03, '06-Aug-97',1096)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13222,174.26, '28-Mar-99',11)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13227,195.84, '30-Oct-98',662)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13231,120.43, '15-Jul-97',941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13245,8.04, '24-Mar-99',751)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13247,20.06, '07-Dec-97',1303)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13253,69.34, '03-Mar-98',629)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13256,129.89, '01-Jan-99',647)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13259,67.73, '05-Jun-98',1862)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13261,216.85, '19-Jan-99',1917)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13264,228.57, '28-Apr-98',50)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13267,211.97, '09-Dec-98',4)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13281,164.5, '05-Nov-97',1608)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13282,166.99, '22-Nov-98',1784)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13285,67.96, '06-Dec-98',177)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13294,41.62, '24-Aug-97',520)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13295,93.47, '15-Jun-97',1539)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13297,129.47, '26-Jun-98',1986)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13299,163.88, '27-Apr-98',1745)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13303,101.46, '01-Jun-99',1689)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13304,68.59, '04-Jul-98',1867)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13318,120.09, '24-Jul-97',404)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13321,184.51, '27-Jan-99',354)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13331,94.07, '06-Jun-98',1670)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13345,6.6, '11-Feb-99',1334)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13350,192.94, '17-Jul-98',28)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13367,222.71, '08-Aug-97',1613)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13383,215.72, '01-Jun-99',927)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13392,3.17, '11-Dec-98',1781)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13394,143.56, '22-Mar-98',1956)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13396,36.56, '16-Feb-99',642)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13397,54.72, '11-Apr-99',1870)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13400,87.28, '20-Feb-99',250)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13402,134.36, '17-Jul-98',427)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13409,133.28, '14-Apr-98',1295)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13417,118.61, '05-Nov-97',252)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13418,150.28, '01-Dec-98',1773)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13426,4.46, '05-Feb-98',1836)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13430,160.65, '23-Jul-98',163)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13437,150.95, '18-Sep-98',707)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13442,225.42, '06-Apr-98',1212)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13454,24.45, '19-Jul-97',1112)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13462,224.61, '22-Nov-98',1397)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13473,45.54, '13-May-99',1490)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13478,101.94, '21-Jun-97',982)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13485,47.08, '14-Jun-97',1026)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13493,195.84, '02-Mar-99',1482)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13498,105.39, '19-Oct-97',989)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13510,108.59, '16-Dec-97',1836)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13524,214.33, '03-Sep-98',58)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13525,9.66, '30-Sep-97',1470)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13537,242.38, '07-May-98',1920)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13538,53.16, '25-Nov-97',822)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13567,185.6, '18-Sep-98',1305)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13575,36.98, '03-Feb-98',407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13577,100.33, '04-May-99',1253)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13582,125.14, '20-Apr-99',16)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13584,86.04, '03-Jun-99',510)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13596,50.5, '16-Aug-98',1401)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13611,170.36, '16-Dec-97',178)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13614,55.71, '28-Dec-97',357)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13615,108.8, '20-Aug-98',545)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13621,6.51, '11-May-99',1785)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13626,74.66, '27-Mar-99',683)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13628,218.96, '08-Mar-99',831)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13633,73.71, '26-May-99',1129)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13634,101.27, '16-Dec-98',1897)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13635,92.93, '10-Sep-98',369)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13652,33.41, '04-Nov-97',412)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13657,88.74, '04-Jun-98',896)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13662,129.91, '22-Mar-98',393)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13676,75.39, '26-Sep-98',670)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13678,51.21, '05-Sep-97',278)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13683,94.94, '26-Jul-97',968)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13692,221.87, '06-Nov-97',803)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13695,222.57, '20-Dec-98',1446)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13700,23.75, '17-Jan-98',1138)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13706,207.63, '23-Aug-97',1086)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13707,33.06, '02-Feb-98',438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13713,99.16, '21-May-99',1028)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13724,57.32, '16-Dec-97',1345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13732,75.6, '31-Mar-98',1461)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13747,143.05, '12-Dec-97',409)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13748,106.96, '31-Aug-98',824)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13753,17.89, '19-Mar-99',764)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13754,185.24, '18-Apr-98',1316)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13757,6.69, '25-Aug-98',321)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13765,102.57, '01-Jul-97',433)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13768,101.85, '29-Oct-97',1711)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13769,156.27, '19-Jan-99',637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13773,34.65, '14-Apr-98',1955)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13775,179.2, '20-Sep-97',1307)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13780,242.8, '22-Aug-98',1703)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13797,241.5, '18-Nov-97',919)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13800,120.6, '12-Feb-99',1807)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13822,235.27, '19-Jun-98',136)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13824,234.59, '24-Jan-98',1302)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13827,46.59, '04-Jan-99',743)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13837,45.73, '07-Oct-97',1140)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13838,249.46, '04-Sep-97',636)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13847,113.79, '22-May-98',78)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13860,91.31, '22-Jul-97',1463)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13868,129.59, '16-Aug-98',879)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13880,10.86, '03-Oct-98',1013)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13892,47.32, '05-Jan-98',1141)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13898,135.85, '13-Nov-98',452)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13901,90.38, '26-Feb-99',559)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13905,129.4, '02-Jul-98',1907)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13938,98.95, '06-Dec-97',380)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13939,250.87, '11-Jul-98',138)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13944,117.53, '23-Feb-99',1674)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13952,31.93, '18-Apr-99',1509)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13953,225.9, '19-Mar-99',1050)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13965,171.62, '14-Jun-98',212)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13977,56.13, '23-Jan-98',1257)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (13987,57.22, '05-Apr-99',1103)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14001,231.48, '29-Jun-97',1262)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14003,190.3, '13-Jul-98',516)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14022,40.03, '22-Jul-97',966)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14029,37.43, '26-Aug-97',100)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14030,180.65, '24-Mar-98',1687)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14045,103.94, '10-Mar-99',1983)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14047,126.08, '14-May-99',107)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14054,25.94, '09-Oct-98',4)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14056,20.62, '02-Feb-98',932)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14071,128.57, '19-Jun-97',1248)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14075,183.3, '16-Oct-98',929)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14076,169.22, '21-May-99',1806)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14078,74.02, '08-Dec-98',521)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14085,15.62, '14-Apr-99',428)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14088,226.11, '18-Jul-97',618)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14093,188.82, '04-Oct-98',222)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14113,99.92, '27-Dec-98',1333)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14117,242.5, '06-Jun-97',1500)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14124,70.12, '28-Oct-98',1938)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14145,88.15, '10-Oct-98',816)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14147,7.58, '01-Sep-97',1052)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14157,124.79, '09-Oct-97',578)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14160,108.35, '16-Oct-98',1853)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14167,129.12, '25-Nov-98',754)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14169,209.91, '08-Jul-97',1286)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14170,54.75, '18-Mar-98',939)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14174,166.09, '15-Jul-97',226)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14179,29.66, '12-Jul-97',1593)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14188,174.83, '21-Nov-97',914)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14201,213.96, '07-Apr-99',871)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14211,29.01, '12-Feb-98',318)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14215,14.28, '04-Apr-99',1407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14220,184.18, '14-Mar-98',959)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14221,96.33, '10-Sep-98',1169)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14226,210.65, '06-Jul-98',60)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14228,114.02, '21-Sep-97',481)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14231,162.42, '27-Apr-99',92)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14256,126.07, '04-Oct-98',1892)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14272,169.04, '23-Dec-98',504)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14277,135.79, '29-Oct-98',237)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14282,129.65, '12-Apr-98',1763)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14285,102.46, '08-Jul-97',1994)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14290,226.91, '23-Feb-98',112)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14292,236.51, '27-Jan-98',1244)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14299,144.23, '06-Jan-99',1740)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14307,145.68, '30-Mar-98',592)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14309,165.04, '02-Nov-98',1661)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14311,242.09, '29-Sep-98',766)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14335,15.08, '16-Aug-98',1216)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14355,2.43, '04-Jul-97',224)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14364,202.11, '04-Jan-99',126)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14377,119.64, '02-Jul-98',1979)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14387,191.51, '04-Aug-97',208)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14398,133.58, '01-Mar-99',651)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14399,250.96, '05-Mar-99',232)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14408,168.58, '03-Jun-98',1634)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14435,151.02, '31-Jul-98',528)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14441,1.27, '29-Aug-97',1969)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14456,238.71, '28-Nov-98',394)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14462,137.98, '30-Oct-98',631)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14479,160.17, '21-May-99',1441)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14493,85.57, '21-Oct-97',669)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14500,30.57, '28-Jun-98',537)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14510,135.1, '05-Aug-98',1824)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14517,120.98, '13-Mar-98',153)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14534,222.47, '26-Feb-99',96)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14536,153.66, '24-Oct-97',1432)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14539,4.54, '18-Feb-98',405)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14540,102.93, '20-Feb-99',1814)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14563,48.66, '18-Jul-98',1402)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14565,220.18, '23-Jan-98',156)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14566,97.69, '29-Dec-97',71)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14573,67.3, '29-Jan-99',1107)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14578,5.6, '14-Apr-98',905)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14592,124.35, '25-Oct-97',1608)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14596,29.01, '04-Jul-97',451)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14604,153.27, '06-May-98',438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14610,19.66, '02-Jun-98',140)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14623,22.65, '27-Mar-98',1446)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14625,224.04, '27-Sep-98',83)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14635,39.19, '23-Jun-98',138)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14636,137.94, '23-Sep-98',307)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14639,12.2, '21-Jan-99',739)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14644,201.17, '22-Nov-97',723)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14646,197.82, '28-Aug-97',1085)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14648,238.56, '10-Apr-98',1906)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14650,146.05, '19-Mar-99',1991)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14657,104.59, '23-Feb-98',502)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14659,172.23, '24-Aug-98',1735)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14681,80.08, '12-Aug-98',1676)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14686,204.26, '08-Nov-98',60)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14698,235.32, '26-Mar-98',1298)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14700,23.26, '16-Jan-99',1158)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14702,17.87, '09-Dec-97',882)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14708,20.29, '20-May-98',1134)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14710,17.42, '23-Feb-99',1504)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14711,19.91, '12-Nov-98',1662)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14739,38.22, '22-Jun-98',150)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14751,94.2, '25-May-98',1822)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14755,94.22, '15-Apr-99',721)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14769,149.9, '02-Nov-97',90)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14773,133.64, '16-Mar-98',1695)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14782,126.38, '31-Mar-99',292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14789,168.02, '26-Feb-98',41)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14804,229.21, '04-Jul-97',784)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14826,117.64, '25-Nov-97',406)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14832,63.4, '07-Jan-99',1008)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14833,246.94, '04-Jun-98',1515)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14840,242.37, '17-Apr-98',1778)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14857,117.19, '02-Mar-98',1993)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14869,33.65, '26-Jan-98',1366)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14877,49.23, '19-Dec-98',112)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14898,246.98, '11-Sep-98',581)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14911,148.81, '13-Mar-98',798)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14924,250.87, '21-Jun-97',825)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14954,139.28, '13-Mar-99',453)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14959,93.74, '24-May-99',1854)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14973,175.52, '25-Mar-98',1291)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (14987,142.81, '03-Sep-98',1794)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15006,26.66, '19-May-98',1948)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15009,232.17, '11-Feb-99',1488)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15019,154.03, '26-Mar-99',592)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15023,140.89, '11-Oct-97',1280)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15032,250.13, '20-Dec-98',9)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15035,72.17, '30-May-99',247)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15049,33.81, '03-Apr-98',440)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15053,174.04, '13-Feb-98',176)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15059,222.52, '15-Mar-99',284)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15062,245.68, '05-Feb-98',1902)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15078,170.45, '21-Mar-99',139)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15082,53.23, '10-Feb-98',1436)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15083,233.77, '12-Jul-97',237)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15086,168.78, '06-Aug-97',1577)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15104,30.1, '26-Jun-97',563)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15105,151.45, '05-Dec-97',1283)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15108,233.19, '19-May-98',1397)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15115,52.3, '08-Apr-99',1086)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15121,85.79, '26-Aug-98',1456)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15169,119.03, '10-Jul-97',189)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15174,239.8, '20-Mar-99',1353)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15200,192.08, '25-Jan-99',1568)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15212,122.7, '12-Mar-98',1401)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15215,241.78, '16-May-98',965)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15227,225.46, '15-Mar-99',1938)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15231,132.51, '16-Oct-98',1268)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15236,74.01, '28-Feb-98',228)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15237,230.7, '23-Nov-97',925)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15241,15.64, '02-Jul-97',997)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15243,102.11, '27-Jun-97',1315)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15256,32.59, '02-Aug-97',1704)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15257,218.25, '04-Mar-99',1295)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15275,183.48, '10-Nov-97',581)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15276,11.98, '03-Mar-99',611)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15279,179.24, '20-May-98',1329)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15285,96.71, '20-Sep-97',1031)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15299,167.31, '06-Jun-98',1183)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15310,98.7, '26-Dec-97',98)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15316,223.91, '10-Dec-98',324)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15320,51.31, '19-Mar-98',1779)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15321,20.83, '17-Jul-98',757)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15328,63.54, '07-Oct-98',603)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15339,154.54, '13-Oct-97',1165)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15342,222.94, '28-Feb-98',1729)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15349,93.95, '29-Mar-99',127)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15362,37.27, '28-Sep-97',1730)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15370,35.47, '16-May-98',1921)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15380,130.97, '14-Mar-99',1322)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15382,123.41, '22-Oct-98',831)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15385,107.98, '26-Oct-97',455)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15405,158.84, '20-Oct-97',1873)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15408,36.3, '09-Mar-99',359)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15411,130.49, '02-Dec-97',637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15423,45.67, '22-Mar-99',1363)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15427,138.07, '10-Nov-98',885)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15443,78.47, '24-Dec-97',679)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15449,230.72, '02-Jan-99',386)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15453,242.74, '19-May-99',97)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15456,75.31, '02-Feb-98',576)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15458,10.28, '30-Aug-97',637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15461,95.53, '17-Jul-97',1923)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15463,86.62, '06-Sep-97',457)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15476,221.31, '21-Dec-97',1851)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15492,176.6, '06-Aug-98',701)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15494,34.52, '24-Jun-97',1395)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15496,56.13, '24-Jul-97',1668)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15497,150.83, '08-Jul-98',20)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15513,138.03, '03-Feb-98',552)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15525,189.61, '21-Oct-98',1664)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15540,185.7, '29-Sep-98',1559)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15544,152.94, '24-Dec-97',604)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15548,181.99, '04-Dec-98',689)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15551,121.17, '15-Jan-98',99)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15554,202.65, '31-Dec-98',1008)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15555,249.14, '01-Dec-98',1524)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15559,249.22, '06-Sep-98',1047)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15577,80.92, '02-Feb-99',952)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15583,178.34, '23-Oct-98',866)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15584,227.38, '14-Jan-99',1487)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15589,68.26, '20-Dec-97',1639)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15590,243.2, '10-Jun-98',207)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15610,183.4, '08-Apr-98',1459)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15612,114.75, '12-Oct-97',192)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15624,111.37, '08-Oct-98',1934)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15636,236.51, '16-Apr-98',154)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15641,58.38, '28-Dec-97',1587)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15647,36.74, '12-Jan-99',703)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15653,232.49, '16-Jan-99',1849)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15657,176.03, '21-Nov-97',1314)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15659,158.01, '28-Dec-98',98)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15663,166.61, '24-Jun-97',933)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15666,184.16, '26-Apr-98',1210)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15677,100.66, '17-Jan-99',1051)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15695,113.1, '18-Jul-98',968)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15714,178.07, '03-Dec-97',1549)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15724,221.14, '08-May-99',1645)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15725,45.22, '28-Apr-98',22)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15726,232.53, '13-Mar-98',1486)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15729,41.25, '13-Oct-98',1085)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15730,147.06, '03-Feb-98',911)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15745,170.25, '25-Aug-97',892)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15795,21.01, '10-Aug-98',1266)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15797,58.78, '28-Mar-99',366)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15807,195.09, '21-Jul-98',382)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15812,1.46, '12-Oct-97',941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15817,109.33, '06-Mar-98',322)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15818,9.96, '08-Mar-98',1380)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15839,72.42, '19-Feb-99',1618)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15843,249.31, '19-Jul-97',1704)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15849,34.33, '18-Jun-97',1050)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15852,35.28, '14-Mar-99',299)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15859,105.71, '22-Nov-98',941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15861,87.64, '02-Jan-98',1338)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15862,237.94, '01-Jun-99',367)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15863,131.23, '02-Oct-97',1471)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15877,21.23, '22-Jul-97',680)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15883,211.82, '20-Dec-98',1524)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15920,153.53, '16-Apr-98',720)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15921,18.13, '15-Jan-98',1612)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15924,145.89, '30-Nov-98',980)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15926,164.28, '15-Aug-98',1489)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15929,176.89, '21-Feb-98',1719)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15935,193.53, '31-Mar-98',1929)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15941,94.56, '17-Mar-98',1944)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15944,22.21, '24-May-98',1076)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15949,113.61, '03-Feb-98',713)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (15976,75.54, '03-Aug-97',1406)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16017,94.52, '07-Feb-99',791)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16023,125.55, '16-Jan-99',1721)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16035,155.55, '31-Aug-98',85)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16044,50.95, '09-Jul-98',1914)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16051,69.26, '10-Mar-99',1373)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16054,59.44, '03-Apr-98',686)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16056,54.74, '29-Dec-98',1199)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16077,60.65, '04-Aug-98',253)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16086,250.88, '02-Dec-98',1100)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16087,53.12, '29-Sep-97',356)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16097,210.88, '06-Nov-98',1292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16102,65.95, '30-Aug-97',275)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16108,84.5, '10-Oct-97',421)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16115,43.26, '06-Feb-99',1986)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16121,170.56, '08-Jan-98',693)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16134,199.07, '23-Jun-98',308)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16143,196.02, '25-Mar-99',1991)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16153,148.93, '01-Nov-97',102)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16154,145.71, '17-Apr-99',1597)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16169,86.73, '18-Jul-97',297)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16180,72.59, '26-Oct-97',281)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16182,94.92, '07-Jul-97',820)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16205,147.01, '17-Sep-98',732)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16236,70.57, '02-Jul-98',1888)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16256,169.59, '21-Apr-99',554)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16266,18.03, '24-Nov-97',1073)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16280,54.57, '12-May-98',1020)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16282,220.71, '12-Jun-98',1994)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16283,171.71, '05-Feb-98',1135)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16286,229.29, '17-Jan-98',594)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16293,59.61, '10-Aug-98',1839)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16310,21.71, '26-May-98',1891)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16313,231.44, '21-Jan-99',1777)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16314,175.48, '26-Sep-98',834)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16315,147.34, '31-Jan-98',1368)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16336,147.3, '15-Sep-97',339)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16346,29.45, '19-Aug-98',670)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16369,113.41, '12-May-98',1045)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16374,130.85, '13-Jun-98',904)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16376,166.16, '29-Jan-98',1688)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16378,33.64, '15-Feb-98',1502)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16388,213.49, '23-Apr-99',1889)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16391,86.31, '30-Jan-99',121)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16394,185.93, '22-Jun-97',416)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16395,130.42, '08-Aug-98',567)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16428,93.15, '19-Feb-99',222)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16430,8.22, '30-Jul-98',1081)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16432,20.75, '25-May-99',1081)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16435,69.47, '01-Apr-98',1065)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16440,207.63, '25-Apr-99',239)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16445,97.13, '06-Mar-99',406)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16470,72.73, '15-Oct-98',1268)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16472,217.48, '16-Dec-97',1946)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16473,222.06, '12-Mar-99',1166)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16493,108.9, '11-Aug-97',1486)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16497,99.99, '02-Oct-98',849)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16509,200.1, '29-Sep-97',1875)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16511,110.84, '21-Sep-97',1745)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16513,84.72, '04-May-99',1360)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16520,188.8, '17-Sep-98',46)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16522,242.14, '04-Sep-98',697)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16531,189.09, '12-May-98',1369)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16543,118.6, '17-Apr-99',521)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16545,169.8, '12-Nov-98',1487)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16568,206.55, '02-Jan-98',1794)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16569,222.37, '16-Oct-97',1503)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16574,77.65, '31-Aug-97',178)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16594,79.99, '30-Jul-97',593)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16614,138.71, '20-Nov-98',342)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16615,71.46, '30-Mar-98',1086)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16625,226.87, '08-Oct-98',1591)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16627,107.13, '05-Jan-99',325)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16629,172.06, '26-Nov-97',1278)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16635,50.02, '23-Nov-98',1297)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16638,152.21, '22-Feb-99',626)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16645,212.39, '05-Mar-99',1323)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16646,163.14, '29-Apr-99',1313)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16650,191.67, '01-Jul-97',1915)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16664,133.35, '19-Mar-98',1232)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16670,8.67, '12-Jan-98',469)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16683,27.83, '04-Jul-97',57)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16687,70.01, '25-Nov-97',1127)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16703,132.69, '13-Jul-98',903)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16711,58.17, '16-Sep-97',503)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16714,61.68, '09-Jul-97',1000)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16715,222.83, '28-Jul-97',85)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16718,250.84, '23-Oct-97',1632)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16720,19.55, '10-Jun-97',844)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16726,73.53, '29-Jun-97',1068)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16730,185.31, '12-Apr-98',1394)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16733,88.65, '30-Dec-97',1365)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16744,57.2, '06-Oct-97',658)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16752,110.43, '16-Jul-98',1424)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16760,249.89, '03-Aug-98',259)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16763,83.03, '01-Mar-99',1409)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16767,43.46, '12-Aug-98',1091)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16776,189.59, '01-Oct-98',1516)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16784,69.9, '26-Dec-97',1124)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16789,139.46, '06-Feb-99',514)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16791,83.5, '14-Apr-99',812)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16799,121.37, '28-Dec-97',335)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16805,201.52, '24-Apr-98',705)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16809,75.89, '06-Sep-98',1371)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16822,132.99, '08-Mar-98',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16846,63, '31-Dec-98',1942)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16847,110.78, '26-Sep-97',15)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16882,179.83, '12-Jul-97',1854)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16886,23.76, '26-Jun-97',1440)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16890,162.71, '12-Nov-97',280)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16892,38.73, '11-Mar-98',1973)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16893,58.02, '10-Mar-99',615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16910,115.83, '16-Mar-99',574)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16913,245.56, '08-Mar-99',1064)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16920,139.09, '28-Nov-98',1060)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16927,84.23, '11-Oct-97',1649)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16929,5.98, '13-May-98',80)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16935,95.68, '24-Sep-98',1820)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16936,249.75, '12-Dec-97',119)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16944,136.98, '02-Jul-98',1442)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16945,159.69, '02-Mar-99',48)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16953,137.61, '30-Jan-99',624)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16978,68.84, '02-Sep-97',204)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16981,215.16, '05-Oct-98',30)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16995,54.31, '04-Aug-98',1131)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (16997,53.9, '26-Nov-97',398)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17003,97.5, '14-Nov-97',1099)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17004,187.6, '24-Dec-98',378)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17014,98.77, '22-Apr-99',168)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17026,1.48, '10-Oct-98',1803)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17039,155.36, '25-Oct-97',989)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17051,154.34, '08-Apr-98',402)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17053,247.76, '16-Oct-97',1330)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17067,141.67, '06-Apr-98',511)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17071,198.69, '16-Aug-98',1668)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17074,177.21, '26-Mar-99',19)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17079,44.63, '06-Jan-99',734)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17082,166.03, '21-Mar-98',1815)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17089,29.21, '28-Sep-97',1359)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17097,236.88, '20-May-99',125)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17101,197.26, '22-Jan-99',330)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17106,95.42, '15-Apr-98',1950)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17110,4.07, '27-Sep-97',298)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17112,231.85, '10-Sep-98',1518)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17118,234.13, '04-Mar-99',1612)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17119,229.6, '04-Apr-98',1626)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17126,211.46, '08-Feb-98',410)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17135,30.41, '30-Nov-98',1329)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17162,140.9, '19-Jan-99',1162)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17167,69.8, '26-May-98',310)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17170,6.95, '15-Mar-98',1299)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17173,107.06, '30-Jul-97',1656)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17178,185.48, '07-Jan-98',1029)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17188,116.58, '12-Jan-98',585)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17190,128.9, '04-May-99',1473)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17192,40.07, '19-Jul-98',183)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17205,58.26, '20-Jun-98',882)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17212,59.23, '09-Mar-98',192)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17221,177.63, '11-Jul-97',1454)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17223,240.6, '22-Aug-98',1304)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17236,50.57, '19-May-98',945)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17244,18.21, '20-Dec-97',1555)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17255,123.86, '15-Nov-97',914)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17259,236.64, '16-Nov-98',152)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17267,225.74, '20-Jun-98',593)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17270,170.72, '28-Oct-97',436)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17283,207.64, '24-Jun-97',665)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17288,130.92, '28-Apr-98',704)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17294,231.15, '15-Dec-98',1035)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17295,123.55, '11-Aug-98',568)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17297,168.69, '13-Jun-98',243)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17299,120.35, '02-Sep-98',284)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17300,137.48, '29-Oct-98',1473)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17302,163.52, '06-May-98',1202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17304,77.55, '19-Feb-99',335)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17318,5.28, '08-Jan-99',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17323,171.13, '22-Nov-98',501)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17327,237.04, '25-Mar-99',1717)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17336,152.63, '10-Apr-98',811)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17350,192.77, '10-Sep-97',938)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17354,139.28, '31-Jan-98',997)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17378,107.71, '19-Jan-99',1389)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17384,158.51, '06-Apr-98',816)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17389,122.57, '20-Jan-98',850)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17398,166.67, '09-Jul-98',1977)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17403,104.81, '16-Nov-98',1032)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17406,169.44, '22-Jul-98',1782)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17408,199.38, '28-Sep-98',1483)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17423,68.62, '11-Jun-98',1764)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17439,91.77, '07-Mar-99',1277)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17446,24.97, '29-Apr-98',570)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17456,3.2, '09-Aug-97',1802)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17459,9.45, '30-Jul-98',1493)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17467,87.71, '06-Jun-97',34)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17468,35.34, '18-Apr-98',1485)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17472,205.27, '28-May-99',1469)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17474,194.34, '01-Sep-98',1057)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17480,125.84, '14-May-98',517)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17482,126.33, '22-Jun-97',809)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17497,214.41, '19-May-99',1946)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17499,108.82, '20-Apr-99',560)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17503,94.44, '05-Sep-97',410)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17532,148.94, '04-May-99',520)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17539,148.15, '05-May-98',69)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17547,49.05, '04-May-99',756)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17552,33.77, '17-Mar-98',259)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17564,163.24, '20-Aug-97',594)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17574,182.97, '04-Apr-99',1524)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17580,66.63, '23-Sep-98',770)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17586,52.33, '25-Apr-98',438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17610,4.7, '27-Jun-98',1559)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17615,187.3, '28-Dec-98',1567)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17626,220.23, '31-Aug-97',898)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17628,110.83, '14-Oct-97',1854)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17634,244.88, '22-Jan-98',426)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17638,33.21, '01-May-99',478)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17641,142.73, '19-Feb-98',305)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17667,80.37, '18-Mar-98',1178)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17673,6.47, '03-Aug-97',623)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17674,90.13, '08-Aug-98',410)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17676,216.26, '04-Jan-98',24)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17707,145.65, '09-Jan-98',17)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17711,224.41, '29-Apr-98',1321)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17712,30.69, '28-Nov-98',108)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17718,242.02, '16-May-99',554)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17732,96.91, '05-Mar-99',1679)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17734,211.25, '14-Sep-97',754)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17736,236.32, '12-Oct-98',1049)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17739,122.28, '05-May-99',1920)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17742,185.88, '26-Oct-98',362)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17747,43.2, '13-Oct-97',237)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17790,201.77, '14-Mar-99',16)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17821,64.39, '26-Sep-97',1153)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17828,86.46, '20-Mar-98',1534)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17847,212.05, '10-Sep-98',1231)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17854,132.06, '24-May-98',1167)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17857,52.36, '21-Oct-97',889)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17863,8.43, '13-May-98',898)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17865,62.4, '22-Apr-99',7)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17880,138.4, '26-May-98',1942)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17883,100.14, '20-May-98',193)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17884,124.47, '16-Jun-98',1742)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17886,40.89, '23-Feb-99',1362)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17900,181.02, '22-Oct-97',1273)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17901,81.69, '30-Nov-98',1826)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17903,5.15, '08-Feb-99',537)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17905,230.89, '20-Apr-98',574)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17912,90.94, '11-Nov-97',1598)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17922,172.78, '19-Jun-98',545)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17926,165.18, '12-Mar-98',1951)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17933,91.18, '23-Aug-97',1447)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17935,5, '11-Jan-98',924)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17945,181.22, '15-Jan-98',530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17948,184.7, '22-Aug-97',425)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17950,242.92, '13-Dec-98',990)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17951,98.32, '30-Jul-98',905)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17952,64.6, '11-Mar-99',1808)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17956,102.18, '11-Jul-97',1536)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17957,61.86, '17-Mar-99',499)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17959,179.93, '05-May-99',1546)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17965,109.56, '08-May-98',1128)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17979,217.78, '02-Jul-98',482)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17980,173.31, '03-Jan-98',323)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17982,36.12, '02-Jan-98',423)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17989,226.48, '09-Jul-97',1161)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17990,177.47, '03-Jul-98',319)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17991,233.13, '14-Oct-98',629)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17997,136.83, '12-Jan-99',866)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (17998,200.51, '27-Oct-98',1919)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18004,41.13, '14-Jul-98',255)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18007,119.43, '20-Mar-98',896)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18011,128.2, '29-Dec-97',1946)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18015,132.61, '30-Apr-98',1913)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18016,87.28, '21-Oct-97',1911)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18023,77.86, '15-Jun-97',1646)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18025,215.07, '02-Jan-99',481)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18028,135.48, '14-Apr-99',865)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18029,172, '09-Sep-97',664)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18035,8.79, '03-Nov-97',1852)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18041,19.48, '28-May-98',1452)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18044,67.53, '20-Apr-98',1232)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18052,136.2, '14-Jun-98',1684)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18057,184.54, '05-Mar-98',1501)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18060,75.67, '12-Oct-97',441)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18061,217.06, '30-Apr-98',520)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18074,40.56, '21-Mar-99',1001)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18081,107.42, '13-Aug-98',1485)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18093,21.02, '09-Dec-98',434)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18098,178.45, '25-May-99',858)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18110,80.49, '30-Mar-99',615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18115,12.12, '20-Apr-99',1189)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18119,99.15, '30-Oct-98',1298)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18120,83.88, '02-Aug-98',1378)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18124,123.05, '01-May-98',706)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18125,83.88, '12-Jul-97',407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18147,249.62, '04-Apr-99',1496)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18150,106.96, '21-Jul-98',546)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18152,171.8, '08-Sep-97',1943)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18156,230.24, '21-May-98',1395)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18157,154.62, '03-Feb-98',439)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18162,102.82, '11-Aug-98',1965)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18166,100.9, '28-Oct-98',907)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18178,129.1, '16-Apr-99',52)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18189,234.27, '20-Aug-98',529)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18202,225.25, '30-Sep-98',461)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18221,73.8, '26-Feb-99',678)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18238,15.17, '06-Feb-98',1746)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18253,171.23, '25-Aug-97',886)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18259,28, '28-Jul-98',1389)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18261,224.12, '12-Aug-97',712)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18268,75.77, '25-Aug-98',1104)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18282,85.49, '20-Mar-99',717)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18285,27.56, '13-Feb-98',1152)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18288,179.48, '10-Aug-98',631)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18290,242.04, '03-Apr-98',1132)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18293,223.73, '14-Sep-97',1930)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18299,191.61, '15-Feb-99',880)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18302,130.26, '20-Feb-98',787)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18303,204.4, '07-Jun-98',913)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18306,69.74, '19-Feb-98',1211)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18317,142.78, '27-Jul-98',1476)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18330,50.25, '24-Nov-97',859)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18349,16.89, '30-Dec-98',1860)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18350,21.65, '09-Mar-98',1277)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18370,185.79, '03-Mar-98',267)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18401,101.51, '07-Nov-98',351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18418,24.57, '11-Jul-97',1237)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18419,47.53, '18-Jun-97',137)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18423,161, '02-Feb-98',1253)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18433,142.11, '30-Jun-98',185)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18447,191.39, '13-Aug-97',84)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18450,218.47, '05-Nov-97',4)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18453,225.71, '22-Oct-98',1400)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18461,237.34, '18-Jan-99',1787)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18463,104.86, '22-Dec-97',533)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18483,198.43, '27-Nov-98',1922)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18491,97.85, '28-Jul-97',931)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18510,167.53, '29-Apr-98',1283)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18511,216.79, '24-May-99',1033)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18522,145.47, '04-Sep-98',1339)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18532,195.64, '14-Jan-98',23)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18536,201.16, '03-May-98',163)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18543,102.02, '15-Aug-98',658)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18551,188.07, '15-May-98',1336)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18556,236.13, '08-Apr-99',1944)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18565,86.99, '26-Feb-98',589)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18596,41.44, '17-Jun-98',610)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18600,194.2, '13-Jan-99',61)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18608,54.74, '28-Aug-97',1208)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18610,53.57, '24-Jun-98',1277)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18614,242.36, '08-Mar-98',1493)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18618,85.87, '08-Sep-98',26)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18620,135.3, '20-Mar-98',1213)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18621,80.24, '28-Nov-97',1858)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18624,133.28, '13-Oct-97',54)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18657,179.39, '08-May-99',664)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18662,179.72, '10-Oct-97',613)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18676,177.5, '12-Apr-99',619)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18689,41.15, '22-Oct-98',966)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18699,109.99, '12-Sep-97',1882)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18709,136.59, '02-Oct-97',599)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18735,128.81, '30-Sep-98',1515)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18736,13.14, '14-Feb-99',829)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18750,162.04, '16-Oct-97',641)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18787,29.28, '12-Dec-98',1178)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18813,81.83, '08-Oct-97',876)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18814,58.75, '31-Jan-99',1558)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18818,233.39, '12-Oct-97',224)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18821,243.92, '11-Jun-98',1428)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18826,78.43, '26-Feb-98',1060)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18831,245.96, '13-Nov-97',1797)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18855,73.05, '08-Jun-97',1774)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18858,99.41, '09-Apr-98',339)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18860,173.41, '26-Dec-97',441)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18861,193.39, '09-Aug-98',961)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18864,112.86, '18-Mar-98',1388)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18868,136.85, '02-Oct-98',1853)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18874,165.72, '07-Mar-99',352)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18882,131.07, '25-Jan-99',1156)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18890,19.59, '27-Dec-97',615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18891,80.44, '22-Aug-98',703)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18897,224.11, '24-May-99',143)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18922,89.98, '23-Apr-99',1886)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18942,141.65, '18-Nov-98',345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18953,23.32, '02-Jun-98',1363)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18963,213.52, '12-May-98',1215)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18970,36.96, '15-Jan-98',1911)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18975,111.4, '17-May-99',162)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18976,157.74, '11-Oct-97',1592)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18979,37.31, '15-Feb-99',1902)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18983,13.17, '13-Dec-97',1271)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18984,75.34, '30-Sep-98',625)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18985,185.48, '29-May-98',333)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18996,138.73, '07-Oct-98',97)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (18998,209.48, '02-May-98',958)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19003,227.92, '23-Aug-98',1380)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19022,134.55, '30-Oct-97',648)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19024,83.09, '25-Dec-98',1061)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19027,100.58, '04-Jul-98',1241)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19029,129.7, '29-Apr-99',1121)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19041,226.04, '15-Apr-98',663)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19050,111.62, '08-Aug-98',1932)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19052,83.35, '03-Aug-97',1353)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19058,40.91, '03-Apr-98',824)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19060,98.16, '19-Nov-98',1446)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19070,115.86, '21-Apr-98',68)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19073,193.54, '18-Jun-97',1669)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19075,112.46, '08-Jan-98',243)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19102,76.06, '30-Nov-98',615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19109,61.51, '22-Sep-97',1230)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19111,94.61, '01-Feb-98',1705)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19114,144.68, '10-Nov-98',432)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19115,129.32, '19-Apr-99',430)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19121,59.8, '13-Feb-98',944)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19122,178.7, '23-Jul-97',1696)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19125,160.12, '03-Nov-98',1671)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19135,90.91, '15-Sep-98',309)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19137,91.96, '31-Mar-99',106)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19149,220.49, '30-Dec-97',484)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19151,28.09, '01-Jan-99',920)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19159,195.16, '15-Mar-99',469)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19162,61.01, '03-Jan-99',1921)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19166,134.82, '09-Jun-98',945)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19174,1.47, '31-Dec-98',681)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19179,209.06, '04-Aug-97',76)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19190,136.72, '23-Nov-98',1980)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19191,188.1, '21-Feb-98',812)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19193,115.97, '03-May-99',1158)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19194,213.42, '09-Jun-97',409)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19195,168.73, '30-Dec-98',1665)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19196,237.65, '13-Jan-98',1428)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19198,230.39, '09-May-99',730)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19208,10.96, '16-Apr-98',6)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19216,197.58, '16-Sep-98',1665)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19228,147.21, '13-Aug-98',799)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19240,116.66, '07-May-99',688)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19244,247.24, '06-Nov-97',624)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19250,249.76, '24-May-99',395)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19254,140.13, '24-Mar-99',289)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19258,215.84, '09-Feb-99',374)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19261,148.46, '01-Jul-97',1789)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19266,66.56, '20-Apr-99',415)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19269,59.54, '03-Nov-98',671)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19279,12.69, '26-May-99',710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19290,66.86, '07-May-98',1850)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19292,133.33, '01-May-99',654)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19293,218.21, '25-Sep-98',151)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19296,63.64, '01-Jun-99',704)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19300,41.92, '28-Nov-97',37)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19311,108.38, '23-Jan-98',1741)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19316,165.17, '01-Jun-99',1685)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19320,226.28, '25-May-98',1360)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19324,209.89, '18-Jun-97',1138)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19328,228.63, '24-Apr-98',1781)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19334,9.01, '03-Nov-98',1435)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19337,170.77, '02-Oct-97',367)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19351,3.58, '31-Mar-99',1531)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19360,12.2, '23-Jul-97',1979)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19369,188.66, '18-Jun-97',40)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19371,159.77, '03-Dec-97',420)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19373,121.88, '19-Mar-98',61)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19378,210.13, '07-Nov-98',31)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19380,239.24, '24-Jul-98',456)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19392,164.36, '28-Feb-99',1299)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19396,89.78, '17-Feb-98',1943)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19407,136.6, '02-Jun-99',1437)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19408,65.03, '03-Feb-99',629)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19423,150.86, '05-Mar-98',891)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19435,129.83, '05-Nov-97',1004)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19441,97.36, '28-Mar-98',104)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19448,14.73, '25-Aug-97',1508)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19452,72.44, '08-Jul-98',1785)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19479,176.92, '21-Oct-97',911)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19482,56.34, '28-May-99',1627)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19489,5.11, '11-Feb-98',1327)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19498,141.43, '05-Dec-98',102)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19506,62.82, '07-Dec-97',605)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19515,107.98, '17-Sep-97',1828)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19526,36.05, '18-Oct-97',1460)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19534,101.57, '02-May-99',20)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19554,200.99, '27-Oct-97',241)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19555,207.6, '07-Aug-98',1733)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19568,79.74, '29-Sep-97',595)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19571,10.63, '30-Jan-98',619)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19579,125.47, '05-Mar-98',1064)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19583,182.73, '15-May-99',1390)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19598,5.17, '07-Aug-98',988)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19599,150.55, '31-Mar-98',536)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19607,239.56, '27-Dec-97',1228)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19611,163.36, '30-Dec-97',1707)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19613,159.94, '11-Oct-97',1991)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19616,35.74, '16-Mar-98',1925)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19617,44.05, '14-May-98',1483)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19618,221.2, '11-Oct-98',1993)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19624,107.49, '07-Jun-97',314)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19645,76.54, '02-Oct-98',997)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19646,83.33, '25-Oct-98',1053)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19676,225.95, '23-Feb-99',954)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19677,2.02, '14-Sep-97',62)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19680,97.94, '21-May-99',623)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19686,74.22, '22-Mar-98',749)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19688,134.11, '13-Jan-98',447)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19690,83.48, '12-Jun-97',1226)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19697,210.81, '23-Aug-98',650)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19700,196.53, '25-May-99',1575)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19711,78.38, '30-Dec-97',594)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19714,185.31, '21-Sep-98',841)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19729,76.52, '02-Feb-98',982)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19739,90.65, '18-Jul-98',1116)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19757,168.53, '26-Jun-98',1731)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19759,33.21, '03-Mar-99',1709)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19760,246.59, '02-May-99',1551)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19768,131.1, '24-May-99',357)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19771,140.39, '31-Dec-98',178)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19772,125.57, '05-Oct-97',1878)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19794,156.72, '25-Jul-98',167)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19800,180.49, '07-Aug-98',658)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19810,119.78, '30-Jan-98',1154)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19819,65.83, '01-Jun-98',1926)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19833,91.3, '04-Mar-99',474)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19835,49.19, '01-Feb-99',351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19839,115.35, '03-Apr-98',736)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19847,115.93, '27-Mar-99',834)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19858,168.03, '17-Jul-97',1860)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19859,203.48, '13-Nov-98',418)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19867,157.24, '20-Sep-98',1463)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19886,64.01, '29-Apr-98',308)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19930,200.78, '05-Jun-99',558)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19932,239.59, '25-Oct-97',841)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19934,190.59, '31-May-98',696)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19943,234.06, '08-May-98',1131)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19950,130.67, '28-Oct-97',698)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19952,167.41, '29-Jul-97',866)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19954,119.3, '09-Jul-97',620)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19967,43.62, '18-Feb-98',1815)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19969,220.05, '13-Nov-97',1121)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19971,151.84, '24-Sep-97',1439)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19972,20.19, '29-May-98',1016)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19975,20.48, '03-Nov-97',97)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19982,231.19, '23-Sep-98',511)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (19994,76.73, '08-Oct-98',1343)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20000,249.88, '13-May-98',1375)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20003,85.97, '29-Oct-97',1393)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20007,97.41, '24-Jul-98',996)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20037,109.39, '01-Nov-98',377)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20043,179.91, '25-Jul-97',423)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20045,159.05, '20-Dec-97',1020)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20050,39.94, '01-Dec-98',845)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20056,76.55, '02-Dec-98',1424)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20065,38.55, '15-Apr-98',1912)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20076,31.22, '22-Nov-97',1840)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20081,59.84, '10-Jun-97',1001)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20087,244.28, '21-Jun-98',455)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20088,63.67, '16-Apr-98',1315)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20094,222.84, '09-Mar-98',1610)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20101,217.3, '23-May-99',1876)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20103,66.34, '27-Jan-98',297)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20104,148.64, '25-Sep-98',1868)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20112,225.59, '10-Feb-98',1125)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20115,180.57, '20-Aug-97',56)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20149,86.27, '14-Nov-97',341)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20153,147.64, '29-Jul-98',1421)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20162,89.64, '19-Jan-98',1501)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20173,106.1, '20-Jun-98',561)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20177,188.59, '13-May-98',532)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20180,6.96, '25-Apr-98',1583)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20185,107.22, '08-Jun-98',713)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20197,6.62, '19-Jul-97',814)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20198,147.98, '11-Jun-97',817)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20199,145.94, '17-Aug-98',2000)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20201,36.13, '03-Mar-98',849)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20231,2.51, '06-Dec-97',1434)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20240,149.41, '01-Sep-97',512)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20243,129.59, '16-Jun-97',1281)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20247,164.49, '18-Apr-99',1877)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20254,51.52, '02-Jul-98',1177)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20257,98.43, '28-Dec-97',1326)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20282,37.24, '01-Feb-99',1681)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20288,139.99, '14-Sep-98',406)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20292,25.89, '12-Oct-97',787)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20294,184.71, '12-Mar-98',155)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20301,194.46, '03-Aug-98',1039)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20309,137.66, '06-Mar-98',1804)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20311,163.21, '22-Oct-97',981)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20316,190.89, '04-Jan-98',203)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20345,102.79, '21-Nov-97',1801)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20355,134.26, '03-Nov-98',1013)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20364,60.17, '13-Jul-97',131)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20368,213.54, '08-Nov-98',836)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20380,211.59, '19-Aug-98',292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20383,231.43, '13-Apr-98',1483)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20402,211.37, '06-Jan-99',870)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20415,209.55, '07-Apr-99',1724)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20419,191.27, '13-Mar-99',513)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20420,185.87, '17-May-99',86)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20424,238.33, '18-Jul-98',541)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20426,149.9, '22-Nov-97',232)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20430,145.38, '10-Jan-98',1245)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20434,168.11, '20-Aug-98',1394)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20479,159.86, '27-Nov-97',505)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20485,101.91, '05-Oct-98',791)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20488,174.05, '22-Sep-98',1728)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20500,128.25, '14-Jan-98',476)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20502,209.63, '31-May-99',571)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20505,5.46, '05-Apr-98',605)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20506,96.11, '17-Feb-98',1059)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20522,72.51, '13-Apr-99',472)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20525,60.27, '24-Nov-98',382)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20533,128.98, '27-Oct-98',312)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20548,236.17, '04-Aug-98',323)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20555,129.14, '12-Jun-98',1341)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20556,168.74, '11-Apr-99',691)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20564,71.89, '15-Mar-98',1707)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20580,201.07, '09-Jan-99',60)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20581,207.43, '28-Jan-98',1839)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20586,101.62, '18-Nov-98',612)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20598,37.88, '20-Jan-98',174)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20600,184.85, '19-Jan-98',35)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20601,202.4, '01-Jan-99',590)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20611,76.77, '14-Sep-97',417)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20629,24.03, '11-Jan-98',1622)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20642,81.12, '26-Apr-99',1894)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20648,20.79, '30-Oct-97',567)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20667,188.67, '07-Sep-98',1431)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20669,72.84, '06-Aug-97',137)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20675,24.09, '07-Sep-97',854)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20676,178.77, '07-Jun-97',1497)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20679,199.07, '24-Dec-98',1549)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20682,15.33, '17-Apr-98',793)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20687,118.88, '04-Jan-99',274)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20688,146.12, '02-Jun-98',151)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20691,122.59, '20-May-98',1703)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20699,212.73, '18-Mar-99',317)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20701,29.95, '19-Oct-97',1077)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20710,219.73, '01-Sep-98',884)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20715,169.42, '14-Aug-98',1891)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20718,41.17, '08-Jul-97',1151)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20743,153.32, '11-Aug-97',359)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20744,145.22, '06-Jul-97',1323)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20751,249.01, '03-Jul-98',1927)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20755,83.76, '31-Dec-98',558)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20759,136.46, '14-Oct-98',1271)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20761,206.86, '07-Jun-98',1737)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20763,68.16, '08-Jun-97',139)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20764,14.68, '19-Nov-97',1998)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20769,223.55, '28-Sep-97',75)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20774,105.55, '25-Aug-98',72)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20783,187.61, '04-Aug-97',1903)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20790,37.23, '31-Jan-99',23)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20795,150.53, '20-Feb-99',1075)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20800,76.38, '15-Aug-97',1236)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20820,68.74, '02-Dec-98',1478)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20840,208.38, '12-May-99',1669)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20847,58.86, '12-Jun-98',158)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20850,88.01, '01-Jun-98',1354)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20851,106.54, '15-May-99',217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20865,138.88, '25-Nov-97',1511)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20870,86.96, '19-Nov-98',700)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20876,50.92, '23-Apr-98',1312)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20882,137.65, '16-Jun-98',823)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20884,124.02, '10-Feb-98',131)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20886,211.32, '20-Jun-97',270)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20894,98.49, '23-Feb-99',969)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20903,240.53, '28-Aug-98',1225)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20906,210.57, '22-Dec-98',1079)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20921,117.43, '11-Oct-98',599)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20923,3.7, '22-Mar-99',1656)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20928,162.25, '01-Jun-99',37)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20936,210.29, '16-May-99',1605)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20945,67.49, '22-Feb-98',766)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20953,38.48, '28-Jan-98',1298)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20955,97.92, '22-Jul-97',1010)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20960,104.93, '29-Mar-98',1290)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20983,190.76, '05-Jun-98',1035)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20984,188.52, '08-Jun-97',1419)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (20992,164.18, '03-Jun-99',1664)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21002,106.5, '08-Jun-98',1143)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21008,144.9, '21-Feb-99',1522)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21012,153.57, '21-Sep-98',1891)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21018,116.5, '29-Jun-97',775)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21019,94.66, '30-May-99',1769)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21024,92.02, '13-Dec-98',1159)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21027,134.64, '13-Jul-98',884)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21029,41.85, '05-Jun-98',1198)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21031,180.66, '03-Mar-99',722)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21032,151.93, '17-Jul-97',1130)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21038,197.57, '28-Jun-97',1926)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21048,10.61, '02-Dec-97',1845)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21053,141.23, '23-Jun-98',283)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21059,77.67, '09-Aug-98',898)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21066,118.82, '30-Jan-98',1166)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21078,155.35, '24-Dec-97',1409)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21085,204.08, '25-May-98',1926)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21090,147.51, '18-Nov-98',1968)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21099,73.79, '08-Dec-97',938)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21126,193.49, '23-Apr-99',1203)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21128,30.31, '18-Nov-97',246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21151,241.75, '19-May-98',926)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21153,231.68, '12-Feb-98',1481)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21159,11.1, '23-Apr-99',1156)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21161,185.38, '04-Oct-97',233)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21162,5.84, '24-Jul-97',1172)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21163,117.96, '30-Apr-98',350)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21166,192.53, '09-Jul-97',126)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21182,87.16, '23-May-98',1491)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21184,5.94, '15-Nov-97',452)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21188,101.32, '21-Jan-99',569)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21195,168.7, '11-Feb-98',1081)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21197,243.71, '08-Dec-98',638)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21198,96.41, '14-Apr-98',291)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21204,243.36, '08-Mar-99',664)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21214,34.52, '14-Sep-97',279)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21217,147.89, '07-Nov-97',36)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21222,42.48, '21-Nov-97',952)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21234,41.29, '08-Aug-98',731)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21235,177.91, '30-Mar-98',378)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21250,241.51, '26-Feb-98',1630)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21257,142.21, '22-Oct-97',1947)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21271,107.42, '12-Apr-98',665)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21272,46.02, '13-Mar-99',1900)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21273,46.41, '11-Apr-98',252)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21284,127.45, '01-Jan-98',658)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21288,192.26, '21-Feb-98',1193)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21309,140.05, '10-Mar-99',68)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21323,148.35, '10-Jul-98',842)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21324,136.55, '26-Oct-98',1525)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21330,142.77, '09-Mar-98',487)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21336,244.59, '04-Jan-98',1506)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21339,230.55, '07-Apr-98',1581)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21348,47.36, '23-Nov-98',73)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21353,115.84, '23-Feb-99',438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21365,62.41, '20-Apr-99',1692)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21367,134.66, '21-Aug-97',346)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21375,26.29, '27-Jan-98',558)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21386,139.83, '30-May-98',1047)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21393,105.45, '13-Dec-97',1488)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21397,39.29, '12-Feb-98',1094)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21408,197.48, '25-Sep-98',1547)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21411,223.8, '12-May-99',1162)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21414,87.3, '20-Oct-98',1095)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21419,147.42, '16-Dec-98',340)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21426,212.61, '08-Mar-99',1708)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21451,18.31, '22-Jul-98',1540)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21474,48.42, '18-Mar-99',993)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21475,48.6, '01-Sep-97',779)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21480,60.69, '09-Nov-97',1827)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21482,9.07, '09-Dec-97',936)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21490,214.04, '08-Jul-97',4)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21510,33.14, '17-Feb-99',1488)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21520,120.82, '15-Aug-98',945)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21530,135.89, '10-Nov-98',492)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21531,83.41, '08-Nov-98',1280)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21532,167.28, '09-Apr-98',723)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21533,6.86, '30-Oct-98',1081)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21542,105.99, '09-Feb-98',1112)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21546,2.6, '19-Aug-97',842)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21550,23.28, '15-May-99',353)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21553,41.73, '25-Mar-98',511)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21566,189.65, '06-Nov-98',194)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21633,52.36, '03-Aug-97',1978)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21634,106.85, '30-Jul-98',421)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21639,82.02, '12-Aug-97',822)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21642,114.94, '09-Mar-99',671)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21644,128.41, '23-Mar-98',1208)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21649,7.44, '02-Dec-98',628)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21650,146.99, '22-Nov-97',1921)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21651,104.35, '03-Oct-98',1636)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21662,45.56, '30-Sep-98',1657)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21664,220.01, '19-May-99',1493)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21666,191.05, '09-Nov-97',1795)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21667,235.46, '13-Jan-98',1035)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21672,182.08, '25-Mar-98',819)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21677,139.98, '17-Mar-99',1641)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21692,88.61, '03-Jul-97',1737)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21704,12.1, '11-May-99',1325)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21720,112.89, '05-Jun-98',311)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21724,89.07, '05-Jul-98',53)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21730,185.59, '21-Mar-98',31)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21731,201.58, '20-Dec-97',1589)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21734,115.24, '11-Feb-99',1020)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21754,235.28, '17-Feb-99',1803)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21758,58.58, '23-Jul-97',834)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21760,53.94, '04-Mar-99',1971)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21775,122.79, '04-Sep-97',246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21778,181.47, '26-Oct-97',385)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21783,79.39, '08-Oct-97',59)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21809,45.5, '06-Apr-98',1995)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21819,159.66, '13-Apr-99',1972)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21826,232.69, '10-Apr-99',1106)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21836,95.67, '06-May-98',831)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21863,32.58, '13-Nov-98',1553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21865,56.17, '20-Jan-98',1296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21866,186.66, '13-Mar-98',137)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21876,25, '17-Mar-98',325)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21878,144.65, '23-Aug-98',1515)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21888,69.66, '25-Feb-99',303)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21892,45.48, '27-Dec-97',1284)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21899,234.64, '21-Mar-98',116)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21913,197.63, '23-Aug-97',740)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21924,97.33, '09-Mar-98',1607)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21958,205.23, '28-Jan-99',610)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21982,90.29, '04-Sep-97',29)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21985,131.52, '09-May-99',972)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21998,62, '05-May-98',1906)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (21999,122.75, '18-Oct-98',1313)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22005,16, '13-Mar-99',862)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22012,106.16, '04-Nov-98',1596)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22013,100.77, '28-Nov-97',62)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22029,137.62, '09-Jul-97',1755)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22032,96.73, '06-Feb-98',368)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22034,173.37, '19-Jul-98',126)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22037,168.77, '17-Jul-97',1435)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22042,155.27, '22-Mar-98',208)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22043,72.17, '20-Apr-98',791)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22048,184.16, '15-Jul-97',943)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22051,183.31, '28-Mar-99',375)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22052,113.05, '01-Jul-97',1609)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22055,14.9, '11-Oct-97',447)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22070,4.69, '17-Jan-98',427)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22080,12.21, '01-Sep-98',1435)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22081,173.33, '02-Nov-97',1587)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22084,69.06, '15-Dec-97',1288)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22093,183.28, '28-Nov-98',1174)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22112,208.83, '24-Feb-98',1047)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22117,166.8, '09-Jun-98',313)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22119,162.83, '23-Nov-97',547)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22147,39.08, '21-May-99',591)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22153,90.67, '05-Jun-98',871)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22157,13.51, '16-Mar-98',827)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22159,144.73, '05-Sep-98',84)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22162,131.79, '08-May-99',1403)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22166,108.63, '14-Aug-98',205)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22172,202.38, '12-Dec-98',442)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22182,55.12, '05-Jan-99',259)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22202,146.51, '08-Feb-99',851)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22221,129.32, '29-May-99',715)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22224,105.49, '09-Feb-98',269)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22225,32.97, '11-Feb-99',1155)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22226,6.75, '12-May-99',518)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22231,87.21, '27-Aug-98',583)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22232,154.01, '23-Jan-99',1844)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22235,211.62, '18-Oct-98',725)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22246,187.99, '03-May-98',1088)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22264,177.71, '05-May-98',1969)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22265,60.39, '25-Aug-98',1623)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22271,34.04, '12-Nov-97',1548)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22272,209.7, '03-Nov-98',925)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22273,181.84, '06-Sep-97',650)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22285,30.71, '07-Jul-98',837)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22321,240.78, '28-Oct-97',1214)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22325,61.48, '17-Aug-98',1735)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22348,53.8, '14-Nov-97',137)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22349,217.68, '11-Jul-97',1193)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22358,161.34, '04-Jul-97',407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22385,235.04, '08-May-99',295)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22405,6.13, '29-Dec-98',1932)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22413,188.23, '12-Jun-98',1784)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22419,35.62, '24-Jan-99',551)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22441,23.39, '27-May-98',1442)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22444,85.84, '21-Oct-98',271)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22454,111.12, '27-Oct-97',829)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22465,5.56, '07-Sep-98',1821)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22479,67.17, '08-Jun-97',145)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22480,233.76, '23-Jun-98',918)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22505,84.86, '30-Sep-97',964)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22515,54.44, '11-Oct-98',1851)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22520,112.3, '23-Mar-99',1329)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22522,85.52, '27-Dec-98',1846)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22523,90.23, '30-Jan-99',1768)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22525,129.04, '31-Jul-98',1507)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22526,76.81, '21-Dec-98',1991)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22552,74.75, '31-Aug-98',1044)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22555,61.92, '29-Sep-97',302)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22569,180.91, '02-Jan-99',719)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22570,183.68, '25-Dec-97',1211)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22580,46.21, '06-Dec-98',1568)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22599,1.54, '25-Feb-98',330)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22611,121.69, '12-Jan-99',1803)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22623,224.13, '02-Mar-98',443)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22628,206.5, '04-Jan-98',96)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22632,103.34, '06-Dec-97',1173)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22633,62.54, '01-Mar-98',710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22639,218.62, '23-Apr-98',1435)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22644,225.02, '17-Oct-97',1041)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22650,94.32, '26-Dec-98',134)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22651,91.62, '05-Feb-98',6)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22655,4.62, '04-Jan-99',1035)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22672,168.4, '06-Jan-98',1991)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22674,115.6, '22-Oct-98',885)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22689,168.31, '13-Nov-97',1479)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22690,51.98, '25-May-98',1696)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22692,52.31, '07-Jun-98',683)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22693,183.42, '26-Aug-98',796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22696,95.38, '18-Aug-98',1072)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22697,228.74, '26-Mar-99',934)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22707,236.37, '28-Oct-97',408)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22718,90, '18-Dec-97',1928)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22719,59.66, '16-May-99',520)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22721,12.28, '16-May-99',1665)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22726,135.52, '21-Sep-98',1180)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22731,206.12, '06-Apr-98',83)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22738,22.18, '25-Jan-98',1875)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22758,10.74, '23-Jul-97',1155)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22761,180.52, '15-Mar-98',1393)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22765,159.19, '31-Oct-98',1722)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22773,100.42, '04-Feb-99',802)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22788,51.75, '13-Jun-97',597)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22833,185.07, '22-May-99',432)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22863,160.28, '01-Apr-98',452)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22864,106, '18-Mar-98',1423)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22866,127.82, '21-Oct-97',807)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22897,211.95, '28-Feb-98',1389)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22911,187.24, '23-Nov-97',380)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22919,148.29, '25-Apr-98',1885)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22940,136.62, '31-Jul-98',1041)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22951,158.02, '15-Nov-97',675)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22954,71.74, '05-Sep-97',1819)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22975,133.59, '18-Nov-97',803)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22983,208.28, '31-Aug-98',1399)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22993,161.87, '23-Nov-98',1388)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (22994,123.77, '04-Mar-99',678)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23007,229.29, '21-Mar-99',164)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23011,152.22, '22-Dec-98',1890)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23034,214.59, '23-Sep-98',625)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23035,188.67, '25-Nov-98',342)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23048,191.98, '06-Feb-99',1423)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23049,178.45, '02-Sep-98',734)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23054,96.55, '02-Apr-98',449)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23065,79.7, '24-Jun-98',680)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23072,27.3, '14-Feb-98',727)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23073,4.5, '15-May-99',72)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23079,98.15, '22-May-98',172)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23080,227.52, '05-May-98',1636)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23084,99.2, '14-Nov-98',1513)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23093,5.58, '25-Nov-98',738)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23095,229.5, '31-Oct-97',410)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23105,204.2, '04-Aug-98',961)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23122,10.03, '28-Feb-98',1486)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23130,106.57, '13-Mar-98',659)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23131,82, '13-Dec-98',807)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23135,12.3, '25-Oct-98',1946)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23150,202.46, '27-Oct-98',242)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23152,114.69, '27-Mar-98',1245)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23175,98.7, '26-Feb-99',1348)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23179,94.39, '20-Oct-98',1472)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23186,100.41, '07-Apr-98',366)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23189,10.32, '26-Jun-98',1112)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23191,102.58, '09-Dec-98',736)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23207,179.58, '12-Jul-98',607)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23210,116.01, '08-Apr-98',1911)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23211,105.61, '12-May-99',269)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23212,124.81, '27-Feb-98',1573)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23235,36.07, '25-Jan-98',519)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23238,67.96, '27-Apr-98',311)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23239,49.99, '17-Feb-99',1799)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23244,82.79, '10-Aug-98',1266)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23245,16.93, '15-Nov-97',792)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23264,203.05, '07-Sep-97',1741)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23270,83.5, '13-Oct-98',1223)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23293,16.83, '04-May-98',1799)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23300,5.92, '28-Apr-98',1544)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23301,173.97, '10-Sep-97',651)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23307,4.88, '26-May-99',764)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23308,165.76, '24-Jan-99',1766)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23320,90.98, '29-Sep-98',530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23335,150.33, '17-Apr-98',1979)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23336,17.85, '10-Dec-98',1699)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23337,77.59, '27-Sep-98',1070)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23352,130.48, '22-Dec-97',773)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23356,217.85, '08-Oct-98',1239)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23359,173.32, '02-Nov-98',758)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23368,242.13, '07-May-98',1502)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23370,63.79, '07-Dec-97',592)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23374,199.59, '13-May-98',872)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23393,209.05, '15-Jan-99',346)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23395,30.91, '12-May-98',762)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23396,52.79, '17-Nov-97',110)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23410,184.99, '30-Jul-98',1575)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23427,61.88, '14-Mar-98',1361)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23428,96.75, '06-Feb-98',374)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23435,54.69, '13-Aug-97',993)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23438,212.88, '02-Jan-98',910)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23451,144.78, '04-May-99',1791)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23453,245.1, '04-Jul-97',1108)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23456,132.76, '26-Nov-97',1115)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23459,70.13, '07-Oct-98',144)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23461,53.42, '15-Jun-98',971)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23467,135.06, '27-Dec-97',259)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23472,99.64, '29-Aug-97',885)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23475,128.1, '27-Jul-97',729)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23479,134.86, '26-Jun-98',1127)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23481,82.99, '16-Aug-98',1612)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23483,89.79, '26-Jan-98',149)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23486,185.3, '03-Jul-98',272)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23514,121.11, '22-Mar-98',446)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23525,42.76, '30-Dec-97',9)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23531,105.12, '29-Nov-97',843)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23532,208.58, '26-Dec-97',202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23543,220.53, '06-Oct-98',817)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23554,168.7, '21-Jan-98',939)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23555,212.48, '27-Oct-98',594)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23556,76.88, '04-Jul-97',142)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23559,204.65, '08-Aug-98',73)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23569,79.67, '17-May-99',1212)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23582,186.47, '07-Sep-98',1032)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23594,113.76, '03-May-98',1581)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23608,206.38, '25-Jun-98',1070)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23609,6.29, '06-Mar-99',1006)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23610,236.4, '05-Oct-97',305)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23613,193.73, '01-Feb-98',1881)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23623,116.41, '05-Jan-98',1931)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23640,185.61, '16-Nov-97',902)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23662,60.79, '12-Dec-97',544)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23665,20.69, '17-Feb-98',1153)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23680,51.56, '28-Jun-97',394)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23683,3.39, '24-Jan-99',765)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23684,198.33, '15-Jul-98',848)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23700,10.32, '16-Nov-98',416)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23702,146.04, '06-Feb-98',877)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23712,155.29, '21-Jul-98',1061)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23714,162.91, '08-Dec-98',1597)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23715,82.8, '10-Jun-97',17)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23720,8.67, '11-Jan-99',1325)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23735,190, '16-Jan-99',1293)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23737,72.92, '11-May-99',1338)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23744,127.6, '18-Dec-97',849)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23746,84.07, '26-Apr-99',217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23754,25.96, '05-Feb-98',28)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23758,245.76, '22-Apr-98',865)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23760,64.85, '20-Oct-97',414)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23763,159.9, '13-Feb-98',1114)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23771,209.51, '20-May-98',1133)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23782,155.25, '02-Jan-98',1291)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23784,36.29, '18-Aug-97',1458)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23791,1.89, '30-May-99',716)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23799,167.98, '12-Dec-98',1920)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23811,185.62, '07-Dec-98',1873)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23814,149.06, '13-Mar-99',387)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23838,95.37, '19-Dec-98',1886)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23847,192.46, '06-Aug-97',1841)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23849,237.29, '24-May-98',54)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23852,107.55, '22-Dec-98',940)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23882,44.64, '26-Sep-98',1715)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23899,207.95, '29-Sep-98',1011)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23901,153.62, '28-Aug-97',965)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23904,10.89, '21-Apr-98',1606)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23905,115.8, '15-Jan-98',970)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23906,59.5, '29-Mar-98',758)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23915,40.12, '25-Jun-98',1765)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23917,137.11, '28-Jan-98',637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23932,108.73, '24-Feb-99',48)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23945,158.55, '15-Jul-98',1533)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23946,199.22, '31-Aug-98',1035)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23951,234.34, '24-Sep-98',892)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23952,108.19, '19-Sep-97',549)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23956,147.49, '21-Mar-99',1123)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23958,38.15, '07-Jun-98',1614)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23962,82.75, '26-May-99',1487)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (23992,250.58, '06-Jun-98',1048)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24003,34.54, '14-Jul-97',1544)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24004,23.2, '21-Sep-97',1088)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24012,20.98, '25-Nov-98',225)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24014,228.76, '21-Jan-99',547)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24027,95.7, '24-Sep-98',1827)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24037,216.3, '13-Dec-98',750)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24039,69.04, '15-Oct-98',32)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24052,242.78, '24-Aug-98',12)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24056,36.09, '03-Jan-99',1239)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24062,48.02, '19-Apr-99',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24075,163.4, '05-Feb-99',1202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24096,120.44, '16-Sep-98',511)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24101,21.84, '24-Aug-97',1898)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24114,128.65, '05-Mar-99',628)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24119,204.05, '25-Jan-98',1073)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24122,147.1, '01-Oct-98',959)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24124,80.92, '04-Aug-98',1370)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24129,235.08, '05-May-99',335)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24130,51.19, '19-Oct-98',1352)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24141,206.5, '05-Nov-97',1328)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24151,153.52, '16-Feb-99',1123)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24174,168.12, '29-Jan-99',846)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24178,231.86, '30-Jul-98',1267)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24182,226, '20-Oct-98',179)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24197,231.12, '06-Jan-98',308)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24217,101.09, '10-Dec-98',1557)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24219,128.41, '03-Jul-97',1057)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24225,105.94, '13-Aug-97',1477)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24233,21.1, '13-Sep-98',1635)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24240,24.98, '27-Apr-99',1426)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24241,136.12, '30-Sep-98',625)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24244,60.82, '30-Jun-98',308)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24251,34.89, '04-Sep-97',822)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24269,152.55, '06-May-98',869)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24273,125.35, '12-Nov-97',1778)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24287,136.46, '04-May-98',172)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24290,241.03, '25-Oct-97',1659)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24294,228, '25-Mar-99',1359)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24295,231.91, '25-Jan-99',901)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24298,114.74, '13-Oct-98',1015)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24311,248.64, '25-Oct-98',377)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24316,56.08, '08-Sep-98',1051)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24318,137.77, '07-Oct-97',939)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24323,68.64, '29-Aug-98',681)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24326,112.12, '16-Jan-98',1392)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24337,67.25, '12-Jul-97',508)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24338,167.76, '09-Aug-97',1544)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24340,33.58, '01-Dec-98',1716)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24341,243.19, '20-Jan-99',1725)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24351,26.49, '23-Oct-97',1884)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24359,234.58, '25-Nov-98',1704)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24383,218.03, '20-Nov-98',1890)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24386,149.82, '01-Apr-99',1796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24397,240.9, '19-Jun-98',1347)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24402,113.87, '05-Jun-97',1128)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24403,101.62, '16-Jan-98',210)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24417,21.55, '15-Jan-99',1594)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24437,151.09, '23-Nov-98',1454)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24438,46.95, '27-Apr-99',447)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24447,98.18, '19-Sep-97',203)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24500,18.14, '26-Aug-98',1485)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24513,67.31, '09-Mar-98',569)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24519,193.33, '15-Dec-98',50)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24537,73.44, '27-Mar-99',278)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24549,139.84, '26-Nov-97',1492)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24564,127.79, '14-Sep-97',490)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24572,140.87, '03-Mar-99',1407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24576,128.98, '05-Feb-98',1845)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24587,82, '24-Sep-98',244)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24595,82.96, '17-Apr-98',759)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24605,25.39, '12-Aug-98',374)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24618,44.85, '09-Sep-98',1951)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24634,58.8, '26-Sep-97',1613)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24636,218.89, '22-Apr-98',207)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24646,231.95, '11-Oct-98',263)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24650,109.3, '09-Sep-98',1523)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24656,163.01, '08-Jan-99',342)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24661,204.67, '17-May-99',373)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24669,111.56, '25-Mar-99',1726)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24673,68.81, '16-Apr-98',31)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24676,212.94, '30-Dec-98',133)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24678,71.6, '15-Sep-97',4)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24679,153.07, '01-Sep-97',1735)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24686,26.46, '17-Mar-98',1149)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24702,200.73, '29-Aug-97',1048)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24711,115.38, '10-Sep-98',1873)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24730,112.83, '10-Jun-97',1061)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24738,22.84, '22-Jun-97',1498)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24744,171.97, '05-Jun-97',1577)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24748,140.5, '13-May-98',429)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24750,166.22, '05-Mar-98',366)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24755,115.33, '25-Jun-98',1265)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24757,126.41, '07-Jul-98',1859)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24758,83.78, '10-Aug-97',431)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24769,75.03, '15-Nov-98',412)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24770,225.63, '08-Feb-99',1993)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24790,165.52, '23-Nov-97',1783)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24793,133.53, '12-Oct-97',473)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24794,61.88, '03-Apr-99',674)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24806,51.75, '14-Jun-98',1426)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24811,145.71, '06-Sep-98',1730)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24812,205.67, '13-Nov-98',811)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24818,138.51, '05-Dec-98',1791)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24822,83.23, '14-Apr-99',381)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24860,244.92, '10-Aug-98',197)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24870,187.58, '07-Jun-98',614)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24871,26.7, '16-Mar-98',1567)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24877,70.97, '30-Jul-97',240)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24882,66.83, '19-Oct-98',1257)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24889,239.57, '06-Feb-98',1513)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24890,107.02, '25-Dec-98',65)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24893,188.85, '22-Aug-97',806)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24899,221.14, '07-Mar-98',395)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24915,86.43, '01-Nov-98',1361)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24917,6.86, '11-Dec-97',509)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24943,174.46, '18-Feb-98',934)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24947,113.46, '07-Sep-98',1931)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24951,138.98, '19-Mar-98',791)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24956,197.91, '30-Jan-99',1473)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24960,128.71, '28-Feb-98',1530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24971,123.73, '07-Jan-99',1870)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24977,175.99, '06-Jan-99',703)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24979,118.75, '06-Apr-99',685)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (24999,75.51, '04-Feb-99',126)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25001,136.16, '09-Mar-99',111)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25012,121.53, '17-Jun-98',88)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25039,93.99, '12-Feb-99',1567)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25056,224.48, '03-Aug-98',426)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25064,99.6, '02-Jan-99',836)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25069,6.35, '13-Dec-98',489)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25072,20.41, '17-Feb-98',723)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25075,246.27, '08-May-99',1047)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25076,11.81, '06-Oct-98',968)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25093,180.58, '19-Dec-97',903)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25094,151.09, '24-Jan-98',1025)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25111,238.04, '22-Mar-99',1744)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25116,149.87, '26-Nov-98',1022)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25120,212.58, '19-Apr-99',295)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25143,178.61, '21-Apr-98',1735)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25164,168.35, '09-Jan-98',1945)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25168,170.55, '01-Oct-97',1640)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25171,173.2, '23-Dec-97',62)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25172,76.46, '09-Aug-97',1321)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25177,154.5, '16-Oct-98',296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25186,88.22, '15-Jan-99',1572)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25195,49.08, '31-Dec-97',777)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25198,133.79, '03-May-99',1451)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25203,20.39, '22-Aug-97',1101)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25213,9.01, '02-Sep-97',185)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25216,81.08, '30-Dec-98',1007)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25218,133.91, '03-Feb-99',1012)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25219,216.71, '29-Sep-98',939)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25228,181.16, '01-Sep-98',1976)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25235,95.84, '11-Jan-98',323)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25236,22.06, '05-Jun-98',912)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25238,184.46, '31-Jul-97',1549)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25255,96.07, '30-Sep-97',57)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25259,93.25, '23-May-98',189)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25285,190.06, '20-Feb-99',1650)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25288,192.32, '16-Feb-98',1272)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25293,39.16, '24-Oct-98',946)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25296,23.22, '29-Jun-97',558)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25301,13.99, '27-Dec-98',245)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25303,229.26, '09-Feb-98',696)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25307,208.4, '19-Dec-97',1542)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25315,152.53, '06-Sep-98',1682)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25318,123.51, '03-Sep-97',1494)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25321,74.92, '27-Mar-98',1937)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25329,14.04, '31-Jan-98',1425)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25336,25.29, '29-Nov-97',1789)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25338,15.3, '20-Apr-98',754)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25353,47.34, '22-Jan-98',1317)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25359,52, '11-Oct-97',1862)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25375,39.58, '10-Aug-98',1140)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25380,138.31, '22-Dec-97',731)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25383,68.82, '05-Jul-97',1429)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25390,191.45, '19-Mar-98',1681)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25401,219.43, '27-Jul-97',965)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25406,72.25, '13-Oct-97',1288)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25411,136.78, '27-Feb-99',1078)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25424,17.19, '12-Nov-98',414)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25444,58.23, '12-Nov-98',147)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25448,160.59, '27-Nov-98',931)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25456,249.39, '02-Aug-97',1931)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25464,173.43, '16-Jul-97',1001)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25465,219.64, '30-Jan-99',76)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25469,148.15, '03-Jan-98',907)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25473,59.46, '12-Jul-97',568)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25479,217.59, '19-Mar-99',261)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25497,13.21, '19-Jan-98',1595)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25500,61.64, '13-Jul-98',1790)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25502,217.68, '31-Mar-98',1344)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25504,67.04, '29-Jan-99',683)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25510,168.33, '02-Aug-98',1637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25515,123.71, '08-Jan-99',179)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25518,218.03, '29-Jun-97',1757)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25523,7.06, '24-Mar-98',1586)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25531,108.06, '10-May-98',1943)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25552,152.49, '10-Nov-97',1207)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25565,2.71, '30-Dec-97',270)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25569,162.53, '07-Nov-97',1593)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25570,238.13, '15-May-99',598)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25575,226.03, '14-Dec-97',1495)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25580,104.32, '06-Aug-98',1176)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25581,214.46, '22-Oct-97',1465)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25588,145.82, '27-Oct-97',1446)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25592,210.88, '17-Oct-98',1150)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25608,208.9, '21-Jun-97',1117)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25610,28.06, '24-May-99',1870)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25613,84.64, '30-Nov-98',149)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25618,129.28, '01-Apr-99',249)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25621,111.84, '12-Apr-98',1470)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25622,45.84, '05-Jan-98',311)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25625,152.94, '13-Sep-98',755)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25633,4.63, '13-Feb-99',1319)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25634,189.18, '05-Jul-98',1881)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25638,186.02, '21-Nov-97',1654)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25644,63.76, '20-May-99',855)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25652,39.05, '13-Oct-98',685)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25653,131.19, '24-Dec-98',1165)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25661,185.32, '10-Oct-97',160)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25666,75.77, '26-Dec-98',266)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25679,14.97, '06-Feb-99',517)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25686,239.97, '06-Mar-99',1550)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25697,131.31, '16-Apr-98',1280)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25701,69.34, '11-Aug-98',1754)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25710,241.12, '19-Jun-98',1753)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25722,244.26, '01-Jun-98',306)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25727,75.51, '26-Aug-98',680)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25733,112.43, '03-Apr-99',1596)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25736,122.83, '19-Jan-99',445)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25739,1.63, '19-Jun-97',433)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25742,237.9, '25-Aug-97',863)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25745,194.2, '03-Jun-98',1873)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25749,246.62, '09-Dec-98',601)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25753,183.99, '22-Dec-98',852)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25757,197.99, '06-May-99',578)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25758,95.96, '13-Apr-99',324)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25759,114.89, '20-Jun-97',1330)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25760,90.57, '21-Sep-97',629)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25761,43.57, '15-May-99',1476)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25762,132.76, '05-Jan-98',1399)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25768,84.27, '28-Oct-97',1830)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25781,52.55, '18-Jul-97',530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25786,208.15, '10-Jul-97',1677)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25795,48.05, '15-Jun-98',184)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25814,169.72, '19-Sep-98',981)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25823,188.72, '13-Oct-97',932)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25825,240.4, '09-May-98',1905)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25829,43.06, '14-Jan-99',1471)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25830,196.26, '24-Nov-98',1562)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25843,248.69, '21-Jun-97',431)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25846,119.04, '10-May-99',1454)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25853,38.7, '13-Sep-98',1522)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25857,71.54, '24-Jul-98',333)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25861,120.73, '01-Aug-97',1547)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25864,178.07, '04-Apr-98',711)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25872,10.95, '16-Dec-98',1667)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25877,22.72, '24-Mar-99',669)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25881,103.34, '15-Nov-98',1887)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25890,216.66, '22-Feb-99',1856)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25895,110.94, '25-Oct-98',1292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25909,113.23, '26-Sep-97',832)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25913,199.29, '14-Jan-99',418)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25914,178.42, '17-Dec-98',1372)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25918,219.11, '22-Jun-97',184)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25923,51.43, '18-Feb-98',1761)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25924,118.65, '12-Feb-99',1825)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25926,124.3, '10-Apr-99',1838)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25931,74.86, '20-Jun-97',1598)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25938,98.91, '19-Jan-99',1448)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25942,240.77, '17-Nov-97',1350)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25946,106.5, '28-Apr-99',36)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25959,117.56, '23-Apr-99',455)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25962,159, '08-Aug-97',1616)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25970,29.97, '27-Sep-98',1797)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25977,230.13, '19-Oct-97',1404)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25983,8.13, '15-Jul-97',25)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25986,35.51, '23-Oct-98',1407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (25992,124.62, '02-Feb-99',1915)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26005,188.12, '19-Feb-99',1675)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26010,161.29, '07-Nov-98',352)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26015,118.67, '03-Mar-98',1145)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26020,108.2, '27-Feb-98',1680)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26028,247.28, '15-Aug-97',100)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26048,156.57, '06-Aug-97',832)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26077,141.67, '17-Jan-99',777)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26079,82.8, '09-Feb-98',1684)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26100,29.84, '18-Nov-98',1924)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26103,250.3, '07-Feb-99',599)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26111,186.4, '03-Jun-99',1104)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26126,212.91, '11-Oct-97',387)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26129,227.02, '22-Jan-98',115)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26132,151.85, '23-Jul-97',1045)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26134,79.07, '04-Sep-98',1785)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26135,181.97, '16-Mar-98',532)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26144,55.72, '18-Nov-97',79)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26148,124.91, '20-Jun-97',1683)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26153,176.34, '06-Aug-97',1106)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26157,201.45, '07-Feb-98',1743)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26158,212.63, '13-Apr-98',1197)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26161,173.78, '19-Apr-99',975)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26168,153.15, '16-Jan-99',296)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26182,90.52, '26-Jan-98',1403)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26188,85.6, '30-Jan-99',557)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26189,229.72, '14-Oct-98',1482)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26191,232.98, '07-Dec-97',1551)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26201,146.85, '23-Dec-98',1076)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26206,142.57, '24-Mar-98',1936)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26208,78.39, '01-Jul-98',183)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26211,54.55, '04-Jun-99',300)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26218,62.96, '26-Jul-98',771)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26221,15.89, '11-Jun-97',1279)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26223,226.9, '15-Jul-97',239)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26228,102.87, '16-Sep-98',637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26232,10.82, '07-Jun-97',956)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26235,218.47, '05-May-98',1271)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26244,158.94, '24-May-98',1831)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26249,245.81, '05-Sep-98',241)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26253,59.96, '30-Jan-98',1135)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26277,56.33, '28-Jul-97',362)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26278,136.15, '18-Oct-98',801)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26285,113.92, '11-Sep-98',1049)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26303,28.4, '14-Jan-98',730)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26304,249.26, '20-Jan-98',1246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26309,7.52, '17-Oct-97',1258)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26314,117.98, '08-Aug-97',1890)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26317,175.77, '14-Apr-99',1022)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26318,143.1, '29-Apr-98',1438)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26325,220.76, '09-Apr-99',790)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26330,152.67, '05-Aug-98',1698)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26332,160.84, '26-Jan-99',1776)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26342,19.01, '13-Feb-98',1629)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26349,247.52, '05-Nov-97',1054)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26350,165.56, '09-Jun-97',724)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26356,65.22, '27-Feb-98',287)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26357,184.8, '15-Jun-97',1774)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26380,228.75, '24-Sep-98',1352)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26381,77.16, '23-May-98',1144)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26383,175.78, '14-Dec-98',182)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26393,193.89, '19-Sep-98',402)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26396,111.39, '16-Nov-97',1396)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26399,53.67, '28-May-99',397)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26401,97.94, '29-Dec-98',1319)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26407,152.07, '13-Feb-98',1155)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26413,165.7, '28-Nov-98',1293)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26439,26.43, '19-May-99',707)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26440,199.39, '18-Apr-98',385)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26445,13.13, '28-May-99',1501)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26447,59.87, '07-Feb-99',194)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26449,138.1, '06-Nov-97',95)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26452,59.72, '11-Mar-99',172)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26455,197.3, '19-Sep-98',1208)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26459,184.35, '22-Mar-99',442)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26470,76.23, '27-Dec-97',240)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26477,119.45, '15-Nov-97',1767)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26478,122.99, '28-Nov-98',331)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26484,169.88, '28-Mar-99',876)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26498,200.16, '15-Jun-98',420)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26499,238.51, '24-Jul-97',1709)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26501,21.96, '14-Aug-97',364)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26504,65.96, '31-Aug-98',1104)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26506,10.62, '02-Dec-98',1022)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26517,10.88, '10-Jan-99',72)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26519,230.6, '20-Feb-99',546)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26549,27.28, '26-Jan-99',1408)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26558,191.97, '26-Aug-97',1147)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26566,219.7, '16-Jun-98',282)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26572,124.85, '14-Jan-99',506)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26585,57.13, '11-Aug-97',1838)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26589,29.64, '03-Feb-98',1285)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26592,144.32, '18-Sep-97',1977)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26606,219.73, '01-Jan-98',875)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26607,34.43, '12-Jun-98',312)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26634,177.52, '30-Jun-98',365)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26639,174.6, '30-Dec-98',1636)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26688,69.14, '06-Dec-97',1400)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26691,17.27, '08-May-98',911)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26693,102.6, '08-Aug-98',1580)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26697,178.03, '04-Feb-98',1930)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26709,118.21, '08-Dec-97',1464)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26724,217.37, '24-Dec-97',170)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26726,112.61, '07-Aug-98',274)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26736,149.65, '22-Sep-98',1895)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26745,91.23, '17-Aug-97',1520)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26749,34.59, '10-Mar-99',769)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26752,110.61, '02-Jul-98',1621)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26755,180.02, '04-Jun-98',1113)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26758,102.46, '18-Feb-99',1011)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26762,235.74, '11-Sep-97',645)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26771,19.62, '24-Feb-99',1904)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26772,34.79, '23-Dec-97',1408)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26775,216.59, '19-Nov-97',243)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26780,242.53, '04-Apr-98',290)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26786,242.69, '22-Jul-98',1301)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26788,63.18, '27-May-98',757)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26804,200.27, '16-Jul-98',823)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26828,103.91, '19-Oct-97',159)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26832,232.58, '10-Mar-99',703)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26835,195.22, '08-Nov-97',524)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26838,174.91, '15-Jul-97',179)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26840,36.06, '18-Oct-98',637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26843,207.29, '21-Jul-97',1950)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26854,91.77, '06-May-99',1697)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26860,101.42, '24-Jun-97',1785)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26878,215.95, '22-Dec-97',1043)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26890,183.26, '09-Jul-98',1864)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26891,61.57, '29-Oct-97',1560)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26896,212.78, '01-Dec-97',514)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26900,32.71, '03-May-99',1293)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26909,8.9, '12-Sep-97',1719)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26913,222.07, '29-Sep-98',68)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26919,193.19, '05-Jun-99',1017)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26936,130.85, '23-Jul-98',1188)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26940,58.12, '09-Oct-97',600)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26949,118.21, '08-Apr-99',1482)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26951,208.86, '23-Apr-98',1507)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26961,224.7, '15-Jan-99',251)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26965,169.4, '05-Jul-98',1600)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (26992,67.45, '26-Aug-97',1138)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27016,6.29, '28-Mar-98',292)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27020,176.91, '21-Aug-97',484)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27021,21.85, '23-Apr-98',255)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27032,163.39, '27-Jun-98',1329)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27053,36.28, '11-May-98',1576)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27054,11.4, '19-Aug-97',788)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27061,240.36, '02-Aug-98',743)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27074,12.49, '20-May-99',365)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27083,32.02, '08-Oct-98',381)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27094,206.33, '28-Jun-97',1854)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27098,42.43, '06-Jan-99',335)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27101,168.6, '20-Feb-99',1792)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27128,135.66, '31-Jul-98',1060)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27132,174.59, '29-Jun-97',1219)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27137,250.45, '15-Aug-97',488)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27143,138.82, '12-May-99',49)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27145,84.59, '03-Dec-98',104)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27151,110.98, '31-Jul-98',796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27207,18.96, '10-Jul-97',32)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27208,32.83, '13-Jul-97',1980)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27224,44.68, '01-Nov-98',380)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27225,138.19, '02-Mar-99',1856)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27230,217.92, '11-Nov-98',1602)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27237,28.71, '21-Dec-98',229)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27241,159, '28-Apr-99',938)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27249,230.54, '27-Oct-98',1305)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27255,2.92, '12-Aug-97',1345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27280,14.87, '03-Nov-97',550)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27281,170.36, '25-Sep-98',465)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27289,14.88, '03-Jan-99',147)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27292,52.44, '06-Nov-98',1939)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27297,230.19, '13-Feb-99',1474)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27299,65.38, '28-May-99',1985)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27307,81.9, '05-Jun-99',108)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27318,17.7, '14-Jul-97',1239)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27321,247.19, '20-Feb-98',1256)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27324,45.01, '14-Nov-97',197)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27333,73.97, '14-Jun-98',866)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27341,62.38, '01-Oct-97',1099)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27349,177.53, '20-Jul-97',1336)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27357,206.95, '31-May-98',170)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27359,239.98, '26-Mar-99',1692)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27360,73.61, '12-Jan-98',877)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27366,164.52, '26-Jul-98',1765)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27380,83.25, '11-Apr-98',1243)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27399,120.84, '13-Jun-97',1387)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27402,133.49, '26-Jan-98',1111)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27419,52.47, '25-Mar-99',1283)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27431,235.31, '24-Sep-98',880)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27443,10.11, '13-Jul-97',46)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27473,60.29, '24-Mar-98',407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27474,84.96, '03-Sep-98',1769)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27492,63.66, '06-Nov-97',183)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27502,87.65, '03-Mar-99',935)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27509,241.77, '28-Jun-98',1216)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27520,219.74, '01-Jan-99',52)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27532,165.65, '02-Jun-98',1665)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27536,2.83, '01-Aug-98',261)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27538,64.65, '27-May-98',1587)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27539,200.89, '15-Jun-97',819)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27542,85.96, '21-Jul-97',682)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27552,2.31, '02-Apr-98',251)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27563,111.35, '20-Jan-98',98)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27565,213.77, '19-Dec-97',677)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27573,203.43, '06-Feb-98',79)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27586,208.77, '11-Apr-98',1253)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27592,97.77, '01-Feb-98',435)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27606,209.93, '26-Nov-98',1453)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27611,50.61, '05-Feb-98',279)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27612,232.04, '02-Jun-98',1213)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27627,81.41, '22-Dec-97',681)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27635,188.09, '02-Dec-97',244)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27645,171.79, '21-Apr-99',954)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27682,159.04, '03-Aug-97',1683)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27710,202, '23-Feb-99',1944)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27721,30.07, '29-Aug-98',1773)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27743,103.82, '27-Aug-98',476)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27757,80, '10-Jul-97',457)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27766,163.11, '19-Jul-97',185)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27788,4.4, '22-Jul-97',381)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27808,26.85, '24-Nov-98',197)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27810,102.62, '04-Feb-99',1202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27824,28.31, '24-Jul-98',201)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27835,130.11, '03-Sep-98',212)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27851,82.86, '03-Feb-98',1757)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27858,182.51, '21-Feb-99',443)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27878,237.27, '15-Oct-97',1833)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27879,55.4, '13-Jun-97',1815)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27887,117.49, '06-Feb-99',1492)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27890,78.98, '03-Dec-98',557)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27906,66.73, '15-Jan-99',50)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27911,21.65, '17-Feb-99',312)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27914,82.72, '15-Aug-97',358)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27928,3.66, '22-Sep-97',1199)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27934,145.77, '01-Jul-97',553)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27938,186.52, '23-Mar-98',1658)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27943,27.43, '13-Jan-98',743)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27950,199.48, '10-Aug-98',1317)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27955,105.6, '11-Sep-98',260)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27956,2.8, '02-Dec-97',1898)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (27985,146.89, '01-Jun-99',562)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28000,131.44, '25-Aug-98',742)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28002,250.21, '26-May-98',363)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28003,30.53, '11-Oct-97',346)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28011,16.41, '18-Jul-98',1604)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28030,14.52, '12-Jan-98',434)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28041,63.68, '15-Oct-98',903)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28056,185.37, '06-Apr-99',644)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28067,101.38, '06-Jun-97',1603)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28070,250.47, '13-Jun-97',100)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28073,221.89, '14-Feb-98',1514)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28079,43.49, '01-Mar-98',5)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28080,86.42, '11-Feb-99',381)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28086,90.25, '18-Jun-97',1106)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28089,218.98, '06-May-98',435)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28091,195.14, '17-Mar-99',436)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28103,158.12, '18-Dec-98',1901)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28104,69.73, '29-Nov-98',1498)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28111,24.56, '18-Feb-99',275)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28118,211.53, '24-Apr-98',1052)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28138,151.49, '23-Dec-97',1465)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28149,194.36, '21-May-98',385)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28155,174.1, '09-Feb-99',1078)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28164,42.92, '08-May-98',1162)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28168,224.83, '04-Nov-97',811)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28184,9.4, '03-Jun-98',1027)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28185,226.18, '02-Dec-98',830)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28204,27.32, '23-Nov-97',198)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28213,8.8, '22-Jan-99',1591)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28221,237.82, '22-May-99',1759)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28223,229.08, '24-Oct-98',508)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28231,133.82, '21-May-99',1632)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28234,100.78, '18-Apr-99',1880)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28235,131.49, '10-Sep-97',101)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28237,2.95, '21-Sep-97',1635)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28250,118.68, '02-May-98',1571)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28253,19.04, '21-Jan-98',1527)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28254,42.27, '29-Jun-97',1269)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28255,141.99, '21-Apr-99',1979)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28284,204.39, '08-Aug-97',478)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28285,59.16, '15-Sep-98',1353)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28291,144.33, '08-Feb-98',1287)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28308,46.52, '12-Jul-97',1904)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28309,232.91, '24-May-99',90)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28317,108.17, '01-May-99',1239)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28318,64.46, '11-Feb-99',1365)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28334,139.92, '31-Oct-98',606)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28343,137.26, '07-Aug-98',526)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28344,196.03, '13-Apr-99',481)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28349,166.08, '05-Dec-97',1182)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28353,246.35, '31-Dec-98',1970)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28354,220.06, '15-May-98',710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28357,139.43, '09-Feb-99',474)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28364,41.54, '19-Nov-98',1827)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28365,198.99, '22-Mar-98',1176)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28368,192.95, '17-Nov-98',848)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28370,198.94, '05-Nov-97',1799)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28373,133.3, '31-Oct-97',1882)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28375,121.3, '25-Jul-97',810)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28380,25.96, '06-Jun-98',875)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28381,233.88, '04-Jul-98',1185)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28385,208.91, '08-Nov-98',1277)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28386,182.74, '22-Dec-97',1263)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28390,59.03, '05-Jan-99',1900)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28398,96.89, '15-Dec-97',1933)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28401,247.99, '17-Dec-97',484)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28408,123.86, '26-Jun-97',1610)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28413,59.57, '23-Jan-99',1246)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28415,177.82, '24-Feb-99',838)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28433,4.01, '12-Jan-99',1753)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28443,30.98, '13-Feb-98',305)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28445,143.16, '03-Aug-97',1365)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28455,69.56, '05-May-99',605)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28460,217.85, '04-Feb-98',1257)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28464,104.93, '17-Feb-99',183)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28466,131.42, '15-Nov-97',443)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28467,199.09, '10-Nov-97',474)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28475,222.04, '13-Mar-98',304)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28477,236.65, '05-Feb-98',1544)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28484,47.63, '20-Sep-97',933)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28486,97.75, '05-Oct-97',1239)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28493,36.35, '05-May-98',1655)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28497,232.48, '08-Aug-98',718)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28504,213.72, '05-Dec-97',462)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28506,237.06, '23-May-99',492)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28509,88.03, '31-Jul-98',1780)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28515,85.49, '19-May-98',1967)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28518,116.25, '18-Nov-98',511)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28526,53.31, '05-Jun-99',1539)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28528,136.5, '20-Sep-97',345)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28531,244.26, '01-Aug-97',1556)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28535,142.31, '14-Oct-98',1236)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28542,192.01, '22-Dec-98',1205)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28551,249.95, '17-Apr-98',1312)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28562,34.27, '26-Apr-99',550)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28569,177, '11-Feb-98',185)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28586,1.46, '11-Feb-98',103)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28602,28.24, '18-Jun-98',1523)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28612,207.61, '26-Apr-99',233)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28624,70.22, '31-Mar-99',1497)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28630,214.12, '21-Sep-97',651)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28638,140.81, '18-Apr-99',1613)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28643,201.51, '04-Feb-99',966)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28646,64.78, '16-May-98',59)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28661,188.05, '25-Feb-99',1596)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28663,30.07, '09-Jun-97',381)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28664,59.45, '14-May-98',970)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28673,78.39, '31-Dec-98',1423)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28678,19.05, '01-Jan-99',562)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28681,17.26, '06-Jan-98',1742)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28700,131.46, '13-Jul-97',1320)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28717,152.16, '26-Aug-98',998)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28722,194.48, '01-Jun-98',652)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28726,19.64, '03-Oct-97',1776)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28735,127.94, '01-Nov-97',1074)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28740,8.9, '14-Jul-98',469)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28741,234.51, '30-Nov-97',796)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28744,136.46, '03-Jul-97',1422)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28745,131.1, '23-Mar-99',1615)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28747,81.72, '30-Jul-98',1018)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28755,195.32, '03-Jul-98',624)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28763,57.18, '08-Aug-98',1054)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28768,91.36, '19-Mar-98',1518)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28771,207.84, '06-Jun-97',902)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28772,223.81, '19-Dec-98',206)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28774,153.62, '28-Jun-97',545)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28775,238.05, '09-Feb-98',637)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28791,58.13, '19-Sep-97',464)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28794,145.2, '06-Nov-97',479)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28796,123.98, '27-Jul-98',1190)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28799,147.4, '17-Apr-98',325)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28802,159.97, '09-Aug-97',1604)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28809,30.52, '03-May-98',1723)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28827,93.45, '06-Jan-99',407)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28833,167.82, '14-Nov-98',1472)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28834,212.55, '19-Aug-97',1103)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28847,158.54, '24-Dec-97',151)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28856,98.84, '17-Apr-98',1076)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28864,122.92, '23-Feb-98',1644)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28868,200.51, '18-May-99',1643)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28872,121.54, '24-Nov-98',1219)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28879,101.08, '22-May-98',1827)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28884,21.4, '08-Sep-97',1270)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28894,159.4, '14-Dec-97',1530)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28899,104.49, '25-May-99',1776)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28902,132.78, '27-Mar-98',1968)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28906,145.99, '11-Feb-98',805)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28907,120, '30-Sep-98',1569)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28917,29.78, '14-Apr-98',326)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28919,226.52, '15-Aug-97',1484)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28921,149.45, '30-Jun-97',131)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28945,59.98, '20-Dec-98',34)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28946,93.28, '22-Mar-99',631)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28966,18.6, '20-Mar-98',1156)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28967,111.68, '24-Aug-98',468)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28979,44.58, '09-Jan-99',689)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (28997,1.12, '31-Jul-98',698)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29000,247.94, '01-Dec-97',1954)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29006,213.29, '28-Nov-97',1383)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29009,68.07, '15-Oct-97',873)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29039,41.07, '28-Oct-97',1710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29046,21.88, '20-Feb-98',1526)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29054,120.49, '30-Nov-97',1976)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29062,249.01, '13-Jun-98',1784)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29066,70.02, '06-Mar-99',1009)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29073,112.75, '08-Jul-98',1948)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29079,151.68, '06-Feb-99',1266)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29083,87.33, '26-Sep-97',163)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29085,175.8, '11-Apr-99',1062)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29106,217.91, '01-Jun-98',498)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29111,56.68, '11-Apr-98',1023)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29121,19.51, '23-Jan-99',1501)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29123,58.5, '20-Apr-98',873)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29132,229.72, '06-Mar-99',786)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29134,25.45, '06-Feb-99',1693)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29138,66.96, '28-Aug-97',1960)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29139,191.57, '28-Nov-98',1957)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29142,216.72, '18-Feb-99',250)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29160,1.78, '08-Aug-98',1847)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29161,134.39, '12-Jan-98',878)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29178,16.47, '03-Aug-97',969)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29182,204.4, '17-Sep-97',762)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29186,165.61, '26-Aug-97',1332)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29198,78.27, '21-Apr-99',325)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29202,85.18, '13-Dec-97',371)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29203,43.06, '23-Feb-99',1749)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29205,53.9, '06-Jan-99',1505)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29214,130.02, '01-Jun-98',1074)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29217,3.01, '15-May-98',65)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29247,24.8, '11-Nov-98',1640)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29259,31.94, '16-Jun-97',1936)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29278,117.62, '16-Feb-98',936)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29282,28.93, '14-Mar-99',1177)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29288,130.13, '11-Apr-98',941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29291,24.37, '24-Jan-98',616)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29298,173.81, '24-Nov-98',1710)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29305,25.16, '23-Mar-98',658)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29307,185.63, '07-Apr-98',213)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29308,43.58, '14-Jul-97',1902)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29310,178.61, '19-Feb-99',486)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29316,10.46, '15-Aug-98',11)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29336,245.73, '23-Dec-97',1663)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29347,162.71, '24-Oct-98',967)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29355,69.54, '16-Jun-98',28)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29361,213.45, '18-May-99',307)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29364,90.72, '01-Aug-98',1337)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29368,250.64, '22-Apr-99',1671)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29373,162.38, '10-Oct-98',322)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29380,123.05, '30-Dec-98',715)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29381,205.88, '06-Oct-97',82)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29386,127.61, '30-May-99',1125)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29387,120.28, '30-Mar-98',759)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29389,85.6, '09-Sep-98',1253)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29401,160.84, '16-Feb-99',233)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29416,151.79, '29-Jul-97',973)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29436,124.51, '04-May-99',674)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29438,43.14, '08-Mar-98',1147)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29440,138.3, '12-Mar-98',1288)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29441,210.23, '08-Jun-97',16)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29442,122.94, '22-Jun-98',839)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29449,203.48, '24-Apr-98',687)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29452,41.75, '25-May-98',938)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29460,31.85, '02-Oct-97',870)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29462,16.38, '19-Sep-98',1991)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29476,148.18, '11-Dec-97',805)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29479,153.8, '13-Dec-97',331)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29488,87.38, '05-May-99',904)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29491,139.07, '10-Mar-98',903)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29492,123.22, '06-Nov-97',1457)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29499,231.17, '04-May-98',1201)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29504,4.87, '26-Mar-99',337)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29515,100.93, '26-Aug-98',519)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29521,153.67, '23-Dec-98',1029)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29540,69.09, '01-Nov-98',220)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29544,62.77, '02-Jul-98',1942)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29546,8.17, '02-Aug-98',1036)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29549,247.66, '12-Jan-98',122)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29553,155.75, '23-Sep-98',599)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29564,96.75, '07-Oct-98',383)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29582,194.6, '21-Jan-99',786)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29598,17.08, '12-Oct-98',11)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29611,100, '01-Feb-99',17)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29624,44.92, '24-Jul-98',94)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29629,192.83, '26-Sep-98',1982)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29639,143.18, '03-Apr-99',552)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29643,220.89, '07-Sep-98',1217)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29660,97.17, '11-Oct-97',312)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29663,160.24, '24-Feb-99',957)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29666,179.84, '10-Jul-97',202)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29670,210.28, '26-Oct-98',195)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29671,61.01, '24-May-98',396)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29692,209.3, '26-Oct-97',1030)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29699,66.73, '16-Jul-97',1290)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29701,9.25, '04-Mar-99',1015)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29709,130.08, '16-Oct-98',457)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29730,129.89, '01-Sep-98',1485)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29733,25.66, '19-Nov-97',680)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29737,171.77, '12-Mar-98',1492)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29769,232.13, '14-Oct-97',1458)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29778,156.41, '08-Nov-98',374)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29780,80.03, '04-Jan-99',935)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29808,37.75, '10-Nov-98',309)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29810,17.31, '24-Sep-98',254)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29812,229.72, '14-Aug-97',232)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29821,84.73, '22-Mar-98',1937)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29827,107.64, '14-Oct-97',1461)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29829,127.25, '17-Nov-97',28)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29840,206.69, '29-Sep-97',1416)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29848,6.22, '14-May-99',1321)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29858,73.48, '04-Mar-98',1004)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29866,227.81, '21-Jan-99',565)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29872,245.21, '25-Dec-98',1644)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29887,247.15, '14-Sep-98',941)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29904,151.31, '28-Jul-98',992)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29908,8.8, '22-Jul-98',351)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29933,84.84, '12-Nov-98',386)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29952,44.05, '11-Nov-97',242)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29967,105.99, '21-Jan-99',1798)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29978,58.63, '09-Feb-99',1434)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29981,27.42, '25-Jun-97',1012)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29986,157.37, '21-Apr-99',1460)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29989,222.12, '26-Sep-98',114)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (29991,195.92, '04-Apr-99',193)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30003,233.56, '10-May-99',1117)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30015,214.96, '23-Feb-99',614)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30016,191.25, '24-Feb-98',1166)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30018,114.12, '03-Aug-97',315)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30026,64.9, '08-May-98',184)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30030,147.33, '02-Dec-98',112)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30033,239.26, '01-Mar-98',1185)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30036,77.88, '22-Sep-97',705)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30040,27.82, '04-May-99',1310)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30056,112.79, '13-Jun-98',193)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30057,117.43, '23-Jul-98',37)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30065,132.66, '16-Jul-97',1693)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30075,20.04, '30-Jun-97',1823)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30084,67.22, '05-Dec-97',1431)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30085,34.17, '03-Mar-98',868)
INSERT INTO tblZamowienia (ID, Kwota, DataZamowienia,IDKlienta) Values (30099,33.02, '26-Aug-97',952)

SET IDENTITY_INSERT tblZamowienia OFF

